#!BPY
"""
Name: 'Ladder'
Blender: 248
Group: 'AddMesh'
Tooltip: 'Add a ladder mesh'
"""

__author__ = "Alejandro Sierra"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Ladder")
__version__ = "1.0"

__bpydoc__ = """\
This script adds a ladder for architectural or industrial sceneries.

This Script Relies on the module mesh_cube_wire.py that can be downloaded with this script.

mesh_cube_wire.py needs to be placed in the bpymodules folder.

"""


# --------------------------------------------------------------------------
# Copyright (C) 2008 Alejandro Sierra (AKA naturalpainter)
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------


from Blender import *
import bpy
import BPyAddMesh


import add_mesh_ladder_module

def create_mesh(width, height, total_height, depth):
    v = []
    e = []
    coords=[[-width, depth,0], [width,depth,0], [-width,0,0], [width,0,0]]

    y = height
    index = 2

    me = bpy.data.meshes.new('Ladder')          # create a new mesh

    if depth > 0:
        me.verts.extend(coords)
        e.extend([[0, 2], [3, 1]])
        index = 4
    else:
        me.verts.extend([coords[2],coords[3]])
        
    nsteps= int( total_height/height)
  
    for i in range(nsteps):
        for j in range(4):
            coords[j][2] = y
            
        me.verts.extend([coords[2],coords[3]])
        e.append([index, index+1])
        e.extend([[index-2,index],[index+1,index-1]])
        y += height
        index += 2

    if depth > 0:
        me.verts.extend([coords[0],coords[1]])
        e.extend([[index-2,index],[index+1,index-1]])
    else: 
        for j in range(4):
            coords[j][2] = y       
        me.verts.extend([coords[2],coords[3]])
        e.extend([[index-2,index],[index+1,index-1]])

    me.edges.extend(e)

    return me


def main():
    TOTALHEIGHT = Draw.Create(3.0)
    DEPTH = Draw.Create(0.0)
    WIDTH = Draw.Create(0.3)
    HEIGHT = Draw.Create(0.24)
    THICK = Draw.Create(0.02)

    if not Draw.PupBlock('Add Ladder', [\
        ('Total height:', TOTALHEIGHT, 0.1, 100, 'Total height of the ladder'),\
        ('Width:', WIDTH, .1, 100.0, 'Rung width'),\
        ('Height:', HEIGHT, .1, 100.0, 'Rung height'),\
        ('Depth:', DEPTH, 0.0, 100, 'Distance if fixed to the wall'),\
        ('Thick:', THICK, 0.0001, 10, 'Thickness of the rungs'),\
        ]):
                return
    
    Window.WaitCursor(1)
    me = create_mesh(WIDTH.val/2.0, HEIGHT.val, TOTALHEIGHT.val, DEPTH.val)
    add_mesh_ladder_module.create_wired_mesh(me, THICK.val/2.0)

    Window.WaitCursor(0)

# This lets you can import the script without running it
if __name__ == '__main__':
        main()
