# Do not edit this file. This file is auto generated from rna_manual_reference_updater.py

import bpy

if bpy.app.version_cycle in {'rc', 'release'}:
    manual_version = '%d.%d' % bpy.app.version[:2]
else:
    manual_version = 'dev'

url_manual_prefix = "https://docs.blender.org/manual/en/" + manual_version + "/"

language = ""
if bpy.context.preferences.view.use_international_fonts:
    language = bpy.context.preferences.view.language
    if language == 'DEFAULT':
        import os
        language = os.getenv('LANG', '').split('.')[0]

LANG = {
    "de_DE":        "de",
    "ru_RU":        "ru",
    "uk_UA":        "uk",
    "es":           "es",
    "fr_FR":        "fr",
    "it_IT":        "it",
    "ja_JP":        "ja",
    "ko_KR":        "ko",
    "pt_PT":        "pt",
    "pt_BR":        "pt",
    "vi_VN":        "vi",
    "zh_CN":        "zh-hans",
    "zh_TW":        "zh-hant",
}.get(language)

if LANG is not None:
    url_manual_prefix = url_manual_prefix.replace("manual/en", "manual/" + LANG)

url_manual_mapping = (
	("bpy.types.cyclesobjectsettings.use_adaptive_subdivision*", "render/cycles/object_settings/adaptive_subdiv.html#bpy-types-cyclesobjectsettings-use-adaptive-subdivision"),
	("bpy.types.cyclesrendersettings.offscreen_dicing_scale*", "render/cycles/render_settings/subdivision.html#bpy-types-cyclesrendersettings-offscreen-dicing-scale"),
	("bpy.types.linestylegeometrymodifier_backbonestretcher*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-backbonestretcher"),
	("bpy.types.linestylegeometrymodifier_sinusdisplacement*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-sinusdisplacement"),
	("bpy.types.linestylegeometrymodifier_polygonalization*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-polygonalization"),
	("bpy.types.cyclesrendersettings.distance_cull_margin*", "render/cycles/render_settings/simplify.html#bpy-types-cyclesrendersettings-distance-cull-margin"),
	("bpy.types.linestylegeometrymodifier_simplification*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-simplification"),
	("bpy.types.cyclesrendersettings.camera_cull_margin*", "render/cycles/render_settings/simplify.html#bpy-types-cyclesrendersettings-camera-cull-margin"),
	("bpy.types.linestylegeometrymodifier_perlinnoise1d*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-perlinnoise1d"),
	("bpy.types.linestylegeometrymodifier_perlinnoise2d*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-perlinnoise2d"),
	("bpy.types.smokedomainsettings.use_high_resolution*", "render/cycles/render_settings/simplify.html#bpy-types-smokedomainsettings-use-high-resolution"),
	("bpy.types.cyclesrendersettings.use_distance_cull*", "render/cycles/render_settings/simplify.html#bpy-types-cyclesrendersettings-use-distance-cull"),
	("bpy.types.linestylegeometrymodifier_guidinglines*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-guidinglines"),
	("bpy.types.linestylegeometrymodifier_spatialnoise*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-spatialnoise"),
	("bpy.types.linestylethicknessmodifier_calligraphy*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestylethicknessmodifier-calligraphy"),
	("bpy.types.cyclesrendersettings.max_subdivisions*", "render/cycles/render_settings/subdivision.html#bpy-types-cyclesrendersettings-max-subdivisions"),
	("bpy.types.linestyle*modifier_distancefromcamera*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-distancefromcamera"),
	("bpy.types.linestyle*modifier_distancefromobject*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-distancefromobject"),
	("bpy.types.linestylegeometrymodifier_2dtransform*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-2dtransform"),
	("bpy.types.linestylegeometrymodifier_beziercurve*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-beziercurve"),
	("bpy.types.cyclesrendersettings.use_camera_cull*", "render/cycles/render_settings/simplify.html#bpy-types-cyclesrendersettings-use-camera-cull"),
	("bpy.types.linestylegeometrymodifier_tipremover*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-tipremover"),
	("bpy.types.cyclesmaterialsettings.displacement*", "render/cycles/material_settings.html#bpy-types-cyclesmaterialsettings-displacement"),
	("bpy.types.linestylegeometrymodifier_blueprint*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-blueprint"),
	("bpy.types.rendersettings.simplify_subdivision*", "render/cycles/render_settings/simplify.html#bpy-types-rendersettings-simplify-subdivision"),
	("bpy.types.cyclesrendersettings.dicing_camera*", "render/cycles/render_settings/subdivision.html#bpy-types-cyclesrendersettings-dicing-camera"),
	("bpy.types.cyclesrendersettings.texture_limit*", "render/cycles/render_settings/simplify.html#bpy-types-cyclesrendersettings-texture-limit"),
	("bpy.types.linestylegeometrymodifier_2doffset*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-2doffset"),
	("bpy.types.linestylegeometrymodifier_sampling*", "render/freestyle/parameter_editor/line_style/modifiers/geometry.html#bpy-types-linestylegeometrymodifier-sampling"),
	("bpy.types.cyclesrendersettings.*dicing_rate*", "render/cycles/render_settings/subdivision.html#bpy-types-cyclesrendersettings-dicing-rate"),
	("bpy.types.rendersettings.use_file_extension*", "render/output/settings.html#bpy-types-rendersettings-use-file-extension"),
	("bpy.types.spaceview3d.transform_orientation*", "scene_layout/object/editing/transform/control/orientations.html#bpy-types-spaceview3d-transform-orientation"),
	("bpy.ops.object.constraint_add_with_targets*", "animation/constraints/interface/adding_removing.html#bpy-ops-object-constraint-add-with-targets"),
	("bpy.types.cyclesobjectsettings.dicing_rate*", "render/cycles/object_settings/adaptive_subdiv.html#bpy-types-cyclesobjectsettings-dicing-rate"),
	("bpy.types.posebone.use_ik_rotation_control*", "animation/armatures/posing/bone_constraints/inverse_kinematics/introduction.html#bpy-types-posebone-use-ik-rotation-control"),
	("bpy.types.spaceuveditor.use_snap_to_pixels*", "modeling/meshes/editing/uv/layout.html#bpy-types-spaceuveditor-use-snap-to-pixels"),
	("bpy.types.imagepaint.use_backface_culling*", "sculpt_paint/texture_paint/properties/options.html#bpy-types-imagepaint-use-backface-culling"),
	("bpy.types.linestyle*modifier_curvature_3d*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-curvature-3d"),
	("bpy.types.rendersettings.use_render_cache*", "render/output/settings.html#bpy-types-rendersettings-use-render-cache"),
	("bpy.types.sceneeevee.use_taa_reprojection*", "render/eevee/render_settings/sampling.html#bpy-types-sceneeevee-use-taa-reprojection"),
	("bpy.ops.object.anim_transforms_to_deltas*", "scene_layout/object/editing/transform/clear_apply.html#bpy-ops-object-anim-transforms-to-deltas"),
	("bpy.types.compositornodeplanetrackdeform*", "compositing/types/distort/plane_track_deform.html#bpy-types-compositornodeplanetrackdeform"),
	("bpy.types.linestyle*modifier_alongstroke*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-alongstroke"),
	("bpy.types.linestyle*modifier_creaseangle*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-creaseangle"),
	("bpy.types.rendersettings.use_placeholder*", "render/output/settings.html#bpy-types-rendersettings-use-placeholder"),
	("bpy.types.shadernodesubsurfacescattering*", "render/shader_nodes/shader/sss.html#bpy-types-shadernodesubsurfacescattering"),
	("bpy.types.compositornodecolorcorrection*", "compositing/types/color/color_correction.html#bpy-types-compositornodecolorcorrection"),
	("bpy.types.compositornodemoviedistortion*", "compositing/types/distort/movie_distortion.html#bpy-types-compositornodemoviedistortion"),
	("bpy.types.ffmpegsettings.audio_channels*", "scene_layout/scene/properties.html#bpy-types-ffmpegsettings-audio-channels"),
	("bpy.types.fmodifierenvelopecontrolpoint*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierenvelopecontrolpoint"),
	("bpy.types.sceneeevee.taa_render_samples*", "render/eevee/render_settings/sampling.html#bpy-types-sceneeevee-taa-render-samples"),
	("bpy.types.spaceuveditor.use_live_unwrap*", "modeling/meshes/editing/uv/layout.html#bpy-types-spaceuveditor-use-live-unwrap"),
	("bpy.types.vertexweightproximitymodifier*", "modeling/modifiers/modify/weight_proximity.html#bpy-types-vertexweightproximitymodifier"),
	("bpy.types.compositornodebrightcontrast*", "compositing/types/color/bright_contrast.html#bpy-types-compositornodebrightcontrast"),
	("bpy.types.compositornodedoubleedgemask*", "compositing/types/matte/double_edge_mask.html#bpy-types-compositornodedoubleedgemask"),
	("bpy.types.ffmpegsettings.audio_mixrate*", "scene_layout/scene/properties.html#bpy-types-ffmpegsettings-audio-mixrate"),
	("bpy.types.material.preview_render_type*", "render/materials/preview.html#bpy-types-material-preview-render-type"),
	("bpy.types.rendersettings.use_overwrite*", "render/output/settings.html#bpy-types-rendersettings-use-overwrite"),
	("bpy.types.sceneeevee.volumetric_shadow*", "render/eevee/render_settings/volumetrics.html#bpy-types-sceneeevee-volumetric-shadow"),
	("bpy.types.shadernodebsdfhairprincipled*", "render/shader_nodes/shader/hair_principled.html#bpy-types-shadernodebsdfhairprincipled"),
	("bpy.types.shadernodevectordisplacement*", "render/shader_nodes/vector/vector_displacement.html#bpy-types-shadernodevectordisplacement"),
	("bpy.types.spacegrapheditor.show_cursor*", "editors/graph_editor/fcurves/properties.html#bpy-types-spacegrapheditor-show-cursor"),
	("bpy.types.spaceimageeditor.show_repeat*", "editors/image/view_tab.html#bpy-types-spaceimageeditor-show-repeat"),
	("bpy.ops.object.visual_transform_apply*", "scene_layout/object/editing/transform/clear_apply.html#bpy-ops-object-visual-transform-apply"),
	("bpy.types.compositornodebilateralblur*", "compositing/types/filter/bilateral_blur.html#bpy-types-compositornodebilateralblur"),
	("bpy.types.compositornodedistancematte*", "compositing/types/matte/distance_key.html#bpy-types-compositornodedistancematte"),
	("bpy.types.imagepaint.screen_grab_size*", "sculpt_paint/texture_paint/properties/options.html#bpy-types-imagepaint-screen-grab-size"),
	("bpy.types.linestyle*modifier_material*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-material"),
	("bpy.types.particlesettingstextureslot*", "physics/particles/texture_influence.html#bpy-types-particlesettingstextureslot"),
	("bpy.types.posebone.ik_rotation_weight*", "animation/armatures/posing/bone_constraints/inverse_kinematics/introduction.html#bpy-types-posebone-ik-rotation-weight"),
	("bpy.types.sceneeevee.volumetric_light*", "render/eevee/render_settings/volumetrics.html#bpy-types-sceneeevee-volumetric-light"),
	("bpy.types.spaceview3d.cursor_location*", "editors/3dview/3d_cursor.html#bpy-types-spaceview3d-cursor-location"),
	("bpy.ops.mesh.normals_make_consistent*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-normals-make-consistent"),
	("bpy.ops.object.duplicate_move_linked*", "scene_layout/object/editing/duplication.html#bpy-ops-object-duplicate-move-linked"),
	("bpy.ops.view3d.localview_remove_from*", "editors/3dview/navigate/views.html#bpy-ops-view3d-localview-remove-from"),
	("bpy.types.compositornodechannelmatte*", "compositing/types/matte/channel_key.html#bpy-types-compositornodechannelmatte"),
	("bpy.types.compositornodecolorbalance*", "compositing/types/color/color_balance.html#bpy-types-compositornodecolorbalance"),
	("bpy.types.compositornodekeyingscreen*", "compositing/types/matte/keying_screen.html#bpy-types-compositornodekeyingscreen"),
	("bpy.types.dynamicpaintcanvassettings*", "physics/dynamic_paint/canvas.html#bpy-types-dynamicpaintcanvassettings"),
	("bpy.types.fmodifierfunctiongenerator*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierfunctiongenerator"),
	("bpy.types.linestyle*modifier_tangent*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-tangent"),
	("bpy.types.movietrackingstabilization*", "movie_clip/tracking/clip/properties/stabilization/index.html#bpy-types-movietrackingstabilization"),
	("bpy.types.object.display_bounds_type*", "scene_layout/object/properties/display.html#bpy-types-object-display-bounds-type"),
	("bpy.types.shadernodeambientocclusion*", "render/shader_nodes/input/ao.html#bpy-types-shadernodeambientocclusion"),
	("bpy.types.shadernodevolumeabsorption*", "render/shader_nodes/shader/volume_absorption.html#bpy-types-shadernodevolumeabsorption"),
	("bpy.types.shadernodevolumeprincipled*", "render/shader_nodes/shader/volume_principled.html#bpy-types-shadernodevolumeprincipled"),
	("bpy.types.toolsettings.use_uv_sculpt*", "modeling/meshes/editing/uv/uv_sculpt.html#bpy-types-toolsettings-use-uv-sculpt"),
	("bpy.ops.mesh.set_normals_from_faces*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-set-normals-from-faces"),
	("bpy.ops.object.duplicates_make_real*", "scene_layout/object/editing/transform/clear_apply.html#bpy-ops-object-duplicates-make-real"),
	("bpy.ops.object.transforms_to_deltas*", "scene_layout/object/editing/transform/clear_apply.html#bpy-ops-object-transforms-to-deltas"),
	("bpy.types.compositornodechromamatte*", "compositing/types/matte/chroma_key.html#bpy-types-compositornodechromamatte"),
	("bpy.types.compositornodedilateerode*", "compositing/types/filter/dilate_erode.html#bpy-types-compositornodedilateerode"),
	("bpy.types.compositornodeellipsemask*", "compositing/types/matte/ellipse_mask.html#bpy-types-compositornodeellipsemask"),
	("bpy.types.compositornodesplitviewer*", "compositing/types/output/split_viewer.html#bpy-types-compositornodesplitviewer"),
	("bpy.types.curve.use_uv_as_generated*", "editors/uv/generated_uvs.html#bpy-types-curve-use-uv-as-generated"),
	("bpy.types.dynamicpaintbrushsettings*", "physics/dynamic_paint/brush.html#bpy-types-dynamicpaintbrushsettings"),
	("bpy.types.rendersettings.use_border*", "render/output/settings.html#bpy-types-rendersettings-use-border"),
	("bpy.types.sceneeevee.bokeh_max_size*", "render/eevee/render_settings/depth_of_field.html#bpy-types-sceneeevee-bokeh-max-size"),
	("bpy.types.shadernodebsdfanisotropic*", "render/shader_nodes/shader/anisotropic.html#bpy-types-shadernodebsdfanisotropic"),
	("bpy.types.shadernodebsdftranslucent*", "render/shader_nodes/shader/translucent.html#bpy-types-shadernodebsdftranslucent"),
	("bpy.types.shadernodebsdftransparent*", "render/shader_nodes/shader/transparent.html#bpy-types-shadernodebsdftransparent"),
	("bpy.types.shadernodevectortransform*", "render/shader_nodes/vector/transform.html#bpy-types-shadernodevectortransform"),
	("bpy.types.spaceuveditor.lock_bounds*", "modeling/meshes/editing/uv/layout.html#bpy-types-spaceuveditor-lock-bounds"),
	("bpy.types.spline.tilt_interpolation*", "modeling/curves/properties/data.html#bpy-types-spline-tilt-interpolation"),
	("bpy.ops.mesh.quads_convert_to_tris*", "modeling/meshes/editing/faces.html#bpy-ops-mesh-quads-convert-to-tris"),
	("bpy.ops.node.read_fullsamplelayers*", "interface/controls/nodes/editing.html#bpy-ops-node-read-fullsamplelayers"),
	("bpy.ops.object.datalayout_transfer*", "modeling/meshes/editing/data_transfer.html#bpy-ops-object-datalayout-transfer"),
	("bpy.ops.object.randomize_transform*", "scene_layout/object/editing/transform/tools.html#bpy-ops-object-randomize-transform"),
	("bpy.ops.transform.edge_bevelweight*", "modeling/meshes/editing/edges.html#bpy-ops-transform-edge-bevelweight"),
	("bpy.ops.wm.previews_batch_generate*", "files/blend/previews.html#bpy-ops-wm-previews-batch-generate"),
	("bpy.types.compositornodebokehimage*", "compositing/types/input/bokeh_image.html#bpy-types-compositornodebokehimage"),
	("bpy.types.compositornodecolormatte*", "compositing/types/matte/color_key.html#bpy-types-compositornodecolormatte"),
	("bpy.types.compositornodecolorspill*", "compositing/types/matte/color_spill.html#bpy-types-compositornodecolorspill"),
	("bpy.types.compositornodehuecorrect*", "compositing/types/color/hue_correct.html#bpy-types-compositornodehuecorrect"),
	("bpy.types.compositornodeoutputfile*", "compositing/types/output/file.html#bpy-types-compositornodeoutputfile"),
	("bpy.types.compositornodeswitchview*", "compositing/types/converter/switch_view.html#bpy-types-compositornodeswitchview"),
	("bpy.types.copytransformsconstraint*", "animation/constraints/transform/copy_transforms.html#bpy-types-copytransformsconstraint"),
	("bpy.types.correctivesmoothmodifier*", "modeling/modifiers/deform/corrective_smooth.html#bpy-types-correctivesmoothmodifier"),
	("bpy.types.cyclesvisibilitysettings*", "render/cycles/object_settings/object_data.html#bpy-types-cyclesvisibilitysettings"),
	("bpy.types.imagepaint.interpolation*", "sculpt_paint/texture_paint/properties/texture_slots.html#bpy-types-imagepaint-interpolation"),
	("bpy.types.linestyle*modifier_noise*", "render/freestyle/parameter_editor/line_style/modifiers/properties.html#bpy-types-linestyle-modifier-noise"),
	("bpy.types.maintainvolumeconstraint*", "animation/constraints/transform/maintain_volume.html#bpy-types-maintainvolumeconstraint"),
	("bpy.types.mesh.use_mirror_topology*", "modeling/meshes/editing/mesh_options.html#bpy-types-mesh-use-mirror-topology"),
	("bpy.types.particleinstancemodifier*", "modeling/modifiers/simulate/particle_instance.html#bpy-types-particleinstancemodifier"),
	("bpy.types.shadernodebrightcontrast*", "render/shader_nodes/color/bright_contrast.html#bpy-types-shadernodebrightcontrast"),
	("bpy.types.shadernodebsdfprincipled*", "render/shader_nodes/shader/principled.html#bpy-types-shadernodebsdfprincipled"),
	("bpy.types.shadernodebsdfrefraction*", "render/shader_nodes/shader/refraction.html#bpy-types-shadernodebsdfrefraction"),
	("bpy.types.shadernodeoutputmaterial*", "render/shader_nodes/output/material.html#bpy-types-shadernodeoutputmaterial"),
	("bpy.types.shadernodetexenvironment*", "render/shader_nodes/textures/environment.html#bpy-types-shadernodetexenvironment"),
	("bpy.types.transformcacheconstraint*", "animation/constraints/transform/transform_cache.html#bpy-types-transformcacheconstraint"),
	("bpy.types.userpreferencesfilepaths*", "editors/preferences/file_paths.html#bpy-types-userpreferencesfilepaths"),
	("bpy.types.vertexweighteditmodifier*", "modeling/modifiers/modify/weight_edit.html#bpy-types-vertexweighteditmodifier"),
	("bpy.ops.curve.match_texture_space*", "editors/uv/generated_uvs.html#bpy-ops-curve-match-texture-space"),
	("bpy.ops.render.play-rendered-anim*", "render/output/animation_player.html#bpy-ops-render-play-rendered-anim"),
	("bpy.types.camera.show_composition*", "render/cameras.html#bpy-types-camera-show-composition"),
	("bpy.types.compositornodealphaover*", "compositing/types/color/alpha_over.html#bpy-types-compositornodealphaover"),
	("bpy.types.compositornodebokehblur*", "compositing/types/filter/bokeh_blur.html#bpy-types-compositornodebokehblur"),
	("bpy.types.compositornodecomposite*", "compositing/types/output/composite.html#bpy-types-compositornodecomposite"),
	("bpy.types.compositornodedespeckle*", "compositing/types/filter/despeckle.html#bpy-types-compositornodedespeckle"),
	("bpy.types.compositornodediffmatte*", "compositing/types/matte/difference_key.html#bpy-types-compositornodediffmatte"),
	("bpy.types.compositornodelumamatte*", "compositing/types/matte/luminance_key.html#bpy-types-compositornodelumamatte"),
	("bpy.types.compositornodemovieclip*", "compositing/types/input/movie_clip.html#bpy-types-compositornodemovieclip"),
	("bpy.types.compositornodenormalize*", "compositing/types/vector/normalize.html#bpy-types-compositornodenormalize"),
	("bpy.types.compositornodepremulkey*", "compositing/types/converter/alpha_convert.html#bpy-types-compositornodepremulkey"),
	("bpy.types.compositornodestabilize*", "compositing/types/distort/stabilize_2d.html#bpy-types-compositornodestabilize"),
	("bpy.types.compositornodetransform*", "compositing/types/distort/transform.html#bpy-types-compositornodetransform"),
	("bpy.types.compositornodetranslate*", "compositing/types/distort/translate.html#bpy-types-compositornodetranslate"),
	("bpy.types.fluidsimulationmodifier*", "physics/fluid/index.html#bpy-types-fluidsimulationmodifier"),
	("bpy.types.freestylemodulesettings*", "render/freestyle/python.html#bpy-types-freestylemodulesettings"),
	("bpy.types.laplaciandeformmodifier*", "modeling/modifiers/deform/laplacian_deform.html#bpy-types-laplaciandeformmodifier"),
	("bpy.types.laplaciansmoothmodifier*", "modeling/modifiers/deform/laplacian_smooth.html#bpy-types-laplaciansmoothmodifier"),
	("bpy.types.limitdistanceconstraint*", "animation/constraints/transform/limit_distance.html#bpy-types-limitdistanceconstraint"),
	("bpy.types.limitlocationconstraint*", "animation/constraints/transform/limit_location.html#bpy-types-limitlocationconstraint"),
	("bpy.types.limitrotationconstraint*", "animation/constraints/transform/limit_rotation.html#bpy-types-limitrotationconstraint"),
	("bpy.types.rendersettings.filepath*", "render/output/settings.html#bpy-types-rendersettings-filepath"),
	("bpy.types.shadernodeeeveespecular*", "render/shader_nodes/shader/specular_bsdf.html#bpy-types-shadernodeeeveespecular"),
	("bpy.types.shadernodehuesaturation*", "render/shader_nodes/color/hue_saturation.html#bpy-types-shadernodehuesaturation"),
	("bpy.types.shadernodevolumescatter*", "render/shader_nodes/shader/volume_scatter.html#bpy-types-shadernodevolumescatter"),
	("bpy.types.spacegrapheditor.cursor*", "editors/graph_editor/introduction.html#bpy-types-spacegrapheditor-cursor"),
	("bpy.types.vertexweightmixmodifier*", "modeling/modifiers/modify/weight_mix.html#bpy-types-vertexweightmixmodifier"),
	("bpy.ops.object.constraints_clear*", "animation/constraints/interface/adding_removing.html#bpy-ops-object-constraints-clear"),
	("bpy.ops.uv.average_islands_scale*", "modeling/meshes/editing/uv/layout.html#bpy-ops-uv-average-islands-scale"),
	("bpy.ops.view3d.edit_mesh_extrude*", "modeling/meshes/editing/duplicating/extrude.html#bpy-ops-view3d-edit-mesh-extrude"),
	("bpy.types.brightcontrastmodifier*", "sequencer/sequencer/properties/modifiers.html#bpy-types-brightcontrastmodifier"),
	("bpy.types.camerasolverconstraint*", "animation/constraints/motion_tracking/camera_solver.html#bpy-types-camerasolverconstraint"),
	("bpy.types.clothcollisionsettings*", "physics/cloth/settings/collisions.html#bpy-types-clothcollisionsettings"),
	("bpy.types.compositornodecurvergb*", "compositing/types/color/rgb_curves.html#bpy-types-compositornodecurvergb"),
	("bpy.types.compositornodecurvevec*", "compositing/types/vector/vector_curves.html#bpy-types-compositornodecurvevec"),
	("bpy.types.compositornodedisplace*", "compositing/types/distort/displace.html#bpy-types-compositornodedisplace"),
	("bpy.types.compositornodelensdist*", "compositing/types/distort/lens_distortion.html#bpy-types-compositornodelensdist"),
	("bpy.types.compositornodemaprange*", "compositing/types/vector/map_range.html#bpy-types-compositornodemaprange"),
	("bpy.types.compositornodemapvalue*", "compositing/types/vector/map_value.html#bpy-types-compositornodemapvalue"),
	("bpy.types.compositornodepixelate*", "compositing/types/filter/pixelate.html#bpy-types-compositornodepixelate"),
	("bpy.types.compositornodesetalpha*", "compositing/types/converter/set_alpha.html#bpy-types-compositornodesetalpha"),
	("bpy.types.compositornodesunbeams*", "compositing/types/filter/sun_beams.html#bpy-types-compositornodesunbeams"),
	("bpy.types.compositornodetrackpos*", "compositing/types/input/track_position.html#bpy-types-compositornodetrackpos"),
	("bpy.types.compositornodezcombine*", "compositing/types/color/z_combine.html#bpy-types-compositornodezcombine"),
	("bpy.types.copylocationconstraint*", "animation/constraints/transform/copy_location.html#bpy-types-copylocationconstraint"),
	("bpy.types.copyrotationconstraint*", "animation/constraints/transform/copy_rotation.html#bpy-types-copyrotationconstraint"),
	("bpy.types.cyclesmaterialsettings*", "render/cycles/material_settings.html#bpy-types-cyclesmaterialsettings"),
	("bpy.types.imagepaint.use_occlude*", "sculpt_paint/texture_paint/properties/options.html#bpy-types-imagepaint-use-occlude"),
	("bpy.types.mesh.auto_smooth_angle*", "modeling/meshes/structure.html#bpy-types-mesh-auto-smooth-angle"),
	("bpy.types.objectsolverconstraint*", "animation/constraints/motion_tracking/object_solver.html#bpy-types-objectsolverconstraint"),
	("bpy.types.particlesystemmodifier*", "physics/particles/index.html#bpy-types-particlesystemmodifier"),
	("bpy.types.sceneeevee.motion_blur*", "render/eevee/render_settings/motion_blur.html#bpy-types-sceneeevee-motion-blur"),
	("bpy.types.sceneeevee.taa_samples*", "render/eevee/render_settings/sampling.html#bpy-types-sceneeevee-taa-samples"),
	("bpy.types.shadernodedisplacement*", "render/shader_nodes/vector/displacement.html#bpy-types-shadernodedisplacement"),
	("bpy.types.shadernodelightfalloff*", "render/shader_nodes/color/light_falloff.html#bpy-types-shadernodelightfalloff"),
	("bpy.types.shadernodeparticleinfo*", "render/shader_nodes/input/particle_info.html#bpy-types-shadernodeparticleinfo"),
	("bpy.types.weightednormalmodifier*", "modeling/modifiers/modify/weighted_normal.html#bpy-types-weightednormalmodifier"),
	("bpy.ops.object.constraints_copy*", "animation/constraints/interface/adding_removing.html#bpy-ops-object-constraints-copy"),
	("bpy.ops.object.make_single_user*", "scene_layout/object/editing/duplication.html#bpy-ops-object-make-single-user"),
	("bpy.ops.object.select_hierarchy*", "scene_layout/object/selecting.html#bpy-ops-object-select-hierarchy"),
	("bpy.ops.screen.screen_full_area*", "interface/window_system/areas.html#bpy-ops-screen-screen-full-area"),
	("bpy.ops.transform.rotate_normal*", "modeling/meshes/editing/normals.html#bpy-ops-transform-rotate-normal"),
	("bpy.ops.transform.shrink_fatten*", "modeling/meshes/editing/transform/shrink-fatten.html#bpy-ops-transform-shrink-fatten"),
	("bpy.ops.wm.dependency_relations*", "advanced/operators.html#bpy-ops-wm-dependency-relations"),
	("bpy.ops.wm.previews_batch_clear*", "files/blend/previews.html#bpy-ops-wm-previews-batch-clear"),
	("bpy.types.camerabackgroundimage*", "render/cameras.html#bpy-types-camerabackgroundimage"),
	("bpy.types.compositornodeboxmask*", "compositing/types/matte/box_mask.html#bpy-types-compositornodeboxmask"),
	("bpy.types.compositornodedefocus*", "compositing/types/filter/defocus.html#bpy-types-compositornodedefocus"),
	("bpy.types.compositornodeinpaint*", "compositing/types/filter/inpaint.html#bpy-types-compositornodeinpaint"),
	("bpy.types.compositornodergbtobw*", "compositing/types/converter/rgb_to_bw.html#bpy-types-compositornodergbtobw"),
	("bpy.types.compositornoderlayers*", "compositing/types/input/render_layers.html#bpy-types-compositornoderlayers"),
	("bpy.types.compositornodetexture*", "compositing/types/input/texture.html#bpy-types-compositornodetexture"),
	("bpy.types.compositornodetonemap*", "compositing/types/color/tone_map.html#bpy-types-compositornodetonemap"),
	("bpy.types.compositornodevecblur*", "compositing/types/filter/vector_blur.html#bpy-types-compositornodevecblur"),
	("bpy.types.dampedtrackconstraint*", "animation/constraints/tracking/damped_track.html#bpy-types-dampedtrackconstraint"),
	("bpy.types.distortednoisetexture*", "render/materials/legacy_textures/types/distorted_noise.html#bpy-types-distortednoisetexture"),
	("bpy.types.followtrackconstraint*", "animation/constraints/motion_tracking/follow_track.html#bpy-types-followtrackconstraint"),
	("bpy.types.lockedtrackconstraint*", "animation/constraints/tracking/locked_track.html#bpy-types-lockedtrackconstraint"),
	("bpy.types.obstaclefluidsettings*", "physics/fluid/types/obstacle.html#bpy-types-obstaclefluidsettings"),
	("bpy.types.particlefluidsettings*", "physics/particles/emitter/physics/fluid.html#bpy-types-particlefluidsettings"),
	("bpy.types.sceneeevee.volumetric*", "render/eevee/render_settings/volumetrics.html#bpy-types-sceneeevee-volumetric"),
	("bpy.types.shadernodebsdfdiffuse*", "render/shader_nodes/shader/diffuse.html#bpy-types-shadernodebsdfdiffuse"),
	("bpy.types.shadernodelayerweight*", "render/shader_nodes/input/layer_weight.html#bpy-types-shadernodelayerweight"),
	("bpy.types.shadernodeoutputlight*", "render/shader_nodes/output/light.html#bpy-types-shadernodeoutputlight"),
	("bpy.types.shadernodeoutputworld*", "render/shader_nodes/output/world.html#bpy-types-shadernodeoutputworld"),
	("bpy.types.shadernodetexgradient*", "render/shader_nodes/textures/gradient.html#bpy-types-shadernodetexgradient"),
	("bpy.types.shadernodetexmusgrave*", "render/shader_nodes/textures/musgrave.html#bpy-types-shadernodetexmusgrave"),
	("bpy.types.shadernodevectorcurve*", "render/shader_nodes/vector/curves.html#bpy-types-shadernodevectorcurve"),
	("bpy.types.userpreferencessystem*", "editors/preferences/system.html#bpy-types-userpreferencessystem"),
	("bpy.ops.mesh.bridge-edge-loops*", "modeling/meshes/editing/edges.html#bpy-ops-mesh-bridge-edge-loops"),
	("bpy.ops.object.paths_calculate*", "animation/motion_paths.html#bpy-ops-object-paths-calculate"),
	("bpy.ops.object.transform_apply*", "scene_layout/object/editing/transform/clear_apply.html#bpy-ops-object-transform-apply"),
	("bpy.ops.outliner.lib_operation*", "files/linked_libraries.html#bpy-ops-outliner-lib-operation"),
	("bpy.ops.screen.region_quadview*", "editors/3dview/navigate/views.html#bpy-ops-screen-region-quadview"),
	("bpy.ops.uv.follow_active_quads*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-follow-active-quads"),
	("bpy.types.colorbalancemodifier*", "sequencer/sequencer/properties/modifiers.html#bpy-types-colorbalancemodifier"),
	("bpy.types.compositornodefilter*", "compositing/types/filter/filter_node.html#bpy-types-compositornodefilter"),
	("bpy.types.compositornodehuesat*", "compositing/types/color/hue_saturation.html#bpy-types-compositornodehuesat"),
	("bpy.types.compositornodeidmask*", "compositing/types/converter/id_mask.html#bpy-types-compositornodeidmask"),
	("bpy.types.compositornodeinvert*", "compositing/types/color/invert.html#bpy-types-compositornodeinvert"),
	("bpy.types.compositornodekeying*", "compositing/types/matte/keying.html#bpy-types-compositornodekeying"),
	("bpy.types.compositornodelevels*", "compositing/types/output/levels.html#bpy-types-compositornodelevels"),
	("bpy.types.compositornodemixrgb*", "compositing/types/color/mix.html#bpy-types-compositornodemixrgb"),
	("bpy.types.compositornodenormal*", "compositing/types/vector/normal.html#bpy-types-compositornodenormal"),
	("bpy.types.compositornoderotate*", "compositing/types/distort/rotate.html#bpy-types-compositornoderotate"),
	("bpy.types.compositornodeviewer*", "compositing/types/output/viewer.html#bpy-types-compositornodeviewer"),
	("bpy.types.constraint.influence*", "animation/constraints/interface/common.html#bpy-types-constraint-influence"),
	("bpy.types.controlfluidsettings*", "physics/fluid/types/control.html#bpy-types-controlfluidsettings"),
	("bpy.types.datatransfermodifier*", "modeling/modifiers/modify/data_transfer.html#bpy-types-datatransfermodifier"),
	("bpy.types.dynamicpaintmodifier*", "physics/dynamic_paint/index.html#bpy-types-dynamicpaintmodifier"),
	("bpy.types.ffmpegsettings.audio*", "render/output/file_formats.html#bpy-types-ffmpegsettings-audio"),
	("bpy.types.followpathconstraint*", "animation/constraints/relationship/follow_path.html#bpy-types-followpathconstraint"),
	("bpy.types.gaussianblursequence*", "sequencer/sequencer/strips/effects/blur.html#bpy-types-gaussianblursequence"),
	("bpy.types.image.display_aspect*", "editors/image/view_tab.html#bpy-types-image-display-aspect"),
	("bpy.types.limitscaleconstraint*", "animation/constraints/transform/limit_scale.html#bpy-types-limitscaleconstraint"),
	("bpy.types.mesh.use_auto_smooth*", "modeling/meshes/structure.html#bpy-types-mesh-use-auto-smooth"),
	("bpy.types.outflowfluidsettings*", "physics/fluid/types/flow.html#bpy-types-outflowfluidsettings"),
	("bpy.types.scene.background_set*", "scene_layout/scene/properties.html#bpy-types-scene-background-set"),
	("bpy.types.shadernodebackground*", "render/shader_nodes/shader/background.html#bpy-types-shadernodebackground"),
	("bpy.types.shadernodebsdfglossy*", "render/shader_nodes/shader/glossy.html#bpy-types-shadernodebsdfglossy"),
	("bpy.types.shadernodebsdfvelvet*", "render/shader_nodes/shader/velvet.html#bpy-types-shadernodebsdfvelvet"),
	("bpy.types.shadernodecameradata*", "render/shader_nodes/input/camera_data.html#bpy-types-shadernodecameradata"),
	("bpy.types.shadernodeobjectinfo*", "render/shader_nodes/input/object_info.html#bpy-types-shadernodeobjectinfo"),
	("bpy.types.shadernodetexchecker*", "render/shader_nodes/textures/checker.html#bpy-types-shadernodetexchecker"),
	("bpy.types.shadernodetexvoronoi*", "render/shader_nodes/textures/voronoi.html#bpy-types-shadernodetexvoronoi"),
	("bpy.types.shadernodevectormath*", "render/shader_nodes/converter/vector_math.html#bpy-types-shadernodevectormath"),
	("bpy.types.shadernodewavelength*", "render/shader_nodes/converter/wavelength.html#bpy-types-shadernodewavelength"),
	("bpy.types.shrinkwrapconstraint*", "animation/constraints/relationship/shrinkwrap.html#bpy-types-shrinkwrapconstraint"),
	("bpy.types.simpledeformmodifier*", "modeling/modifiers/deform/simple_deform.html#bpy-types-simpledeformmodifier"),
	("bpy.types.spacedopesheeteditor*", "editors/dope_sheet/index.html#bpy-types-spacedopesheeteditor"),
	("bpy.types.spaceuserpreferences*", "editors/preferences/index.html#bpy-types-spaceuserpreferences"),
	("bpy.types.speedcontrolsequence*", "sequencer/sequencer/strips/effects/speed_control.html#bpy-types-speedcontrolsequence"),
	("bpy.types.texturenodecurvetime*", "editors/texture_node/types/input/time.html#bpy-types-texturenodecurvetime"),
	("bpy.types.transformorientation*", "scene_layout/object/editing/transform/control/orientations.html#bpy-types-transformorientation"),
	("bpy.types.unifiedpaintsettings*", "sculpt_paint/texture_paint/properties/options.html#bpy-types-unifiedpaintsettings"),
	("bpy.types.userpreferencesinput*", "editors/preferences/input.html#bpy-types-userpreferencesinput"),
	("bpy.types.whitebalancemodifier*", "sequencer/sequencer/properties/modifiers.html#bpy-types-whitebalancemodifier"),
	("bpy.ops.mesh.smoothen_normals*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-smoothen-normals"),
	("bpy.ops.object.duplicate_move*", "scene_layout/object/editing/duplication.html#bpy-ops-object-duplicate-move"),
	("bpy.ops.object.select_by_type*", "scene_layout/object/selecting.html#bpy-ops-object-select-by-type"),
	("bpy.ops.object.select_grouped*", "scene_layout/object/selecting.html#bpy-ops-object-select-grouped"),
	("bpy.ops.object.select_pattern*", "scene_layout/object/selecting.html#bpy-ops-object-select-pattern"),
	("bpy.ops.screen.repeat_history*", "interface/undo_redo.html#bpy-ops-screen-repeat-history"),
	("bpy.ops.sequencer.refresh_all*", "sequencer/sequencer/navigating.html#bpy-ops-sequencer-refresh-all"),
	("bpy.ops.transform.edge_crease*", "modeling/meshes/editing/edges.html#bpy-ops-transform-edge-crease"),
	("bpy.ops.uv.seams_from_islands*", "modeling/meshes/editing/uv/unwrapping/seams.html#bpy-ops-uv-seams-from-islands"),
	("bpy.types.camera.display_size*", "render/cameras.html#bpy-types-camera-display-size"),
	("bpy.types.compositornodedblur*", "compositing/types/filter/directional_blur.html#bpy-types-compositornodedblur"),
	("bpy.types.compositornodegamma*", "compositing/types/color/gamma.html#bpy-types-compositornodegamma"),
	("bpy.types.compositornodeglare*", "compositing/types/filter/glare.html#bpy-types-compositornodeglare"),
	("bpy.types.compositornodegroup*", "compositing/types/groups.html#bpy-types-compositornodegroup"),
	("bpy.types.compositornodeimage*", "compositing/types/input/image.html#bpy-types-compositornodeimage"),
	("bpy.types.compositornodemapuv*", "compositing/types/distort/map_uv.html#bpy-types-compositornodemapuv"),
	("bpy.types.compositornodescale*", "compositing/types/distort/scale.html#bpy-types-compositornodescale"),
	("bpy.types.compositornodevalue*", "compositing/types/input/value.html#bpy-types-compositornodevalue"),
	("bpy.types.copyscaleconstraint*", "animation/constraints/transform/copy_scale.html#bpy-types-copyscaleconstraint"),
	("bpy.types.cyclesworldsettings*", "render/cycles/world_settings.html#bpy-types-cyclesworldsettings"),
	("bpy.types.domainfluidsettings*", "physics/fluid/types/domain.html#bpy-types-domainfluidsettings"),
	("bpy.types.imageformatsettings*", "files/media/image_formats.html#bpy-types-imageformatsettings"),
	("bpy.types.inflowfluidsettings*", "physics/fluid/types/flow.html#bpy-types-inflowfluidsettings"),
	("bpy.types.kinematicconstraint*", "animation/constraints/tracking/ik_solver.html#bpy-types-kinematicconstraint"),
	("bpy.types.movietrackingcamera*", "movie_clip/tracking/clip/properties/camera_data.html#bpy-types-movietrackingcamera"),
	("bpy.types.object.display_type*", "scene_layout/object/properties/display.html#bpy-types-object-display-type"),
	("bpy.types.particledupliweight*", "physics/particles/emitter/vertex_groups.html#bpy-types-particledupliweight"),
	("bpy.types.poseboneconstraints*", "animation/armatures/posing/bone_constraints/index.html#bpy-types-poseboneconstraints"),
	("bpy.types.rigidbodyconstraint*", "physics/rigid_body/constraints/index.html#bpy-types-rigidbodyconstraint"),
	("bpy.types.shadernodeaddshader*", "render/shader_nodes/shader/add.html#bpy-types-shadernodeaddshader"),
	("bpy.types.shadernodeattribute*", "render/shader_nodes/input/attribute.html#bpy-types-shadernodeattribute"),
	("bpy.types.shadernodeblackbody*", "render/shader_nodes/converter/blackbody.html#bpy-types-shadernodeblackbody"),
	("bpy.types.shadernodebsdfglass*", "render/shader_nodes/shader/glass.html#bpy-types-shadernodebsdfglass"),
	("bpy.types.shadernodelightpath*", "render/shader_nodes/input/light_path.html#bpy-types-shadernodelightpath"),
	("bpy.types.shadernodemixshader*", "render/shader_nodes/shader/mix.html#bpy-types-shadernodemixshader"),
	("bpy.types.shadernodenormalmap*", "render/shader_nodes/vector/normal_map.html#bpy-types-shadernodenormalmap"),
	("bpy.types.shadernodewireframe*", "render/shader_nodes/input/wireframe.html#bpy-types-shadernodewireframe"),
	("bpy.types.smokedomainsettings*", "physics/smoke/types/domain.html#bpy-types-smokedomainsettings"),
	("bpy.types.spacesequenceeditor*", "sequencer/index.html#bpy-types-spacesequenceeditor"),
	("bpy.types.stretchtoconstraint*", "animation/constraints/tracking/stretch_to.html#bpy-types-stretchtoconstraint"),
	("bpy.types.texturenodecurvergb*", "editors/texture_node/types/color/rgb_curves.html#bpy-types-texturenodecurvergb"),
	("bpy.types.texturenodevaltorgb*", "editors/texture_node/types/converter/rgb_to_bw.html#bpy-types-texturenodevaltorgb"),
	("bpy.types.transformconstraint*", "animation/constraints/transform/transformation.html#bpy-types-transformconstraint"),
	("bpy.types.triangulatemodifier*", "modeling/modifiers/generate/triangulate.html#bpy-types-triangulatemodifier"),
	("bpy.types.userpreferencesedit*", "editors/preferences/editing.html#bpy-types-userpreferencesedit"),
	("bpy.types.userpreferencesview*", "editors/preferences/interface.html#bpy-types-userpreferencesview"),
	("bpy.types.windowmanager.addon*", "editors/preferences/addons.html#bpy-types-windowmanager-addon"),
	("bpy.ops.anim.keyframe_delete*", "animation/keyframes/editing.html#bpy-ops-anim-keyframe-delete"),
	("bpy.ops.anim.keyframe_insert*", "animation/keyframes/editing.html#bpy-ops-anim-keyframe-insert"),
	("bpy.ops.mesh.average_normals*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-average-normals"),
	("bpy.ops.mesh.vertices_smooth*", "modeling/meshes/editing/transform/smooth.html#bpy-ops-mesh-vertices-smooth"),
	("bpy.ops.node.read_viewlayers*", "interface/controls/nodes/editing.html#bpy-ops-node-read-viewlayers"),
	("bpy.ops.object.data_transfer*", "modeling/meshes/editing/data_transfer.html#bpy-ops-object-data-transfer"),
	("bpy.ops.object.select_camera*", "scene_layout/object/selecting.html#bpy-ops-object-select-camera"),
	("bpy.ops.object.select_linked*", "scene_layout/object/selecting.html#bpy-ops-object-select-linked"),
	("bpy.ops.object.select_mirror*", "scene_layout/object/selecting.html#bpy-ops-object-select-mirror"),
	("bpy.ops.object.select_random*", "scene_layout/object/selecting.html#bpy-ops-object-select-random"),
	("bpy.ops.sound.bake_animation*", "scene_layout/scene/properties.html#bpy-ops-sound-bake-animation"),
	("bpy.ops.transform.edge_slide*", "modeling/meshes/editing/edges.html#bpy-ops-transform-edge-slide"),
	("bpy.ops.transform.vert_slide*", "modeling/meshes/editing/vertices.html#bpy-ops-transform-vert-slide"),
	("bpy.ops.uv.project_from_view*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-project-from-view"),
	("bpy.ops.view3d.select_border*", "editors/3dview/toolbar/select_box.html#bpy-ops-view3d-select-border"),
	("bpy.ops.view3d.select_circle*", "editors/3dview/toolbar/select_circle.html#bpy-ops-view3d-select-circle"),
	("bpy.ops.wm.memory_statistics*", "advanced/operators.html#bpy-ops-wm-memory-statistics"),
	("bpy.types.adjustmentsequence*", "sequencer/sequencer/strips/effects/adjustment.html#bpy-types-adjustmentsequence"),
	("bpy.types.alphaundersequence*", "sequencer/sequencer/strips/effects/alpha_over_under_overdrop.html#bpy-types-alphaundersequence"),
	("bpy.types.armatureconstraint*", "animation/constraints/relationship/armature.html#bpy-types-armatureconstraint"),
	("bpy.types.compositornodeblur*", "compositing/types/filter/blur_node.html#bpy-types-compositornodeblur"),
	("bpy.types.compositornodecomb*", "editors/texture_node/types/color/combine_separate.html#bpy-types-compositornodecomb"),
	("bpy.types.compositornodecrop*", "compositing/types/distort/crop.html#bpy-types-compositornodecrop"),
	("bpy.types.compositornodeflip*", "compositing/types/distort/flip.html#bpy-types-compositornodeflip"),
	("bpy.types.compositornodemask*", "compositing/types/input/mask.html#bpy-types-compositornodemask"),
	("bpy.types.compositornodemath*", "compositing/types/converter/math.html#bpy-types-compositornodemath"),
	("bpy.types.compositornodetime*", "compositing/types/input/time.html#bpy-types-compositornodetime"),
	("bpy.types.fluidfluidsettings*", "physics/fluid/types/fluid_object.html#bpy-types-fluidfluidsettings"),
	("bpy.types.fmodifiergenerator*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifiergenerator"),
	("bpy.types.freestylelinestyle*", "render/freestyle/parameter_editor/line_style/index.html#bpy-types-freestylelinestyle"),
	("bpy.types.gammacrosssequence*", "sequencer/sequencer/strips/effects/cross.html#bpy-types-gammacrosssequence"),
	("bpy.types.huecorrectmodifier*", "sequencer/sequencer/properties/modifiers.html#bpy-types-huecorrectmodifier"),
	("bpy.types.imagepaint.stencil*", "sculpt_paint/texture_paint/properties/mask.html#bpy-types-imagepaint-stencil"),
	("bpy.types.meshdeformmodifier*", "modeling/modifiers/deform/mesh_deform.html#bpy-types-meshdeformmodifier"),
	("bpy.types.movietrackingtrack*", "movie_clip/tracking/clip/properties/introduction.html#bpy-types-movietrackingtrack"),
	("bpy.types.nodeoutputfileslot*", "compositing/types/output/file.html#bpy-types-nodeoutputfileslot"),
	("bpy.types.normaleditmodifier*", "modeling/modifiers/modify/normal_edit.html#bpy-types-normaleditmodifier"),
	("bpy.types.object.show_bounds*", "scene_layout/object/properties/display.html#bpy-types-object-show-bounds"),
	("bpy.types.scene.audio_volume*", "scene_layout/scene/properties.html#bpy-types-scene-audio-volume"),
	("bpy.types.shadernodebsdfhair*", "render/shader_nodes/shader/hair.html#bpy-types-shadernodebsdfhair"),
	("bpy.types.shadernodebsdftoon*", "render/shader_nodes/shader/toon.html#bpy-types-shadernodebsdftoon"),
	("bpy.types.shadernodeemission*", "render/shader_nodes/shader/emission.html#bpy-types-shadernodeemission"),
	("bpy.types.shadernodegeometry*", "render/shader_nodes/input/geometry.html#bpy-types-shadernodegeometry"),
	("bpy.types.shadernodehairinfo*", "render/shader_nodes/input/hair_info.html#bpy-types-shadernodehairinfo"),
	("bpy.types.shadernodergbcurve*", "render/shader_nodes/color/rgb_curves.html#bpy-types-shadernodergbcurve"),
	("bpy.types.shadernodeseparate*", "render/shader_nodes/converter/combine_separate.html#bpy-types-shadernodeseparate"),
	("bpy.types.shadernodetexbrick*", "render/shader_nodes/textures/brick.html#bpy-types-shadernodetexbrick"),
	("bpy.types.shadernodetexcoord*", "render/shader_nodes/input/texture_coordinate.html#bpy-types-shadernodetexcoord"),
	("bpy.types.shadernodeteximage*", "render/shader_nodes/textures/image.html#bpy-types-shadernodeteximage"),
	("bpy.types.shadernodetexmagic*", "render/shader_nodes/textures/magic.html#bpy-types-shadernodetexmagic"),
	("bpy.types.shadernodetexnoise*", "render/shader_nodes/textures/noise.html#bpy-types-shadernodetexnoise"),
	("bpy.types.shrinkwrapmodifier*", "modeling/modifiers/deform/shrinkwrap.html#bpy-types-shrinkwrapmodifier"),
	("bpy.types.splineikconstraint*", "animation/constraints/tracking/spline_ik.html#bpy-types-splineikconstraint"),
	("bpy.types.texturenodetexture*", "editors/texture_node/types/input/texture.html#bpy-types-texturenodetexture"),
	("bpy.ops.anim.keyframe_clear*", "animation/keyframes/editing.html#bpy-ops-anim-keyframe-clear"),
	("bpy.ops.curve.primitive*add*", "modeling/curves/primitives.html#bpy-ops-curve-primitive-add"),
	("bpy.ops.mesh.duplicate_move*", "modeling/meshes/editing/duplicating/duplicate.html#bpy-ops-mesh-duplicate-move"),
	("bpy.ops.object.parent_clear*", "scene_layout/object/properties/relations/parents.html#bpy-ops-object-parent-clear"),
	("bpy.ops.object.shade_smooth*", "modeling/meshes/editing/normals.html#bpy-ops-object-shade-smooth"),
	("bpy.ops.transform.push_pull*", "modeling/meshes/editing/transform/push_pull.html#bpy-ops-transform-push-pull"),
	("bpy.ops.transform.trackball*", "scene_layout/object/editing/transform/basics.html#bpy-ops-transform-trackball"),
	("bpy.ops.transform.transform*", "scene_layout/object/editing/transform/control/orientations.html#bpy-ops-transform-transform"),
	("bpy.ops.transform.translate*", "scene_layout/object/editing/transform/basics.html#bpy-ops-transform-translate"),
	("bpy.ops.uv.cylinder_project*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-cylinder-project"),
	("bpy.ops.uv.minimize_stretch*", "modeling/meshes/editing/uv/layout.html#bpy-ops-uv-minimize-stretch"),
	("bpy.ops.view3d.select_lasso*", "editors/3dview/toolbar/select_lasso.html#bpy-ops-view3d-select-lasso"),
	("bpy.types.alphaoversequence*", "sequencer/sequencer/strips/effects/alpha_over_under_overdrop.html#bpy-types-alphaoversequence"),
	("bpy.types.armatureeditbones*", "animation/armatures/bones/editing/index.html#bpy-types-armatureeditbones"),
	("bpy.types.cameradofsettings*", "render/cameras.html#bpy-types-cameradofsettings"),
	("bpy.types.childofconstraint*", "animation/constraints/relationship/child_of.html#bpy-types-childofconstraint"),
	("bpy.types.clamptoconstraint*", "animation/constraints/tracking/clamp_to.html#bpy-types-clamptoconstraint"),
	("bpy.types.collisionmodifier*", "physics/collision.html#bpy-types-collisionmodifier"),
	("bpy.types.collisionsettings*", "physics/collision.html#bpy-types-collisionsettings"),
	("bpy.types.compositornodergb*", "compositing/types/input/rgb.html#bpy-types-compositornodergb"),
	("bpy.types.compositornodesep*", "editors/texture_node/types/color/combine_separate.html#bpy-types-compositornodesep"),
	("bpy.types.edgesplitmodifier*", "modeling/modifiers/generate/edge_split.html#bpy-types-edgesplitmodifier"),
	("bpy.types.fmodifierenvelope*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierenvelope"),
	("bpy.types.freestylesettings*", "render/freestyle/view_map.html#bpy-types-freestylesettings"),
	("bpy.types.imagepaint.dither*", "sculpt_paint/texture_paint/properties/options.html#bpy-types-imagepaint-dither"),
	("bpy.types.mesh.texture_mesh*", "editors/uv/generated_uvs.html#bpy-types-mesh-texture-mesh"),
	("bpy.types.mesh.use_mirror_x*", "modeling/meshes/editing/mesh_options.html#bpy-types-mesh-use-mirror-x"),
	("bpy.types.meshcachemodifier*", "modeling/modifiers/modify/mesh_cache.html#bpy-types-meshcachemodifier"),
	("bpy.types.movieclipsequence*", "sequencer/sequencer/strips/clip_mask.html#bpy-types-movieclipsequence"),
	("bpy.types.object.dimensions*", "scene_layout/object/properties/transforms.html#bpy-types-object-dimensions"),
	("bpy.types.object.track_axis*", "scene_layout/object/properties/relations/extras.html#bpy-types-object-track-axis"),
	("bpy.types.scene.active_clip*", "scene_layout/scene/properties.html#bpy-types-scene-active-clip"),
	("bpy.types.sceneeevee.shadow*", "render/eevee/render_settings/shadows.html#bpy-types-sceneeevee-shadow"),
	("bpy.types.shadernodecombine*", "render/shader_nodes/converter/combine_separate.html#bpy-types-shadernodecombine"),
	("bpy.types.shadernodefresnel*", "render/shader_nodes/input/fresnel.html#bpy-types-shadernodefresnel"),
	("bpy.types.shadernodeholdout*", "render/shader_nodes/shader/holdout.html#bpy-types-shadernodeholdout"),
	("bpy.types.shadernodemapping*", "render/shader_nodes/vector/mapping.html#bpy-types-shadernodemapping"),
	("bpy.types.shadernodergbtobw*", "render/shader_nodes/converter/rgb_to_bw.html#bpy-types-shadernodergbtobw"),
	("bpy.types.shadernodetangent*", "render/shader_nodes/input/tangent.html#bpy-types-shadernodetangent"),
	("bpy.types.shadernodetexwave*", "render/shader_nodes/textures/wave.html#bpy-types-shadernodetexwave"),
	("bpy.types.smokecollsettings*", "physics/smoke/types/collision.html#bpy-types-smokecollsettings"),
	("bpy.types.smokeflowsettings*", "physics/smoke/types/flow_object.html#bpy-types-smokeflowsettings"),
	("bpy.types.texturenodebricks*", "editors/texture_node/types/patterns/bricks.html#bpy-types-texturenodebricks"),
	("bpy.types.texturenodemixrgb*", "editors/texture_node/types/color/mix_rgb.html#bpy-types-texturenodemixrgb"),
	("bpy.types.texturenodeoutput*", "editors/texture_node/types/output/output.html#bpy-types-texturenodeoutput"),
	("bpy.types.tracktoconstraint*", "animation/constraints/tracking/track_to.html#bpy-types-tracktoconstraint"),
	("bpy.types.transformsequence*", "sequencer/sequencer/strips/effects/transform.html#bpy-types-transformsequence"),
	("bpy.types.uvprojectmodifier*", "modeling/modifiers/modify/uv_project.html#bpy-types-uvprojectmodifier"),
	("bpy.types.wireframemodifier*", "modeling/modifiers/generate/wireframe.html#bpy-types-wireframemodifier"),
	("bpy.types.worldmistsettings*", "render/cycles/world_settings.html#bpy-types-worldmistsettings"),
	("bpy.ops.mesh.loopcut_slide*", "modeling/meshes/editing/subdividing/loop.html#bpy-ops-mesh-loopcut-slide"),
	("bpy.ops.mesh.merge_normals*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-merge-normals"),
	("bpy.ops.mesh.normals_tools*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-normals-tools"),
	("bpy.ops.mesh.point_normals*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-point-normals"),
	("bpy.ops.mesh.primitive*add*", "modeling/meshes/primitives.html#bpy-ops-mesh-primitive-add"),
	("bpy.ops.mesh.split_normals*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-split-normals"),
	("bpy.ops.object.gpencil_add*", "grease_pencil/primitives.html#bpy-ops-object-gpencil-add"),
	("bpy.ops.object.select_less*", "scene_layout/object/selecting.html#bpy-ops-object-select-less"),
	("bpy.ops.object.select_more*", "scene_layout/object/selecting.html#bpy-ops-object-select-more"),
	("bpy.ops.object.track_clear*", "animation/constraints/interface/adding_removing.html#bpy-ops-object-track-clear"),
	("bpy.ops.screen.repeat_last*", "interface/undo_redo.html#bpy-ops-screen-repeat-last"),
	("bpy.ops.transform.tosphere*", "modeling/meshes/editing/transform/to_sphere.html#bpy-ops-transform-tosphere"),
	("bpy.ops.wm.previews_ensure*", "files/blend/previews.html#bpy-ops-wm-previews-ensure"),
	("bpy.types.actionconstraint*", "animation/constraints/relationship/action.html#bpy-types-actionconstraint"),
	("bpy.types.addonpreferences*", "editors/preferences/addons.html#bpy-types-addonpreferences"),
	("bpy.types.armaturemodifier*", "modeling/modifiers/deform/armature.html#bpy-types-armaturemodifier"),
	("bpy.types.decimatemodifier*", "modeling/modifiers/generate/decimate.html#bpy-types-decimatemodifier"),
	("bpy.types.displacemodifier*", "modeling/modifiers/deform/displace.html#bpy-types-displacemodifier"),
	("bpy.types.displaysafeareas*", "render/cameras.html#bpy-types-displaysafeareas"),
	("bpy.types.fmodifierstepped*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierstepped"),
	("bpy.types.freestylelineset*", "render/freestyle/parameter_editor/line_set.html#bpy-types-freestylelineset"),
	("bpy.types.mesh.*customdata*", "modeling/meshes/properties/custom_data.html#bpy-types-mesh-customdata"),
	("bpy.types.multicamsequence*", "sequencer/sequencer/strips/effects/multicam.html#bpy-types-multicamsequence"),
	("bpy.types.multiplysequence*", "sequencer/sequencer/strips/effects/multiply.html#bpy-types-multiplysequence"),
	("bpy.types.multiresmodifier*", "modeling/modifiers/generate/multiresolution.html#bpy-types-multiresmodifier"),
	("bpy.types.object.use_extra*", "scene_layout/object/properties/relations/extras.html#bpy-types-object-use-extra"),
	("bpy.types.overdropsequence*", "sequencer/sequencer/strips/effects/alpha_over_under_overdrop.html#bpy-types-overdropsequence"),
	("bpy.types.paint.use_cavity*", "sculpt_paint/texture_paint/properties/options.html#bpy-types-paint-use-cavity"),
	("bpy.types.particlesettings*", "physics/particles/index.html#bpy-types-particlesettings"),
	("bpy.types.sceneeevee.bloom*", "render/eevee/render_settings/bloom.html#bpy-types-sceneeevee-bloom"),
	("bpy.types.scenerenderlayer*", "render/layers/layers.html#bpy-types-scenerenderlayer"),
	("bpy.types.sequencemodifier*", "sequencer/sequencer/properties/modifiers.html#bpy-types-sequencemodifier"),
	("bpy.types.shadernodeinvert*", "render/shader_nodes/color/invert.html#bpy-types-shadernodeinvert"),
	("bpy.types.shadernodemixrgb*", "render/shader_nodes/color/mix.html#bpy-types-shadernodemixrgb"),
	("bpy.types.shadernodenormal*", "render/shader_nodes/vector/normal.html#bpy-types-shadernodenormal"),
	("bpy.types.shadernodescript*", "render/shader_nodes/osl.html#bpy-types-shadernodescript"),
	("bpy.types.shadernodetexies*", "render/shader_nodes/textures/ies.html#bpy-types-shadernodetexies"),
	("bpy.types.shadernodetexsky*", "render/shader_nodes/textures/sky.html#bpy-types-shadernodetexsky"),
	("bpy.types.softbodymodifier*", "physics/soft_body/index.html#bpy-types-softbodymodifier"),
	("bpy.types.softbodysettings*", "physics/soft_body/settings.html#bpy-types-softbodysettings"),
	("bpy.types.solidifymodifier*", "modeling/modifiers/generate/solidify.html#bpy-types-solidifymodifier"),
	("bpy.types.spacegrapheditor*", "editors/graph_editor/index.html#bpy-types-spacegrapheditor"),
	("bpy.types.sphfluidsettings*", "physics/fluid/index.html#bpy-types-sphfluidsettings"),
	("bpy.types.subtractsequence*", "sequencer/sequencer/strips/effects/subtract.html#bpy-types-subtractsequence"),
	("bpy.types.texturenodegroup*", "editors/texture_node/types/groups.html#bpy-types-texturenodegroup"),
	("bpy.types.texturenodeimage*", "editors/texture_node/types/input/image.html#bpy-types-texturenodeimage"),
	("bpy.ops.mesh.flip_normals*", "modeling/meshes/editing/normals.html#bpy-ops-mesh-flip-normals"),
	("bpy.ops.object.*shape_key*", "animation/shape_keys/index.html#bpy-ops-object-shape-key"),
	("bpy.ops.object.lightprobe*", "render/eevee/lightprobes/index.html#bpy-ops-object-lightprobe"),
	("bpy.ops.object.make_links*", "scene_layout/object/editing/duplication.html#bpy-ops-object-make-links"),
	("bpy.ops.object.make_local*", "files/linked_libraries.html#bpy-ops-object-make-local"),
	("bpy.ops.object.origin_set*", "scene_layout/object/origin.html#bpy-ops-object-origin-set"),
	("bpy.ops.object.parent_set*", "scene_layout/object/properties/relations/parents.html#bpy-ops-object-parent-set"),
	("bpy.ops.object.proxy_make*", "files/linked_libraries.html#bpy-ops-object-proxy-make"),
	("bpy.ops.object.select_all*", "scene_layout/object/selecting.html#bpy-ops-object-select-all"),
	("bpy.ops.object.shade_flat*", "modeling/meshes/editing/normals.html#bpy-ops-object-shade-flat"),
	("bpy.ops.preferences.addon*", "editors/preferences/addons.html#bpy-ops-preferences-addon"),
	("bpy.ops.scene.light_cache*", "render/eevee/render_settings/indirect_lighting.html#bpy-ops-scene-light-cache"),
	("bpy.ops.screen.area_dupli*", "interface/window_system/areas.html#bpy-ops-screen-area-dupli"),
	("bpy.ops.uv.remove_doubles*", "modeling/meshes/editing/uv/layout.html#bpy-ops-uv-remove-doubles"),
	("bpy.ops.uv.sphere_project*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-sphere-project"),
	("bpy.ops.wm.previews_clear*", "files/blend/previews.html#bpy-ops-wm-previews-clear"),
	("bpy.types.booleanmodifier*", "modeling/modifiers/generate/booleans.html#bpy-types-booleanmodifier"),
	("bpy.types.constraint.mute*", "animation/constraints/interface/header.html#bpy-types-constraint-mute"),
	("bpy.types.explodemodifier*", "modeling/modifiers/simulate/explode.html#bpy-types-explodemodifier"),
	("bpy.types.fcurvemodifiers*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fcurvemodifiers"),
	("bpy.types.floorconstraint*", "animation/constraints/relationship/floor.html#bpy-types-floorconstraint"),
	("bpy.types.fluidmeshvertex*", "physics/fluid/index.html#bpy-types-fluidmeshvertex"),
	("bpy.types.fmodifiercycles*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifiercycles"),
	("bpy.types.fmodifierlimits*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifierlimits"),
	("bpy.types.imagepaint.mode*", "sculpt_paint/texture_paint/properties/texture_slots.html#bpy-types-imagepaint-mode"),
	("bpy.types.latticemodifier*", "modeling/modifiers/deform/lattice.html#bpy-types-latticemodifier"),
	("bpy.types.musgravetexture*", "render/materials/legacy_textures/types/musgrave.html#bpy-types-musgravetexture"),
	("bpy.types.object.location*", "scene_layout/object/properties/transforms.html#bpy-types-object-location"),
	("bpy.types.object.rotation*", "scene_layout/object/properties/transforms.html#bpy-types-object-rotation"),
	("bpy.types.particlehairkey*", "physics/particles/emitter/physics/keyed.html#bpy-types-particlehairkey"),
	("bpy.types.pivotconstraint*", "animation/constraints/relationship/pivot.html#bpy-types-pivotconstraint"),
	("bpy.types.rigidbodyobject*", "physics/rigid_body/index.html#bpy-types-rigidbodyobject"),
	("bpy.types.sceneeevee.gtao*", "render/eevee/render_settings/ambient_occlusion.html#bpy-types-sceneeevee-gtao"),
	("bpy.types.shadernodebevel*", "render/shader_nodes/input/bevel.html#bpy-types-shadernodebevel"),
	("bpy.types.shadernodegamma*", "render/shader_nodes/color/gamma.html#bpy-types-shadernodegamma"),
	("bpy.types.shadernodegroup*", "render/shader_nodes/groups.html#bpy-types-shadernodegroup"),
	("bpy.types.shadernodeuvmap*", "render/shader_nodes/input/uv_map.html#bpy-types-shadernodeuvmap"),
	("bpy.types.shadernodevalue*", "render/shader_nodes/input/value.html#bpy-types-shadernodevalue"),
	("bpy.types.spaceclipeditor*", "movie_clip/index.html#bpy-types-spaceclipeditor"),
	("bpy.types.spaceproperties*", "editors/properties_editor.html#bpy-types-spaceproperties"),
	("bpy.types.spacetexteditor*", "editors/text_editor.html#bpy-types-spacetexteditor"),
	("bpy.types.subsurfmodifier*", "modeling/modifiers/generate/subdivision_surface.html#bpy-types-subsurfmodifier"),
	("bpy.types.texturenodemath*", "editors/texture_node/types/converter/math.html#bpy-types-texturenodemath"),
	("bpy.types.userpreferences*", "editors/preferences/index.html#bpy-types-userpreferences"),
	("bpy.ops.graph.frame_jump*", "editors/graph_editor/fcurves/properties.html#bpy-ops-graph-frame-jump"),
	("bpy.ops.mesh.edge_rotate*", "modeling/meshes/editing/edges.html#bpy-ops-mesh-edge-rotate"),
	("bpy.ops.object.hide_view*", "scene_layout/object/editing/introduction.html#bpy-ops-object-hide-view"),
	("bpy.ops.object.track_set*", "animation/constraints/interface/adding_removing.html#bpy-ops-object-track-set"),
	("bpy.ops.transform.mirror*", "scene_layout/object/editing/transform/mirror.html#bpy-ops-transform-mirror"),
	("bpy.ops.transform.resize*", "scene_layout/object/editing/transform/basics.html#bpy-ops-transform-resize"),
	("bpy.ops.transform.rotate*", "scene_layout/object/editing/transform/basics.html#bpy-ops-transform-rotate"),
	("bpy.ops.uv.lightmap_pack*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-lightmap-pack"),
	("bpy.ops.uv.smart_project*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-smart-project"),
	("bpy.ops.view3d.localview*", "editors/3dview/navigate/views.html#bpy-ops-view3d-localview"),
	("bpy.types.curvesmodifier*", "sequencer/sequencer/properties/modifiers.html#bpy-types-curvesmodifier"),
	("bpy.types.ffmpegsettings*", "render/output/file_formats.html#bpy-types-ffmpegsettings"),
	("bpy.types.fmodifiernoise*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifiernoise"),
	("bpy.types.material.paint*", "sculpt_paint/texture_paint/index.html#bpy-types-material-paint"),
	("bpy.types.mirrormodifier*", "modeling/modifiers/generate/mirror.html#bpy-types-mirrormodifier"),
	("bpy.types.movieclipproxy*", "editors/clip/sidebar.html#bpy-types-movieclipproxy"),
	("bpy.types.object.up_axis*", "scene_layout/object/properties/relations/extras.html#bpy-types-object-up-axis"),
	("bpy.types.particlesystem*", "physics/particles/index.html#bpy-types-particlesystem"),
	("bpy.types.particletarget*", "physics/particles/emitter/physics/keyed.html#bpy-types-particletarget"),
	("bpy.types.remeshmodifier*", "modeling/modifiers/generate/remesh.html#bpy-types-remeshmodifier"),
	("bpy.types.rendersettings*", "render/index.html#bpy-types-rendersettings"),
	("bpy.types.rigidbodyworld*", "physics/rigid_body/world.html#bpy-types-rigidbodyworld"),
	("bpy.types.sceneeevee.ssr*", "render/eevee/render_settings/screen_space_reflections.html#bpy-types-sceneeevee-ssr"),
	("bpy.types.sceneeevee.sss*", "render/eevee/render_settings/subsurface_scattering.html#bpy-types-sceneeevee-sss"),
	("bpy.types.shadernodebump*", "render/shader_nodes/vector/bump.html#bpy-types-shadernodebump"),
	("bpy.types.shadernodemath*", "render/shader_nodes/converter/math.html#bpy-types-shadernodemath"),
	("bpy.types.smoothmodifier*", "modeling/modifiers/deform/smooth.html#bpy-types-smoothmodifier"),
	("bpy.types.timelinemarker*", "animation/markers.html#bpy-types-timelinemarker"),
	("bpy.types.usersolidlight*", "editors/preferences/lights.html#bpy-types-usersolidlight"),
	("bpy.types.uvwarpmodifier*", "modeling/modifiers/modify/uv_warp.html#bpy-types-uvwarpmodifier"),
	("bpy.types.voronoitexture*", "render/materials/legacy_textures/types/voronoi.html#bpy-types-voronoitexture"),
	("bpy.types.walknavigation*", "editors/3dview/navigate/walk_fly.html#bpy-types-walknavigation"),
	("bpy.ops.anim.keying_set*", "animation/keyframes/keying_sets.html#bpy-ops-anim-keying-set"),
	("bpy.ops.ed.undo_history*", "interface/undo_redo.html#bpy-ops-ed-undo-history"),
	("bpy.ops.mesh.edge_split*", "modeling/meshes/editing/edges.html#bpy-ops-mesh-edge-split"),
	("bpy.ops.mesh.mark_sharp*", "modeling/meshes/editing/edges.html#bpy-ops-mesh-mark-sharp"),
	("bpy.ops.object.armature*", "animation/armatures/index.html#bpy-ops-object-armature"),
	("bpy.ops.rigidbody.world*", "physics/rigid_body/world.html#bpy-ops-rigidbody-world"),
	("bpy.ops.transform.shear*", "modeling/meshes/editing/transform/shear.html#bpy-ops-transform-shear"),
	("bpy.ops.uv.cube_project*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-cube-project"),
	("bpy.ops.uv.pack_islands*", "modeling/meshes/editing/uv/layout.html#bpy-ops-uv-pack-islands"),
	("bpy.ops.wm.app_template*", "advanced/app_templates.html#bpy-ops-wm-app-template"),
	("bpy.ops.wm.redraw_timer*", "advanced/operators.html#bpy-ops-wm-redraw-timer"),
	("bpy.types.*light.shadow*", "render/eevee/render_settings/shadows.html#bpy-types-light-shadow"),
	("bpy.types.armaturebones*", "animation/armatures/bones/index.html#bpy-types-armaturebones"),
	("bpy.types.arraymodifier*", "modeling/modifiers/generate/array.html#bpy-types-arraymodifier"),
	("bpy.types.bevelmodifier*", "modeling/modifiers/generate/bevel.html#bpy-types-bevelmodifier"),
	("bpy.types.buildmodifier*", "modeling/modifiers/generate/build.html#bpy-types-buildmodifier"),
	("bpy.types.camera.sensor*", "render/cameras.html#bpy-types-camera-sensor"),
	("bpy.types.clothmodifier*", "physics/cloth/index.html#bpy-types-clothmodifier"),
	("bpy.types.clothsettings*", "physics/cloth/settings/index.html#bpy-types-clothsettings"),
	("bpy.types.cloudstexture*", "render/materials/legacy_textures/types/clouds.html#bpy-types-cloudstexture"),
	("bpy.types.colorsequence*", "sequencer/sequencer/strips/effects/color.html#bpy-types-colorsequence"),
	("bpy.types.crosssequence*", "sequencer/sequencer/strips/effects/cross.html#bpy-types-crosssequence"),
	("bpy.types.curvemodifier*", "modeling/modifiers/deform/curve.html#bpy-types-curvemodifier"),
	("bpy.types.fieldsettings*", "physics/forces/force_fields/index.html#bpy-types-fieldsettings"),
	("bpy.types.fluidsettings*", "physics/fluid/index.html#bpy-types-fluidsettings"),
	("bpy.types.imagesequence*", "sequencer/sequencer/strips/movie_image.html#bpy-types-imagesequence"),
	("bpy.types.marbletexture*", "render/materials/legacy_textures/types/marble.html#bpy-types-marbletexture"),
	("bpy.types.modifier.show*", "modeling/modifiers/introduction.html#bpy-types-modifier-show"),
	("bpy.types.moviesequence*", "sequencer/sequencer/strips/movie_image.html#bpy-types-moviesequence"),
	("bpy.types.movietracking*", "movie_clip/tracking/index.html#bpy-types-movietracking"),
	("bpy.types.object.parent*", "scene_layout/object/properties/relations/parents.html#bpy-types-object-parent"),
	("bpy.types.oceanmodifier*", "modeling/modifiers/simulate/ocean.html#bpy-types-oceanmodifier"),
	("bpy.types.particlebrush*", "physics/particles/mode.html#bpy-types-particlebrush"),
	("bpy.types.scene.gravity*", "physics/forces/gravity.html#bpy-types-scene-gravity"),
	("bpy.types.sceneeevee.gi*", "render/eevee/render_settings/indirect_lighting.html#bpy-types-sceneeevee-gi"),
	("bpy.types.scenesequence*", "sequencer/sequencer/strips/scene.html#bpy-types-scenesequence"),
	("bpy.types.screwmodifier*", "modeling/modifiers/generate/screw.html#bpy-types-screwmodifier"),
	("bpy.types.sequenceproxy*", "sequencer/sequencer/properties/proxy_cache.html#bpy-types-sequenceproxy"),
	("bpy.types.shadernodergb*", "render/shader_nodes/input/rgb.html#bpy-types-shadernodergb"),
	("bpy.types.smokemodifier*", "physics/smoke/index.html#bpy-types-smokemodifier"),
	("bpy.types.soundsequence*", "sequencer/sequencer/strips/sound.html#bpy-types-soundsequence"),
	("bpy.types.spaceoutliner*", "editors/outliner.html#bpy-types-spaceoutliner"),
	("bpy.types.spacetimeline*", "editors/timeline.html#bpy-types-spacetimeline"),
	("bpy.types.stuccitexture*", "render/materials/legacy_textures/types/stucci.html#bpy-types-stuccitexture"),
	("bpy.types.windowmanager*", "interface/index.html#bpy-types-windowmanager"),
	("bpy.ops.mesh.mark_seam*", "modeling/meshes/editing/edges.html#bpy-ops-mesh-mark-seam"),
	("bpy.ops.mesh.subdivide*", "modeling/meshes/editing/subdividing/subdivide.html#bpy-ops-mesh-subdivide"),
	("bpy.ops.object.convert*", "scene_layout/object/editing/introduction.html#bpy-ops-object-convert"),
	("bpy.ops.object.speaker*", "render/output/audio/speaker.html#bpy-ops-object-speaker"),
	("bpy.ops.transform.bend*", "modeling/meshes/editing/transform/bend.html#bpy-ops-transform-bend"),
	("bpy.types.bakesettings*", "render/cycles/baking.html#bpy-types-bakesettings"),
	("bpy.types.blendtexture*", "render/materials/legacy_textures/types/blend.html#bpy-types-blendtexture"),
	("bpy.types.castmodifier*", "modeling/modifiers/deform/cast.html#bpy-types-castmodifier"),
	("bpy.types.colormanaged*", "render/color_management.html#bpy-types-colormanaged"),
	("bpy.types.glowsequence*", "sequencer/sequencer/strips/effects/glow.html#bpy-types-glowsequence"),
	("bpy.types.hookmodifier*", "modeling/modifiers/deform/hooks.html#bpy-types-hookmodifier"),
	("bpy.types.latticepoint*", "animation/lattice.html#bpy-types-latticepoint"),
	("bpy.types.magictexture*", "render/materials/legacy_textures/types/magic.html#bpy-types-magictexture"),
	("bpy.types.maskmodifier*", "modeling/modifiers/generate/mask.html#bpy-types-maskmodifier"),
	("bpy.types.masksequence*", "sequencer/sequencer/strips/clip_mask.html#bpy-types-masksequence"),
	("bpy.types.metasequence*", "sequencer/sequencer/meta.html#bpy-types-metasequence"),
	("bpy.types.object.color*", "scene_layout/object/properties/display.html#bpy-types-object-color"),
	("bpy.types.object.delta*", "scene_layout/object/properties/transforms.html#bpy-types-object-delta"),
	("bpy.types.object.empty*", "modeling/empties.html#bpy-types-object-empty"),
	("bpy.types.object.scale*", "scene_layout/object/properties/transforms.html#bpy-types-object-scale"),
	("bpy.types.particleedit*", "physics/particles/mode.html#bpy-types-particleedit"),
	("bpy.types.scene.camera*", "scene_layout/scene/properties.html#bpy-types-scene-camera"),
	("bpy.types.skinmodifier*", "modeling/modifiers/generate/skin.html#bpy-types-skinmodifier"),
	("bpy.types.spaceconsole*", "editors/python_console.html#bpy-types-spaceconsole"),
	("bpy.types.textsequence*", "sequencer/sequencer/strips/effects/text.html#bpy-types-textsequence"),
	("bpy.types.unitsettings*", "scene_layout/scene/properties.html#bpy-types-unitsettings"),
	("bpy.types.vertexcolors*", "sculpt_paint/vertex_paint/index.html#bpy-types-vertexcolors"),
	("bpy.types.warpmodifier*", "modeling/modifiers/deform/warp.html#bpy-types-warpmodifier"),
	("bpy.types.wavemodifier*", "modeling/modifiers/deform/wave.html#bpy-types-wavemodifier"),
	("bpy.types.wipesequence*", "sequencer/sequencer/strips/effects/wipe.html#bpy-types-wipesequence"),
	("bpy.ops.image.project*", "sculpt_paint/texture_paint/properties/options.html#bpy-ops-image-project"),
	("bpy.ops.object.*clear*", "scene_layout/object/editing/transform/clear_apply.html#bpy-ops-object-clear"),
	("bpy.ops.object.delete*", "scene_layout/object/editing/introduction.html#bpy-ops-object-delete"),
	("bpy.ops.screen.header*", "interface/window_system/regions.html#bpy-ops-screen-header"),
	("bpy.ops.wm.debug_menu*", "advanced/operators.html#bpy-ops-wm-debug-menu"),
	("bpy.ops.wm.properties*", "files/data_blocks.html#bpy-ops-wm-properties"),
	("bpy.types.addsequence*", "sequencer/sequencer/strips/effects/add.html#bpy-types-addsequence"),
	("bpy.types.camera.show*", "render/cameras.html#bpy-types-camera-show"),
	("bpy.types.consoleline*", "editors/python_console.html#bpy-types-consoleline"),
	("bpy.types.meshstatvis*", "modeling/meshes/mesh_analysis.html#bpy-types-meshstatvis"),
	("bpy.types.nodesetting*", "interface/controls/nodes/parts.html#bpy-types-nodesetting"),
	("bpy.types.object.lock*", "scene_layout/object/properties/transforms.html#bpy-types-object-lock"),
	("bpy.types.object.show*", "scene_layout/object/properties/display.html#bpy-types-object-show"),
	("bpy.types.particlekey*", "physics/particles/emitter/physics/keyed.html#bpy-types-particlekey"),
	("bpy.types.posebone.ik*", "animation/armatures/posing/bone_constraints/inverse_kinematics/introduction.html#bpy-types-posebone-ik"),
	("bpy.types.renderlayer*", "render/layers/layers.html#bpy-types-renderlayer"),
	("bpy.types.spaceview3d*", "editors/3dview/index.html#bpy-types-spaceview3d"),
	("bpy.types.uipopupmenu*", "interface/controls/buttons/menus.html#bpy-types-uipopupmenu"),
	("bpy.types.vertexpaint*", "sculpt_paint/vertex_paint/index.html#bpy-types-vertexpaint"),
	("bpy.types.woodtexture*", "render/materials/legacy_textures/types/wood.html#bpy-types-woodtexture"),
	("bpy.ops.object.align*", "scene_layout/object/editing/transform/tools.html#bpy-ops-object-align"),
	("bpy.ops.object.empty*", "modeling/empties.html#bpy-ops-object-empty"),
	("bpy.ops.object.quick*", "physics/introduction.html#bpy-ops-object-quick"),
	("bpy.ops.uv.mark_seam*", "modeling/meshes/editing/uv/unwrapping/seams.html#bpy-ops-uv-mark-seam"),
	("bpy.ops.view3d.ruler*", "editors/3dview/toolbar/measure.html#bpy-ops-view3d-ruler"),
	("bpy.types.areaspaces*", "interface/window_system/areas.html#bpy-types-areaspaces"),
	("bpy.types.bpy_struct*", "files/data_blocks.html#bpy-types-bpy-struct"),
	("bpy.types.collection*", "scene_layout/collections/collections.html#bpy-types-collection"),
	("bpy.types.compositor*", "compositing/index.html#bpy-types-compositor"),
	("bpy.types.constraint*", "animation/constraints/index.html#bpy-types-constraint"),
	("bpy.types.imagepaint*", "sculpt_paint/texture_paint/index.html#bpy-types-imagepaint"),
	("bpy.types.lightprobe*", "render/eevee/lightprobes/index.html#bpy-types-lightprobe"),
	("bpy.types.nodesocket*", "interface/controls/nodes/parts.html#bpy-types-nodesocket"),
	("bpy.types.pointcache*", "physics/baking.html#bpy-types-pointcache"),
	("bpy.types.pointlight*", "render/lights/light_object.html#bpy-types-pointlight"),
	("bpy.types.renderview*", "render/output/multiview/index.html#bpy-types-renderview"),
	("bpy.types.sceneeevee*", "render/eevee/index.html#bpy-types-sceneeevee"),
	("bpy.types.vectorfont*", "modeling/texts/index.html#bpy-types-vectorfont"),
	("bpy.ops.mesh.bisect*", "modeling/meshes/editing/subdividing/bisect.html#bpy-ops-mesh-bisect"),
	("bpy.ops.object.join*", "scene_layout/object/editing/introduction.html#bpy-ops-object-join"),
	("bpy.ops.object.text*", "modeling/texts/index.html#bpy-ops-object-text"),
	("bpy.ops.view3d.snap*", "scene_layout/object/editing/transform/control/snap.html#bpy-ops-view3d-snap"),
	("bpy.types.*texspace*", "editors/uv/generated_uvs.html#bpy-types-texspace"),
	("bpy.types.arealight*", "render/lights/light_object.html#bpy-types-arealight"),
	("bpy.types.blenddata*", "files/data_blocks.html#bpy-types-blenddata"),
	("bpy.types.colorramp*", "interface/controls/templates/color_ramp.html#bpy-types-colorramp"),
	("bpy.types.dopesheet*", "editors/dope_sheet/index.html#bpy-types-dopesheet"),
	("bpy.types.fmodifier*", "editors/graph_editor/fcurves/modifiers.html#bpy-types-fmodifier"),
	("bpy.types.freestyle*", "render/freestyle/index.html#bpy-types-freestyle"),
	("bpy.types.movieclip*", "movie_clip/index.html#bpy-types-movieclip"),
	("bpy.types.nodeframe*", "interface/controls/nodes/frame.html#bpy-types-nodeframe"),
	("bpy.types.nodegroup*", "interface/controls/nodes/groups.html#bpy-types-nodegroup"),
	("bpy.types.spotlight*", "render/lights/light_object.html#bpy-types-spotlight"),
	("bpy.types.textcurve*", "modeling/texts/index.html#bpy-types-textcurve"),
	("bpy.types.uipiemenu*", "interface/controls/buttons/menus.html#bpy-types-uipiemenu"),
	("bpy.ops.collection*", "scene_layout/collections/collections.html#bpy-ops-collection"),
	("bpy.ops.constraint*", "animation/constraints/index.html#bpy-ops-constraint"),
	("bpy.ops.curve.draw*", "modeling/curves/editing/draw.html#bpy-ops-curve-draw"),
	("bpy.ops.mesh.knife*", "modeling/meshes/editing/subdividing/knife.html#bpy-ops-mesh-knife"),
	("bpy.ops.mesh.noise*", "modeling/meshes/editing/transform/noise.html#bpy-ops-mesh-noise"),
	("bpy.ops.mesh.screw*", "modeling/meshes/editing/duplicating/screw.html#bpy-ops-mesh-screw"),
	("bpy.ops.safe_areas*", "render/cameras.html#bpy-ops-safe-areas"),
	("bpy.types.armature*", "animation/armatures/index.html#bpy-types-armature"),
	("bpy.types.editbone*", "animation/armatures/bones/editing/index.html#bpy-types-editbone"),
	("bpy.types.keyframe*", "animation/keyframes/index.html#bpy-types-keyframe"),
	("bpy.types.linesets*", "render/freestyle/parameter_editor/line_set.html#bpy-types-linesets"),
	("bpy.types.metaball*", "modeling/metas/index.html#bpy-types-metaball"),
	("bpy.types.modifier*", "modeling/modifiers/index.html#bpy-types-modifier"),
	("bpy.types.nlastrip*", "editors/nla/strips.html#bpy-types-nlastrip"),
	("bpy.types.nlatrack*", "editors/nla/tracks.html#bpy-types-nlatrack"),
	("bpy.types.nodelink*", "interface/controls/nodes/parts.html#bpy-types-nodelink"),
	("bpy.types.nodetree*", "interface/controls/nodes/parts.html#bpy-types-nodetree"),
	("bpy.types.particle*", "physics/particles/index.html#bpy-types-particle"),
	("bpy.types.sequence*", "sequencer/index.html#bpy-types-sequence"),
	("bpy.types.shapekey*", "animation/shape_keys/index.html#bpy-types-shapekey"),
	("bpy.types.spacenla*", "editors/nla/index.html#bpy-types-spacenla"),
	("bpy.types.sunlight*", "render/lights/light_object.html#bpy-types-sunlight"),
	("bpy.ops.mesh.spin*", "modeling/meshes/editing/duplicating/spin.html#bpy-ops-mesh-spin"),
	("bpy.ops.rigidbody*", "physics/rigid_body/index.html#bpy-ops-rigidbody"),
	("bpy.ops.sequencer*", "sequencer/index.html#bpy-ops-sequencer"),
	("bpy.ops.transform*", "scene_layout/object/editing/transform/index.html#bpy-ops-transform"),
	("bpy.ops.uv.stitch*", "modeling/meshes/editing/uv/layout.html#bpy-ops-uv-stitch"),
	("bpy.ops.uv.unwrap*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-unwrap"),
	("bpy.types.animviz*", "animation/motion_paths.html#bpy-types-animviz"),
	("bpy.types.lattice*", "animation/lattice.html#bpy-types-lattice"),
	("bpy.types.library*", "files/linked_libraries.html#bpy-types-library"),
	("bpy.types.speaker*", "render/output/audio/speaker.html#bpy-types-speaker"),
	("bpy.types.textbox*", "modeling/texts/properties.html#bpy-types-textbox"),
	("bpy.types.texture*", "render/materials/legacy_textures/index.html#bpy-types-texture"),
	("bpy.ops.armature*", "animation/armatures/index.html#bpy-ops-armature"),
	("bpy.ops.nla.bake*", "animation/actions.html#bpy-ops-nla-bake"),
	("bpy.ops.outliner*", "editors/outliner.html#bpy-ops-outliner"),
	("bpy.ops.particle*", "physics/particles/index.html#bpy-ops-particle"),
	("bpy.ops.uv.align*", "modeling/meshes/editing/uv/layout.html#bpy-ops-uv-align"),
	("bpy.ops.uv.reset*", "modeling/meshes/editing/uv/unwrapping/mapping_types.html#bpy-ops-uv-reset"),
	("bpy.ops.wm.addon*", "editors/preferences/addons.html#bpy-ops-wm-addon"),
	("bpy.types.action*", "animation/actions.html#bpy-types-action"),
	("bpy.types.cycles*", "render/cycles/index.html#bpy-types-cycles"),
	("bpy.types.driver*", "animation/drivers/index.html#bpy-types-driver"),
	("bpy.types.fcurve*", "editors/graph_editor/fcurves/index.html#bpy-types-fcurve"),
	("bpy.types.header*", "interface/window_system/regions.html#bpy-types-header"),
	("bpy.types.object*", "scene_layout/object/index.html#bpy-types-object"),
	("bpy.types.region*", "interface/window_system/regions.html#bpy-types-region"),
	("bpy.types.render*", "render/index.html#bpy-types-render"),
	("bpy.types.sculpt*", "sculpt_paint/sculpting/index.html#bpy-types-sculpt"),
	("bpy.types.shader*", "render/shader_nodes/shader/index.html#bpy-types-shader"),
	("bpy.types.window*", "interface/index.html#bpy-types-window"),
	("bpy.ops.buttons*", "interface/index.html#bpy-ops-buttons"),
	("bpy.ops.console*", "editors/python_console.html#bpy-ops-console"),
	("bpy.ops.ed.redo*", "interface/undo_redo.html#bpy-ops-ed-redo"),
	("bpy.ops.ed.undo*", "interface/undo_redo.html#bpy-ops-ed-undo"),
	("bpy.ops.gpencil*", "grease_pencil/index.html#bpy-ops-gpencil"),
	("bpy.ops.lattice*", "animation/lattice.html#bpy-ops-lattice"),
	("bpy.ops.poselib*", "animation/armatures/properties/pose_library.html#bpy-ops-poselib"),
	("bpy.ops.ptcache*", "physics/baking.html#bpy-ops-ptcache"),
	("bpy.ops.surface*", "modeling/surfaces/index.html#bpy-ops-surface"),
	("bpy.ops.texture*", "render/materials/legacy_textures/index.html#bpy-ops-texture"),
	("bpy.ops.uv.weld*", "modeling/meshes/editing/uv/layout.html#bpy-ops-uv-weld"),
	("bpy.types.addon*", "editors/preferences/addons.html#bpy-types-addon"),
	("bpy.types.brush*", "sculpt_paint/brush/brush.html#bpy-types-brush"),
	("bpy.types.curve*", "modeling/curves/index.html#bpy-types-curve"),
	("bpy.types.image*", "files/media/image_formats.html#bpy-types-image"),
	("bpy.types.itasc*", "animation/armatures/posing/bone_constraints/inverse_kinematics/introduction.html#bpy-types-itasc"),
	("bpy.types.nodes*", "interface/controls/nodes/index.html#bpy-types-nodes"),
	("bpy.types.panel*", "interface/window_system/tabs_panels.html#bpy-types-panel"),
	("bpy.types.scene*", "scene_layout/scene/index.html#bpy-types-scene"),
	("bpy.types.sound*", "render/output/audio/index.html#bpy-types-sound"),
	("bpy.types.space*", "editors/index.html#bpy-types-space"),
	("bpy.types.theme*", "editors/preferences/themes.html#bpy-types-theme"),
	("bpy.ops.action*", "animation/actions.html#bpy-ops-action"),
	("bpy.ops.cycles*", "render/cycles/index.html#bpy-ops-cycles"),
	("bpy.ops.dpaint*", "physics/dynamic_paint/index.html#bpy-ops-dpaint"),
	("bpy.ops.export*", "files/import_export.html#bpy-ops-export"),
	("bpy.ops.import*", "files/import_export.html#bpy-ops-import"),
	("bpy.ops.marker*", "animation/markers.html#bpy-ops-marker"),
	("bpy.ops.object*", "scene_layout/object/index.html#bpy-ops-object"),
	("bpy.ops.render*", "render/index.html#bpy-ops-render"),
	("bpy.ops.script*", "advanced/scripting/index.html#bpy-ops-script"),
	("bpy.ops.sculpt*", "sculpt_paint/sculpting/index.html#bpy-ops-sculpt"),
	("bpy.ops.uv.pin*", "modeling/meshes/editing/uv/layout.html#bpy-ops-uv-pin"),
	("bpy.ops.view3d*", "editors/3dview/index.html#bpy-ops-view3d"),
	("bpy.types.area*", "interface/window_system/areas.html#bpy-types-area"),
	("bpy.types.boid*", "physics/particles/emitter/physics/boids.html#bpy-types-boid"),
	("bpy.types.bone*", "animation/armatures/bones/index.html#bpy-types-bone"),
	("bpy.types.mask*", "movie_clip/masking/index.html#bpy-types-mask"),
	("bpy.types.menu*", "interface/controls/buttons/menus.html#bpy-types-menu"),
	("bpy.types.mesh*", "modeling/meshes/index.html#bpy-types-mesh"),
	("bpy.types.pose*", "animation/armatures/posing/index.html#bpy-types-pose"),
	("bpy.types.text*", "modeling/texts/index.html#bpy-types-text"),
	("bpy.ops.brush*", "sculpt_paint/brush/brush.html#bpy-ops-brush"),
	("bpy.ops.cloth*", "physics/cloth/index.html#bpy-ops-cloth"),
	("bpy.ops.curve*", "modeling/curves/index.html#bpy-ops-curve"),
	("bpy.ops.fluid*", "physics/fluid/index.html#bpy-ops-fluid"),
	("bpy.ops.graph*", "editors/graph_editor/index.html#bpy-ops-graph"),
	("bpy.ops.image*", "files/media/image_formats.html#bpy-ops-image"),
	("bpy.ops.mball*", "modeling/metas/index.html#bpy-ops-mball"),
	("bpy.ops.paint*", "sculpt_paint/index.html#bpy-ops-paint"),
	("bpy.ops.scene*", "scene_layout/scene/index.html#bpy-ops-scene"),
	("bpy.ops.sound*", "render/output/audio/index.html#bpy-ops-sound"),
	("bpy.types.key*", "animation/shape_keys/index.html#bpy-types-key"),
	("bpy.ops.anim*", "animation/index.html#bpy-ops-anim"),
	("bpy.ops.boid*", "physics/particles/emitter/physics/boids.html#bpy-ops-boid"),
	("bpy.ops.clip*", "movie_clip/index.html#bpy-ops-clip"),
	("bpy.ops.font*", "modeling/texts/index.html#bpy-ops-font"),
	("bpy.ops.mask*", "movie_clip/masking/index.html#bpy-ops-mask"),
	("bpy.ops.mesh*", "modeling/meshes/index.html#bpy-ops-mesh"),
	("bpy.ops.node*", "interface/controls/nodes/index.html#bpy-ops-node"),
	("bpy.ops.pose*", "animation/armatures/posing/index.html#bpy-ops-pose"),
	("bpy.ops.text*", "editors/text_editor.html#bpy-ops-text"),
	("bpy.ops.time*", "editors/timeline.html#bpy-ops-time"),
	("bpy.types.id*", "files/data_blocks.html#bpy-types-id"),
	("bpy.ops.nla*", "editors/nla/index.html#bpy-ops-nla"),
	("bpy.ops.ed*", "interface/undo_redo.html#bpy-ops-ed"),
	("bpy.ops.ui*", "interface/index.html#bpy-ops-ui"),
	("bpy.ops.wm*", "interface/index.html#bpy-ops-wm"),
)
