#ifndef _GHOST_DISPLAYMANAGERZETA_H_
#define _GHOST_DISPLAYMANAGERZETA_H_

#include "GHOST_DisplayManager.h"
#include "GHOST_SystemZETA.h"

class GHOST_DisplayManagerZETA : public GHOST_DisplayManager
{
	public:
									GHOST_DisplayManagerZETA(
										GHOST_SystemZETA* system );
									
									~GHOST_DisplayManagerZETA();
		
		GHOST_TSuccess				getCurrentDisplaySetting(
										GHOST_TUns8 display,
										GHOST_DisplaySetting& setting ) const;
		
		GHOST_TSuccess				getDisplaySetting(
										GHOST_TUns8 display,
										GHOST_TInt32 index,
										GHOST_DisplaySetting& setting ) const;
								
		GHOST_TSuccess				getNumDisplays( GHOST_TUns8& numDisplays ) const;
		
		GHOST_TSuccess				getNumDisplaySettings(
										GHOST_TUns8 display,
										GHOST_TInt32& numSettings ) const;
		
		GHOST_TSuccess				setCurrentDisplaySetting(
										GHOST_TUns8 display,
										const GHOST_DisplaySetting& setting );								
		
	private:
		GHOST_SystemZETA*			fSystemZETA;
};

#endif
