#!BPY 
""" Registration info for Blender menus: <- these words are ignored 
Name: 'Bezier Curve to Svg Path' 
Blender: 248
Group: 'Export' 
Tip: 'Export Bezier Curve in svg path format' 
""" 

__author__ = "Jean-Michel Soler (jms)" 
__url__ = ("blender", "elysiun", 
"Script's homepage, http://jmsoler.free.fr/didacticiel/blender/tutor/py_bezcurve2svg.htm", 
"Communicate problems and errors, http://www.zoo-logique.org/3D.Blender/newsportal/thread.php?group=3D.Blender") 
__version__ = "0.3.1" 

__bpydoc__ = """\ 

""" 
# -------------------------------------------------------------------------- 
# ***** BEGIN GPL LICENSE BLOCK ***** 
# 
# Copyright (C) 2005: jm soler, jmsoler_at_free.fr 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, 
# -------------------------------------------------------------------------- 

#----------------- 
# Derniere mise a jour :  
# v0.3.2,  10/10/2005  
#    ajout de la fonction fileselector 
#  
# v0.3.1,  28/09/2005 
#    correction dans l'evaluation de la taille de la boundbox 
#    parenthse mal placee : 
#    ...(B[3][2]-B[0][2])**2.0)**0.5 
# 
# v0.3,    27/09/2005 
#    correction de positionnement de la courbe issue de blender  
#    dans le viewport du fichier svg 
#  
#----------------- 
import Blender 

from Blender import sys as bsys 
from Blender.Window import FileSelector 
from Blender import Object 

# config options: 
CONFIRM_OVERWRITE = True 

def SVGBzCurve_export(ob, FILE_ADDRESS): 
 #DIR_ADDRESS='F:/tmp/' 
 #FILE_ADDRESS='bezcurve2svg.svg' 
 B=ob.getBoundBox() 
 print 'BOUND', B 
 B1=((B[3][0]-B[0][0])**2.0 + (B[3][1]-B[0][1])**2.0 + (B[3][2]-B[0][2])**2.0)**0.5 
 B2=((B[7][0]-B[3][0])**2.0 + (B[7][1]-B[3][1])**2.0 + (B[7][2]-B[3][2])**2.0)**0.5 
 BASE="""<?xml version="1.0" standalone="no"?> 
 <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 20010904//EN"  
   "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd"> 
 <svg width="%s" height="%s"  viewBox="0 0 %s %s" 
   xmlns="http://www.w3.org/2000/svg"> 
 <title>coubre de bezier : %s</title> 
   <desc>Un trace dessinant une courbe de type bezie issue de blender</desc> 
 """%(B2,B1,B2,B1,ob.getName()) 
 END="""</svg>""" 
 DECALAGE=B[0][0]-ob.getLocation()[0], ob.getLocation()[1]-B[0][1] 
 SX,SY,SZ=ob.getSize() 
 SY*=-1.0 
 FILE=open(FILE_ADDRESS,'w') 
 FILE.write(BASE) 
 curve = ob.getData() 
 for cur in curve: 
  if not cur.isNurb(): 
   n=0 
   PATH="""<g transform> 
   <path d="chemin"/></g>\n""" 
   for point in cur: 
    if n==0:  
     ORIGINE=point.getTriple() 
     CHEMIN="M %s %s\n"%(ORIGINE[1][0]*SX,ORIGINE[1][1]*SY+B1) 
     PREV=ORIGINE[2][0],ORIGINE[2][1] 
     n+=1 
    else:  
     P=point.getTriple() 
     CHEMIN+="C %s %s %s %s %s %s \n"%(PREV[0]*SX, 
              PREV[1]*SY+B1, 
              P[0][0]*SX, 
              P[0][1]*SY+B1, 
              P[1][0]*SX, 
              P[1][1]*SY+B1) 
     PREV=P[2][0],P[2][1] 
     #print CHEMIN 
   if cur.isCyclic(): 
    CHEMIN+="C %s %s %s %s %s %s \n"%(PREV[0]*SX, 
              PREV[1]*SY+B1, 
              ORIGINE[0][0]*SX, 
              ORIGINE[0][1]*SY+B1, 
              ORIGINE[1][0]*SX, 
              ORIGINE[1][1]*SY+B1) 
    CHEMIN+="Z" 
   PATH=PATH.replace('transform',"transform=\"translate(-%s -%s)\""%(DECALAGE[0],DECALAGE[1]))#DECALAGE[0],DECALAGE[1]))  
   PATH=PATH.replace('chemin',CHEMIN)  
   FILE.write(PATH) 
 FILE.write(END) 
 FILE.close() 
  

def fs_callback(filename): 
 global OBJS, CONFIRM_OVERWRITE 
 if not filename.endswith('.svg'): filename = '%s.svg' % filename 
 if bsys.exists(filename) and CONFIRM_OVERWRITE: 
  if Blender.Draw.PupMenu('OVERWRITE?%t|File exists') != 1: 
   return 
 Blender.Window.WaitCursor(1) 
 SVGBzCurve_export(OBJS[0],filename) 
 Blender.Window.WaitCursor(0) 
 return 

OBJS = Blender.Object.GetSelected() 

if not OBJS: 
 Blender.Draw.PupMenu('ERROR: No objects selected') 
else: 
 fname = bsys.makename(ext=".svg") 
 FileSelector(fs_callback, "Bez Curve to SVG", fname)
