#!BPY
"""
Name: 'Sqorus'
Blender: 248
Group: 'AddMesh'
"""
__author__ = ["Four Mad Men", "FourMadMen.com"]
__version__ = '1.00'
__url__ = ["http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Sqorus"]
__email__=["bwiki {at} fourmadmen {dot} com"]


__bpydoc__ = """

Usage:

* Launch from Add Mesh menu

* Modify parameters as desired or keep defaults

"""
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008, FourMadMen.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****

import BPyAddMesh
import Blender

def add_sqorus(PREF_WIDTH, PREF_HEIGHT, PREF_DEPTH):
	Vector = Blender.Mathutils.Vector
	#RotationMatrix = Blender.Mathutils.RotationMatrix
	verts = []
	faces = []
	
	half_depth = PREF_DEPTH * .5
	
	for i in range(4):
		y = float(i) / 3 * PREF_HEIGHT
		
		for j in range(4):
			x = float(j) / 3 * PREF_WIDTH
			
			verts.append( Vector(x, y, half_depth) )
			verts.append( Vector(x, y, -half_depth) )
	
	for i in (0, 2, 4, 8, 12, 16, 18, 20):
		faces.append( (i, i+2, i+10, i+8) )
		faces.append( (i+1, i+9, i+11, i+3) )
	
	for i in (0, 8, 16):
		faces.append( (i, i+8, i+9, i+1) )
		
	for i in (6, 14, 22):
		faces.append( (i, i+1, i+9, i+8) )
		
	for i in (0, 2, 4):
		faces.append( (i, i+1, i+3, i+2) )
		
	for i in (24, 26, 28):
		faces.append( (i, i+2, i+3, i+1) )

	i=10
	faces.append( (i, i+1, i+9, i+8) )

	i=12
	faces.append( (i, i+8, i+9, i+1) )
	
	i=18
	faces.append( (i, i+1, i+3, i+2) )
	
	i=10
	faces.append( (i, i+2, i+3, i+1) )
	
	return verts, faces

def main():
	Draw = Blender.Draw
	PREF_WIDTH = Draw.Create(2.0)
	PREF_HEIGHT = Draw.Create(2.0)
	PREF_DEPTH = Draw.Create(0.25)
	
	if not Draw.PupBlock('Add Spindle', [\
	('Width:', PREF_WIDTH,  0.01, 100, 'Width of Sqorus'),\
	('Height:', PREF_HEIGHT,  0.01, 100, 'Height of Sqorus'),\
	('Depth:', PREF_DEPTH,  0.01, 100, 'Depth of Sqorus'),\
	]):
		return
	
	verts, faces = add_sqorus(PREF_WIDTH.val, PREF_HEIGHT.val, PREF_DEPTH.val)
	
	BPyAddMesh.add_mesh_simple('Sqorus', verts, [], faces)

main()

