#!BPY
# -*- coding: latin-1 -*-
"""
Name: 'Overlay Wire on Mesh'
Blender: 248
Group: 'Render'
Tooltip: 'Pointing out the mesh-structure for rendering'
"""

__author__ = ["Mathias Weitz"]
__url__ = ("blender")
__version__ = "0.0.8 4/5/08"

__bpydoc__ = """\
this has been a idea in i read in blendpolis \
to make the mesh structure visible \
"""
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008 Mathias Weitz
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

import Blender
from Blender import *
from Blender import NMesh
from Blender.BGL import *
from Blender.Draw import *

import math
from math import *

# Events
EVENT_NOEVENT    = 1
EVENT_START      = 2
EVENT_EXIT       = 3

# Inits


######################################################
# GUI drawing
######################################################
def draw():
	global EVENT_NOEVENT,EVENT_START,EVENT_EXIT 
	
	########## Titles
	glClear(GL_COLOR_BUFFER_BIT)
	glColor3f(0,0,0)
	glRasterPos2d(10,195)
	Text ("Wire Overlay v0.0.1")
	glRasterPos2d(15,180)
	Text ("overlays a copy of the mesh with a wire-material")
	glRasterPos2d(15,165)
	Text ("this is just for pointing out the mesh structure while rendering")
	glRasterPos2d(15,150)
	Text ("the copied objects should be deleted while working on the mesh")
	glRasterPos2d(25,125)
	Text ("Remarks:")
	glRasterPos2d(45,110)
	Text ("- the copied object is primarily complete black")
	glRasterPos2d(45,95)
	Text ("- you can change the wire-material, this material will be used on further overlays")
	glRasterPos2d(45,80)
	Text ("- the name of the overlay-object starts with 'Wired.Overlay'")
	glRasterPos2d(60,65)
	Text ("check this out when you delete the objects")
	#Text ("Cross makes a direkt connection")
	#glRasterPos2d(15,115)
	#Text ("Es kommt nur auf die Richtung an")
					
	Button("Exit",EVENT_EXIT , 160, 10, 90, 18)
	Button("Create Wire-Object",EVENT_START , 10, 10, 150, 18)

def event(evt, val):
	if (evt == QKEY and not val): 
		Exit()

def bevent(evt):
	global EVENT_NOEVENT,EVENT_START,EVENT_EXIT
	if evt == EVENT_EXIT:
		Exit()
	elif evt == EVENT_START:
		startDraw()
		Blender.Redraw()

	
			
###########################################
# Start Test
###########################################

me = 0
	
def startDraw():
	global me
	print "*** start ***"
	time_start = sys.time()
	Blender.Window.EditMode(0)
	
	if me == 0:
		# if the Material exists, take it
		mat = 0
		for ma in Blender.Material.Get():
			if 0 <= ma.getName().find('MyOverlayWire'):
				mat = ma
		scn = Scene.GetCurrent()
		ob = scn.objects.active
		if ob != None:
			me = ob.getData()
			Mesh.Mode(0)
		
			Blender.Object.Duplicate(1) 
			ob2 = scn.objects.active
			me2 = ob2.getData()
			ob2.setName('Wired.Overlay')
										
			#me2.update(1)
			
			co = ob2.constraints.append(Constraint.Type.COPYLOC)
			co[Constraint.Settings.TARGET] = ob
			co = ob2.constraints.append(Constraint.Type.COPYROT)
			co[Constraint.Settings.TARGET] = ob
			co = ob2.constraints.append(Constraint.Type.COPYSIZE)
			co[Constraint.Settings.TARGET] = ob
			
			#for co in ob.constraints:
			#	print co
			#	print co.type
			#	print Constraint.Type.COPYLOC, Constraint.Type.COPYROT, Constraint.Type.COPYSIZE
			#	print co[Constraint.Settings.TARGET]
			#	print co[Constraint.Type.TARGET]
			#for ma in me.getMaterials():
			#	print "*****", ma
			#	print "Color:", ma.getRGBCol()
			#	print ma.getMode() & Material.Modes.ZTRANSP
			#	print ma.getMode() & Material.Modes.WIRE
			#	print "ZOffs:", ma.getZOffset()
			#	print "Alpha:",  ma.getAlpha()
			#	print "Ref:", ma.getRef()
			#	print "Spec:", ma.getSpec()
			#	print "Hard:", ma.getHardness()
			
			if mat == 0:	
				mat = Material.New('MyOverlayWire')
				mat.setRGBCol(0.0,0.0,0.0)
				mat.setMode(Material.Modes.ZTRANSP | Material.Modes.WIRE)
				mat.setZOffset(0.1)
				mat.setRef(0.0)
				mat.setSpec(0)
				mat.setHardness(1)
				
			me2.setMaterials([mat])
			for f in me2.faces:
				f.mat = 0
									
			me2.update(1)
	Blender.Window.EditMode(0)
	me = 0
	print "finished : %.2f"  % (sys.time() - time_start)


#Draw.Register 
Register(draw, event, bevent)