use Unicode::Collate::CJK::Korean;
+{
   locale_version => 0.87,
   overrideCJK => \&Unicode::Collate::CJK::Korean::weightKorean,
   entry => <<'ENTRY', # for DUCET v6.0.0
F967      ; [.3038.0021.0002.4E0D][.30BC.0020.0002.4E0D] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.3038.0032.0002.4E26][.30B5.0020.0002.4E26][.3121.0020.0002.4E26] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.3031.0021.0002.4E32][.30B7.0020.0002.4E32][.3122.0020.0002.4E32] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.3043.0021.0002.4E38][.30B8.0020.0002.4E38][.3110.0020.0002.4E38] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.3034.0021.0002.4E39][.30AF.0020.0002.4E39][.3110.0020.0002.4E39] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.3036.0021.0002.4E82][.30AF.0020.0002.4E82][.3110.0020.0002.4E82] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.3036.0021.0002.4E86][.30BB.0020.0002.4E86] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.3036.0021.0002.4EAE][.30B1.0020.0002.4EAE][.3121.0020.0002.4EAE] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.303A.0021.0002.4EC0][.30C3.0020.0002.4EC0][.311D.0020.0002.4EC0] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.3036.0021.0002.4EE4][.30B5.0020.0002.4EE4][.3121.0020.0002.4EE4] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.3036.0021.0002.4F86][.30B0.0020.0002.4F86] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.3036.0021.0002.4F8B][.30B6.0020.0002.4F8B] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.3037.0021.0002.4FAE][.30B7.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.3037.0021.0002.4FAE][.30B7.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.3041.0023.0002.4FBB][.30AF.0020.0002.4FBB][.3114.0020.0002.4FBB] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.3042.0021.0002.4FBF][.30B5.0020.0002.4FBF][.3110.0020.0002.4FBF] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.3038.0022.0002.5002][.30B5.0020.0002.5002][.3121.0020.0002.5002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.3036.0022.0002.502B][.30C0.0020.0002.502B][.3110.0020.0002.502B] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.3038.0022.0002.5099][.30C3.0020.0002.5099] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.303A.0023.0002.50CF][.30AF.0020.0002.50CF][.3121.0020.0002.50CF] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.3036.0022.0002.50DA][.30BB.0020.0002.50DA] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.303A.0023.0002.50E7][.30C1.0020.0002.50E7][.3121.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.303A.0023.0002.50E7][.30C1.0020.0002.50E7][.3121.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.303C.0021.0002.5140][.30B7.0020.0002.5140][.3114.0020.0002.5140] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.303F.0021.0002.5145][.30BC.0020.0002.5145][.3121.0020.0002.5145] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.3037.0021.0002.514D][.30B5.0020.0002.514D][.3110.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.3037.0021.0002.514D][.30B5.0020.0002.514D][.3110.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F814     ; [.3033.0022.0002.5167][.30B0.0020.0002.5167] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.303D.0024.0002.5168][.30B3.0020.0002.5168][.3110.0020.0002.5168] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.3036.0023.0002.5169][.30B1.0020.0002.5169][.3121.0020.0002.5169] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.3036.0021.0002.516D][.30C0.0020.0002.516D][.310D.0020.0002.516D] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.3031.0026.0002.5177][.30BC.0020.0002.5177] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.3031.0024.0002.5180][.30C3.0020.0002.5180] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.303D.0021.0002.518D][.30B0.0020.0002.518D] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.3037.0022.0002.5192][.30B7.0020.0002.5192] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.3037.0022.0002.5195][.30B5.0020.0002.5195][.3110.0020.0002.5195] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.303C.0023.0002.5197][.30BB.0020.0002.5197][.3121.0020.0002.5197] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.303C.003B.0002.51A4][.30BD.0020.0002.51A4][.3110.0020.0002.51A4] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.3034.0022.0002.51AC][.30B7.0020.0002.51AC][.3121.0020.0002.51AC] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.3036.0021.0002.51B7][.30B0.0020.0002.51B7][.3121.0020.0002.51B7] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.3036.0024.0002.51C9][.30B1.0020.0002.51C9][.3121.0020.0002.51C9] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.3036.0021.0002.51CC][.30C1.0020.0002.51CC][.3121.0020.0002.51CC] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.3036.0021.0002.51DC][.30C1.0020.0002.51DC][.311C.0020.0002.51DC] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.3043.0022.0002.51DE][.30C2.0020.0002.51DE] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81E     ; [.303C.0023.0002.5203][.30C3.0020.0002.5203][.3110.0020.0002.5203] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.303D.0021.0002.5207][.30B3.0020.0002.5207][.3114.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.303D.0021.0002.5207][.30B3.0020.0002.5207][.3114.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.3036.0022.0002.5217][.30B5.0020.0002.5217][.3114.0020.0002.5217] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.3036.0022.0002.5229][.30C3.0020.0002.5229] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.303D.0022.0002.523A][.30AF.0020.0002.523A] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.3031.0021.0002.523B][.30AF.0020.0002.523B][.310D.0020.0002.523B] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.3043.0021.0002.5272][.30AF.0020.0002.5272][.3114.0020.0002.5272] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.303A.002D.0002.5277][.30AF.0020.0002.5277][.3110.0020.0002.5277] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.3036.0021.0002.5289][.30C0.0020.0002.5289] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.3036.0021.0002.529B][.30B5.0020.0002.529B][.310D.0020.0002.529B] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.3036.0023.0002.52A3][.30B5.0020.0002.52A3][.3114.0020.0002.52A3] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.303C.0024.0002.52C7][.30BB.0020.0002.52C7][.3121.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.303C.0024.0002.52C7][.30BB.0020.0002.52C7][.3121.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.3037.0023.0002.52C9][.30B5.0020.0002.52C9][.3110.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.3037.0023.0002.52C9][.30B5.0020.0002.52C9][.3110.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.3036.0021.0002.52D2][.30C1.0020.0002.52D2][.310D.0020.0002.52D2] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.3036.0021.0002.52DE][.30B7.0020.0002.52DE] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.3031.0023.0002.52E4][.30C1.0020.0002.52E4][.3110.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.3031.0023.0002.52E4][.30C1.0020.0002.52E4][.3110.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.3036.0023.0002.52F5][.30B5.0020.0002.52F5] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.303D.0022.0002.52FA][.30AF.0020.0002.52FA][.310D.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.303D.0022.0002.52FA][.30AF.0020.0002.52FA][.310D.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.3042.0022.0002.5305][.30B7.0020.0002.5305] # CJK COMPATIBILITY IDEOGRAPH-2F829
F963      ; [.3038.0021.0002.5317][.30BC.0020.0002.5317][.310D.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.3038.0021.0002.5317][.30BC.0020.0002.5317][.310D.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.3033.0021.0002.533F][.30C3.0020.0002.533F][.310D.0020.0002.533F] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.3043.0021.0002.5349][.30BE.0020.0002.5349] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.3038.0025.0002.5351][.30C3.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.3038.0025.0002.5351][.30C3.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.3038.0022.0002.535A][.30AF.0020.0002.535A][.310D.0020.0002.535A] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.303D.0022.0002.5373][.30C1.0020.0002.5373][.310D.0020.0002.5373] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.3036.0022.0002.5375][.30AF.0020.0002.5375][.3110.0020.0002.5375] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.303D.0021.0002.537D][.30C1.0020.0002.537D][.310D.0020.0002.537D] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.3031.0028.0002.537F][.30B5.0020.0002.537F][.3121.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.3031.0028.0002.537F][.30B5.0020.0002.537F][.3121.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.3031.0028.0002.537F][.30B5.0020.0002.537F][.3121.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.303F.0022.0002.53C3][.30AF.0020.0002.53C3][.311C.0020.0002.53C3] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.3031.0022.0002.53CA][.30C1.0020.0002.53CA][.311D.0020.0002.53CA] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.303A.005E.0002.53DF][.30BC.0020.0002.53DF] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.3031.002A.0002.53E5][.30BC.0020.0002.53E5] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.3031.0021.0002.53EB][.30C0.0020.0002.53EB] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.303D.0022.0002.53F1][.30C3.0020.0002.53F1][.3114.0020.0002.53F1] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.3036.0024.0002.540F][.30C3.0020.0002.540F] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.3036.0021.0002.541D][.30C3.0020.0002.541D][.3110.0020.0002.541D] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.3043.0021.0002.5438][.30C1.0020.0002.5438][.311D.0020.0002.5438] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.3036.0024.0002.5442][.30B5.0020.0002.5442] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.303D.0026.0002.5448][.30B3.0020.0002.5448][.3121.0020.0002.5448] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.303D.0028.0002.5468][.30BC.0020.0002.5468] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.303C.0031.0002.54A2][.30AF.0020.0002.54A2][.310D.0020.0002.54A2] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.303C.0025.0002.54BD][.30C3.0020.0002.54BD][.3110.0020.0002.54BD] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.3034.0021.0002.5510][.30AF.0020.0002.5510][.3121.0020.0002.5510] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.3031.0022.0002.5553][.30B6.0020.0002.5553] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.3043.0024.0002.5563][.30AF.0020.0002.5563][.311C.0020.0002.5563] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.303A.0024.0002.5584][.30B3.0020.0002.5584][.3110.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.303A.0024.0002.5584][.30B3.0020.0002.5584][.3110.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.3036.0021.0002.5587][.30AF.0020.0002.5587] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.3043.0022.0002.5599][.30BE.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.3043.0022.0002.5599][.30BE.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.3031.0022.0002.559D][.30AF.0020.0002.559D][.3114.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.3031.0022.0002.559D][.30AF.0020.0002.559D][.3114.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.3032.0021.0002.55AB][.30C3.0020.0002.55AB][.310D.0020.0002.55AB] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA7B      ; [.303C.0022.0002.55E2][.30B7.0020.0002.55E2][.3114.0020.0002.55E2] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.3041.0022.0002.5606][.30AF.0020.0002.5606][.3110.0020.0002.5606] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.3041.0022.0002.5606][.30AF.0020.0002.5606][.3110.0020.0002.5606] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.3031.0026.0002.5668][.30C3.0020.0002.5668] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.3038.0023.0002.5674][.30BC.0020.0002.5674][.3110.0020.0002.5674] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.3036.0023.0002.56F9][.30B5.0020.0002.56F9][.3121.0020.0002.56F9] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.3034.0024.0002.5716][.30B7.0020.0002.5716] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.3043.0024.0002.578B][.30B5.0020.0002.578B][.3121.0020.0002.578B] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.303A.0021.0002.57CE][.30B3.0020.0002.57CE][.3121.0020.0002.57CE] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.303A.0021.0002.57F4][.30C3.0020.0002.57F4][.310D.0020.0002.57F4] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.3038.0023.0002.5831][.30B7.0020.0002.5831] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.3038.0033.0002.5840][.30B5.0020.0002.5840][.3121.0020.0002.5840] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.303F.0022.0002.585A][.30B7.0020.0002.585A][.3121.0020.0002.585A] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.303F.0022.0002.585A][.30B7.0020.0002.585A][.3121.0020.0002.585A] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.303A.0021.0002.585E][.30B0.0020.0002.585E] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.3037.0021.0002.58A8][.30BC.0020.0002.58A8][.310D.0020.0002.58A8] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.3038.0024.0002.58B3][.30BC.0020.0002.58B3][.3110.0020.0002.58B3] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.3036.0021.0002.58D8][.30BC.0020.0002.58D8] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.3036.0021.0002.58DF][.30B7.0020.0002.58DF][.3121.0020.0002.58DF] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.3038.0032.0002.5906][.30B7.0020.0002.5906][.3121.0020.0002.5906] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.3034.0021.0002.591A][.30AF.0020.0002.591A] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.3037.0021.0002.5922][.30B7.0020.0002.5922][.3121.0020.0002.5922] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.303C.0024.0002.5944][.30B3.0020.0002.5944][.311C.0020.0002.5944] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.3033.0023.0002.5948][.30B0.0020.0002.5948] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.3031.0024.0002.5951][.30B6.0020.0002.5951] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.3038.0025.0002.5954][.30BC.0020.0002.5954][.3110.0020.0002.5954] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.303A.0030.0002.5962][.30AF.0020.0002.5962] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.3033.0021.0002.5973][.30B5.0020.0002.5973] # CJK COMPATIBILITY IDEOGRAPH-F981
2F862     ; [.3043.0026.0002.59EC][.30C2.0020.0002.59EC] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.303C.002C.0002.5A1B][.30B7.0020.0002.5A1B] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.3041.0030.0002.5A27][.30B0.0020.0002.5A27] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.3038.0027.0002.5A62][.30C3.0020.0002.5A62] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.3038.002B.0002.5A66][.30BC.0020.0002.5A66] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.303C.0025.0002.5AB5][.30C3.0020.0002.5AB5][.3121.0020.0002.5AB5] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.303C.0041.0002.5B08][.30BB.0020.0002.5B08] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.303D.003C.0002.5B28][.30AF.0020.0002.5B28] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.3036.0029.0002.5B3E][.30AF.0020.0002.5B3E][.3110.0020.0002.5B3E] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.3036.0029.0002.5B3E][.30AF.0020.0002.5B3E][.3110.0020.0002.5B3E] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.3034.0021.0002.5B85][.30B0.0020.0002.5B85][.310D.0020.0002.5B85] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.303C.0029.0002.5BC3][.30BD.0020.0002.5BC3][.3110.0020.0002.5BC3] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.303F.003B.0002.5BD8][.30C3.0020.0002.5BD8] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.3033.0021.0002.5BE7][.30B5.0020.0002.5BE7][.3121.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.3033.0021.0002.5BE7][.30B5.0020.0002.5BE7][.3121.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.3033.0021.0002.5BE7][.30B5.0020.0002.5BE7][.3121.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.3036.0023.0002.5BEE][.30BB.0020.0002.5BEE] # CJK COMPATIBILITY IDEOGRAPH-F9BC
F9BD      ; [.3033.0021.0002.5C3F][.30BB.0020.0002.5C3F] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.3034.0028.0002.5C60][.30B7.0020.0002.5C60] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.3036.0023.0002.5C62][.30BC.0020.0002.5C62] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.303F.0021.0002.5C64][.30C1.0020.0002.5C64][.3121.0020.0002.5C64] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.3036.0026.0002.5C65][.30C3.0020.0002.5C65] # CJK COMPATIBILITY IDEOGRAPH-F9DF
2F879     ; [.303A.002A.0002.5CC0][.30BC.0020.0002.5CC0] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.3036.0023.0002.5D19][.30C0.0020.0002.5D19][.3110.0020.0002.5D19] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.3036.0021.0002.5D50][.30AF.0020.0002.5D50][.311C.0020.0002.5D50] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.3036.0025.0002.5DBA][.30B5.0020.0002.5DBA][.3121.0020.0002.5DBA] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.303A.0021.0002.5DE1][.30BC.0020.0002.5DE1][.3110.0020.0002.5DE1] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.303A.0027.0002.5DE2][.30B7.0020.0002.5DE2] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.303A.0022.0002.5DFD][.30B7.0020.0002.5DFD][.3110.0020.0002.5DFD] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.303A.0029.0002.5E28][.30B4.0020.0002.5E28] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.3037.0025.0002.5E3D][.30B7.0020.0002.5E3D] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.3033.0021.0002.5E74][.30B5.0020.0002.5E74][.3110.0020.0002.5E74] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.3034.002B.0002.5EA6][.30B7.0020.0002.5EA6] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.3038.0052.0002.5EB3][.30C3.0020.0002.5EB3] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.303A.0025.0002.5EB6][.30B3.0020.0002.5EB6] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.3036.0021.0002.5EC9][.30B5.0020.0002.5EC9][.311C.0020.0002.5EC9] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.3036.0021.0002.5ECA][.30AF.0020.0002.5ECA][.3121.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.3036.0021.0002.5ECA][.30AF.0020.0002.5ECA][.3121.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.3031.0021.0002.5ED3][.30B8.0020.0002.5ED3][.310D.0020.0002.5ED3] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.3036.0025.0002.5EEC][.30B5.0020.0002.5EEC] # CJK COMPATIBILITY IDEOGRAPH-F982
F943      ; [.3036.0022.0002.5F04][.30B7.0020.0002.5F04][.3121.0020.0002.5F04] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.3034.004B.0002.5F22][.30B7.0020.0002.5F22] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.3034.004B.0002.5F22][.30B7.0020.0002.5F22] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.3043.0025.0002.5F62][.30B5.0020.0002.5F62][.3121.0020.0002.5F62] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.303F.0025.0002.5F69][.30B0.0020.0002.5F69] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.303D.0027.0002.5F6B][.30B7.0020.0002.5F6B] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.3036.0021.0002.5F8B][.30C0.0020.0002.5F8B][.3114.0020.0002.5F8B] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.3038.0026.0002.5FA9][.30B7.0020.0002.5FA9][.310D.0020.0002.5FA9] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.303C.0043.0002.5FAD][.30BB.0020.0002.5FAD] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.303C.002A.0002.5FCD][.30C3.0020.0002.5FCD][.3110.0020.0002.5FCD] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.303D.0026.0002.5FD7][.30C3.0020.0002.5FD7] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.3033.0021.0002.5FF5][.30B5.0020.0002.5FF5][.311C.0020.0002.5FF5] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.3033.0024.0002.6012][.30B7.0020.0002.6012] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.3036.0026.0002.601C][.30B5.0020.0002.601C][.3121.0020.0002.601C] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.303C.0042.0002.6081][.30B5.0020.0002.6081][.3110.0020.0002.6081] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.3043.0026.0002.6094][.30BA.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.3043.0026.0002.6094][.30BA.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.3034.0022.0002.60C7][.30B7.0020.0002.60C7][.3110.0020.0002.60C7] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.3037.002D.0002.60D8][.30AF.0020.0002.60D8][.3121.0020.0002.60D8] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.303C.0025.0002.60E1][.30AF.0020.0002.60E1][.310D.0020.0002.60E1] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.303C.002E.0002.6108][.30C0.0020.0002.6108] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.3036.0022.0002.6144][.30C0.0020.0002.6144][.3114.0020.0002.6144] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.303D.002A.0002.6148][.30AF.0020.0002.6148] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.3043.0027.0002.614C][.30B8.0020.0002.614C][.3121.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.3043.0027.0002.614C][.30B8.0020.0002.614C][.3121.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA8A      ; [.303C.0047.0002.6160][.30B7.0020.0002.6160] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.3031.0028.0002.6168][.30B0.0020.0002.6168] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.3036.0031.0002.617A][.30BC.0020.0002.617A] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.303D.0022.0002.618E][.30C1.0020.0002.618E][.3121.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.303D.0022.0002.618E][.30C1.0020.0002.618E][.3121.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.303D.0022.0002.618E][.30C1.0020.0002.618E][.3121.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.3036.0021.0002.6190][.30B5.0020.0002.6190][.3110.0020.0002.6190] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.3038.0028.0002.61A4][.30BC.0020.0002.61A4][.3110.0020.0002.61A4] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.303F.0030.0002.61AF][.30AF.0020.0002.61AF][.311C.0020.0002.61AF] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.3043.0021.0002.61B2][.30B3.0020.0002.61B2][.3110.0020.0002.61B2] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.3037.0025.0002.61DE][.30B7.0020.0002.61DE][.3121.0020.0002.61DE] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.303D.0022.0002.61F2][.30C3.0020.0002.61F2][.3121.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.303D.0022.0002.61F2][.30C3.0020.0002.61F2][.3121.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.303D.0022.0002.61F2][.30C3.0020.0002.61F2][.3121.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.3036.0022.0002.61F6][.30AF.0020.0002.61F6] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.3036.0022.0002.61F6][.30AF.0020.0002.61F6] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.3036.0022.0002.6200][.30B5.0020.0002.6200][.3110.0020.0002.6200] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.303A.0026.0002.6210][.30B3.0020.0002.6210][.3121.0020.0002.6210] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
F9D2      ; [.3036.0022.0002.622E][.30C0.0020.0002.622E][.310D.0020.0002.622E] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.3034.0029.0002.6234][.30B0.0020.0002.6234] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.3042.002B.0002.62B1][.30B7.0020.0002.62B1] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.3036.0021.0002.62C9][.30AF.0020.0002.62C9][.311D.0020.0002.62C9] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.3033.0024.0002.62CF][.30AF.0020.0002.62CF] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.303F.0026.0002.62D3][.30B3.0020.0002.62D3][.310D.0020.0002.62D3] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.3038.0022.0002.62D4][.30AF.0020.0002.62D4][.3114.0020.0002.62D4] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.303A.0022.0002.62FE][.30C1.0020.0002.62FE][.311D.0020.0002.62FE] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.3037.0027.0002.633D][.30AF.0020.0002.633D][.3110.0020.0002.633D] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.303C.0027.0002.6350][.30B5.0020.0002.6350][.3110.0020.0002.6350] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.303A.0039.0002.6368][.30AF.0020.0002.6368] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.3033.0024.0002.637B][.30B5.0020.0002.637B][.311C.0020.0002.637B] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.303A.0029.0002.6383][.30B7.0020.0002.6383] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.3036.0021.0002.63A0][.30B1.0020.0002.63A0][.310D.0020.0002.63A0] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.303C.0025.0002.63A9][.30B3.0020.0002.63A9][.311C.0020.0002.63A9] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.303C.0030.0002.63C4][.30C0.0020.0002.63C4] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.303A.0030.0002.641C][.30BC.0020.0002.641C] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.303D.0025.0002.6422][.30C3.0020.0002.6422][.3110.0020.0002.6422] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
2F8C3     ; [.3037.0021.0002.6469][.30AF.0020.0002.6469] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.3033.0022.0002.649A][.30B5.0020.0002.649A][.3110.0020.0002.649A] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.3043.0029.0002.649D][.30BF.0020.0002.649D] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.3036.0023.0002.64C4][.30B7.0020.0002.64C4] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.3037.0025.0002.654F][.30C3.0020.0002.654F][.3110.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.3037.0025.0002.654F][.30C3.0020.0002.654F][.3110.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.303C.0030.0002.6556][.30B7.0020.0002.6556] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.3031.0030.0002.656C][.30B5.0020.0002.656C][.3121.0020.0002.656C] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.303A.0032.0002.6578][.30BC.0020.0002.6578] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.3036.0025.0002.6599][.30BB.0020.0002.6599] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.3036.0028.0002.65C5][.30B5.0020.0002.65C5] # CJK COMPATIBILITY IDEOGRAPH-F983
2F8CB     ; [.3031.0035.0002.65E3][.30C3.0020.0002.65E3] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.303C.0024.0002.6613][.30B5.0020.0002.6613][.310D.0020.0002.6613] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.303D.0026.0002.6649][.30C3.0020.0002.6649][.3110.0020.0002.6649] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.303F.0022.0002.6674][.30B3.0020.0002.6674][.3121.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.303F.0022.0002.6674][.30B3.0020.0002.6674][.3121.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.3043.002A.0002.6688][.30BC.0020.0002.6688][.3110.0020.0002.6688] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.303A.002B.0002.6691][.30B3.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.303A.002B.0002.6691][.30B3.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.3042.0022.0002.66B4][.30B7.0020.0002.66B4][.310D.0020.0002.66B4] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.3036.0022.0002.66C6][.30B5.0020.0002.66C6][.310D.0020.0002.66C6] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.3031.0033.0002.66F4][.30B5.0020.0002.66F4][.3121.0020.0002.66F4] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.303A.002D.0002.66F8][.30B3.0020.0002.66F8] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.303F.0023.0002.6700][.30BA.0020.0002.6700] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.3036.0022.0002.6717][.30AF.0020.0002.6717][.3121.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.3036.0022.0002.6717][.30AF.0020.0002.6717][.3121.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.3036.0022.0002.6717][.30AF.0020.0002.6717][.3121.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.3037.0025.0002.671B][.30AF.0020.0002.671B][.3121.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.3037.0025.0002.671B][.30AF.0020.0002.671B][.3121.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.3036.0028.0002.674E][.30C3.0020.0002.674E] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.3042.0025.0002.6753][.30BB.0020.0002.6753] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.303D.002E.0002.6756][.30AF.0020.0002.6756][.3121.0020.0002.6756] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.3031.0038.0002.675E][.30C3.0020.0002.675E] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.3033.0021.0002.677B][.30C0.0020.0002.677B] # CJK COMPATIBILITY IDEOGRAPH-F9C8
F9F4      ; [.3036.0021.0002.6797][.30C3.0020.0002.6797][.311C.0020.0002.6797] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.3036.0023.0002.67F3][.30C0.0020.0002.67F3] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.3036.0023.0002.6817][.30C0.0020.0002.6817][.3114.0020.0002.6817] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.3036.0025.0002.6881][.30B1.0020.0002.6881][.3121.0020.0002.6881] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.3037.0027.0002.6885][.30B0.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.3037.0027.0002.6885][.30B0.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.3036.0029.0002.68A8][.30C3.0020.0002.68A8] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.303A.0062.0002.6942][.30AF.0020.0002.6942] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EA     ; [.3031.002A.0002.69EA][.30B0.0020.0002.69EA] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.303C.0028.0002.6A02][.30AF.0020.0002.6A02][.310D.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.303C.0028.0002.6A02][.30AF.0020.0002.6A02][.310D.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.303C.0028.0002.6A02][.30AF.0020.0002.6A02][.310D.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.3036.0024.0002.6A13][.30BC.0020.0002.6A13] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.3036.0024.0002.6AD3][.30B7.0020.0002.6AD3] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.303D.0021.0002.6ADB][.30C1.0020.0002.6ADB][.3114.0020.0002.6ADB] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.3036.0023.0002.6B04][.30AF.0020.0002.6B04][.3110.0020.0002.6B04] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.303F.0028.0002.6B21][.30AF.0020.0002.6B21] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.3043.0025.0002.6B54][.30B3.0020.0002.6B54] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.303A.0023.0002.6B72][.30B4.0020.0002.6B72] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.3036.0023.0002.6B77][.30B5.0020.0002.6B77][.310D.0020.0002.6B77] # CJK COMPATIBILITY IDEOGRAPH-F98C
F9A5      ; [.3036.0023.0002.6BAE][.30B5.0020.0002.6BAE][.311C.0020.0002.6BAE] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.303A.0023.0002.6BBA][.30AF.0020.0002.6BBA][.3114.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.303A.0023.0002.6BBA][.30AF.0020.0002.6BBA][.3114.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.303A.0023.0002.6BBA][.30AF.0020.0002.6BBA][.3114.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.3038.0025.0002.6C4E][.30B3.0020.0002.6C4E][.311C.0020.0002.6C4E] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.303F.0024.0002.6C88][.30C3.0020.0002.6C88][.311C.0020.0002.6C88] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.303C.002B.0002.6CBF][.30B5.0020.0002.6CBF][.3110.0020.0002.6CBF] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.3042.0024.0002.6CCC][.30C3.0020.0002.6CCC][.3114.0020.0002.6CCC] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.3033.0022.0002.6CE5][.30C3.0020.0002.6CE5] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.3036.0021.0002.6D1B][.30AF.0020.0002.6D1B][.310D.0020.0002.6D1B] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.3034.002A.0002.6D1E][.30B7.0020.0002.6D1E][.3121.0020.0002.6D1E] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.3042.0029.0002.6D3E][.30AF.0020.0002.6D3E] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.3036.0025.0002.6D41][.30C0.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.3036.0025.0002.6D41][.30C0.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.3036.0025.0002.6D41][.30C0.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.3043.002E.0002.6D69][.30B7.0020.0002.6D69] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.3036.0023.0002.6D6A][.30AF.0020.0002.6D6A][.3121.0020.0002.6D6A] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.3043.002A.0002.6D77][.30B0.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.3043.002A.0002.6D77][.30B0.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.303F.0025.0002.6D78][.30C3.0020.0002.6D78][.311C.0020.0002.6D78] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.303C.0022.0002.6D85][.30B5.0020.0002.6D85][.3114.0020.0002.6D85] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.3036.0022.0002.6DCB][.30C3.0020.0002.6DCB][.311C.0020.0002.6DCB] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.3036.0025.0002.6DDA][.30BC.0020.0002.6DDA] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.3036.0024.0002.6DEA][.30C0.0020.0002.6DEA][.3110.0020.0002.6DEA] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.303C.0026.0002.6DF9][.30B3.0020.0002.6DF9][.311C.0020.0002.6DF9] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.303D.002C.0002.6E1A][.30B3.0020.0002.6E1A] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.3043.002B.0002.6E2F][.30AF.0020.0002.6E2F][.3121.0020.0002.6E2F] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.303C.002B.0002.6E6E][.30C3.0020.0002.6E6E][.3110.0020.0002.6E6E] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.3036.0026.0002.6E9C][.30C0.0020.0002.6E9C] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.3033.0022.0002.6EBA][.30C3.0020.0002.6EBA][.310D.0020.0002.6EBA] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.303D.002B.0002.6ECB][.30AF.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.303D.002B.0002.6ECB][.30AF.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.3043.0022.0002.6ED1][.30B8.0020.0002.6ED1][.3114.0020.0002.6ED1] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.3036.0026.0002.6F0F][.30BC.0020.0002.6F0F] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.3043.0026.0002.6F22][.30AF.0020.0002.6F22][.3110.0020.0002.6F22] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.3043.0026.0002.6F22][.30AF.0020.0002.6F22][.3110.0020.0002.6F22] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.3036.0024.0002.6F23][.30B5.0020.0002.6F23][.3110.0020.0002.6F23] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.303D.0033.0002.6F6E][.30B7.0020.0002.6F6E] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.3038.003C.0002.6FC6][.30BC.0020.0002.6FC6][.3110.0020.0002.6FC6] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.3036.0025.0002.6FEB][.30AF.0020.0002.6FEB][.311C.0020.0002.6FEB] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.3036.002A.0002.6FFE][.30B5.0020.0002.6FFE] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.303C.002D.0002.701B][.30B5.0020.0002.701B][.3121.0020.0002.701B] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.303D.003D.0002.701E][.30B3.0020.0002.701E][.3121.0020.0002.701E] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.303D.003D.0002.701E][.30B3.0020.0002.701E][.3121.0020.0002.701E] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.3043.002D.0002.7070][.30BA.0020.0002.7070] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.303D.002B.0002.707D][.30B0.0020.0002.707D] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.303D.002C.0002.7099][.30AF.0020.0002.7099] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.3041.0028.0002.70AD][.30AF.0020.0002.70AD][.3110.0020.0002.70AD] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.3036.0025.0002.70C8][.30B5.0020.0002.70C8][.3114.0020.0002.70C8] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.3036.0022.0002.70D9][.30AF.0020.0002.70D9][.310D.0020.0002.70D9] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.3036.0025.0002.7149][.30B5.0020.0002.7149][.3110.0020.0002.7149] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.303D.002D.0002.716E][.30AF.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.303D.002D.0002.716E][.30AF.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.3036.0026.0002.71CE][.30BB.0020.0002.71CE] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.3036.0023.0002.71D0][.30C3.0020.0002.71D0][.3110.0020.0002.71D0] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.3036.0027.0002.7210][.30B7.0020.0002.7210] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.3036.0026.0002.721B][.30AF.0020.0002.721B][.3110.0020.0002.721B] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.303F.0036.0002.7228][.30AF.0020.0002.7228][.3110.0020.0002.7228] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.303D.0028.0002.7235][.30AF.0020.0002.7235][.310D.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.303D.0028.0002.7235][.30AF.0020.0002.7235][.310D.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.3036.0023.0002.7262][.30BA.0020.0002.7262] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.303A.0030.0002.7280][.30B3.0020.0002.7280] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.3038.0027.0002.72AF][.30B3.0020.0002.72AF][.311C.0020.0002.72AF] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.303A.0035.0002.72C0][.30AF.0020.0002.72C0][.3121.0020.0002.72C0] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.3036.0024.0002.72FC][.30AF.0020.0002.72FC][.3121.0020.0002.72FC] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.303D.002E.0002.732A][.30B3.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.303D.002E.0002.732A][.30B3.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.3036.0021.0002.7375][.30B5.0020.0002.7375][.311D.0020.0002.7375] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.3034.0023.0002.737A][.30AF.0020.0002.737A][.3114.0020.0002.737A] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.303A.0021.0002.7387][.30B7.0020.0002.7387][.3114.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.303A.0021.0002.7387][.30B7.0020.0002.7387][.3114.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.303C.0025.0002.738B][.30B8.0020.0002.738B][.3121.0020.0002.738B] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.3036.0027.0002.73B2][.30B5.0020.0002.73B2][.3121.0020.0002.73B2] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.3036.0023.0002.73DE][.30AF.0020.0002.73DE][.310D.0020.0002.73DE] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.3036.002D.0002.7406][.30C3.0020.0002.7406] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.3036.0028.0002.7409][.30C0.0020.0002.7409] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.3041.002B.0002.7422][.30AF.0020.0002.7422][.310D.0020.0002.7422] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.303C.003D.0002.745C][.30C0.0020.0002.745C] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.3043.002D.0002.7469][.30B5.0020.0002.7469][.3121.0020.0002.7469] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.303D.0057.0002.7471][.30B3.0020.0002.7471][.3110.0020.0002.7471] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.303D.0057.0002.7471][.30B3.0020.0002.7471][.3110.0020.0002.7471] # CJK COMPATIBILITY IDEOGRAPH-2F930
F994      ; [.3036.0026.0002.7489][.30B5.0020.0002.7489][.3110.0020.0002.7489] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.3036.0024.0002.7498][.30C3.0020.0002.7498][.3110.0020.0002.7498] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.3031.003A.0002.74CA][.30B5.0020.0002.74CA][.3121.0020.0002.74CA] # CJK COMPATIBILITY IDEOGRAPH-2F932
F9CD      ; [.3036.002A.0002.7559][.30C0.0020.0002.7559] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.3036.0022.0002.7565][.30B1.0020.0002.7565][.310D.0020.0002.7565] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.303C.002C.0002.7570][.30C3.0020.0002.7570] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.303C.002C.0002.7570][.30C3.0020.0002.7570] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.3036.002F.0002.75E2][.30C3.0020.0002.75E2] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.303C.0059.0002.7610][.30C0.0020.0002.7610] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.303C.0023.0002.761F][.30B7.0020.0002.761F][.3110.0020.0002.761F] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.3036.0027.0002.7642][.30BB.0020.0002.7642] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.3036.0023.0002.7669][.30AF.0020.0002.7669] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.303C.0022.0002.76CA][.30C3.0020.0002.76CA][.310D.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.303C.0022.0002.76CA][.30C3.0020.0002.76CA][.310D.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.303A.002B.0002.76DB][.30B3.0020.0002.76DB][.3121.0020.0002.76DB] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.3036.0028.0002.76E7][.30B7.0020.0002.76E7] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.303D.0021.0002.76F4][.30C3.0020.0002.76F4][.310D.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.303D.0021.0002.76F4][.30C3.0020.0002.76F4][.310D.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.303A.002C.0002.7701][.30B3.0020.0002.7701][.3121.0020.0002.7701] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.303D.0033.0002.771E][.30C3.0020.0002.771E][.3110.0020.0002.771E] # CJK COMPATIBILITY IDEOGRAPH-2F945
FAAA      ; [.303F.0023.0002.7740][.30AF.0020.0002.7740][.310D.0020.0002.7740] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.303D.0034.0002.778B][.30C3.0020.0002.778B][.3110.0020.0002.778B] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.3036.002C.0002.786B][.30C0.0020.0002.786B] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.3036.0021.0002.788C][.30B7.0020.0002.788C][.310D.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.3036.0021.0002.788C][.30B7.0020.0002.788C][.310D.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.3038.0038.0002.7891][.30C3.0020.0002.7891] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.3036.0024.0002.78CA][.30BA.0020.0002.78CA] # CJK COMPATIBILITY IDEOGRAPH-F947
F964      ; [.3038.0032.0002.78FB][.30AF.0020.0002.78FB][.3110.0020.0002.78FB] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.3036.002B.0002.792A][.30B5.0020.0002.792A] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.303A.0046.0002.793E][.30AF.0020.0002.793E] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.3031.004C.0002.7948][.30C3.0020.0002.7948] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.303D.0035.0002.7949][.30C3.0020.0002.7949] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.303C.0032.0002.7950][.30BC.0020.0002.7950] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.303D.0039.0002.7956][.30B7.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.303D.0039.0002.7956][.30B7.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.303F.0023.0002.795D][.30BC.0020.0002.795D][.310D.0020.0002.795D] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.303A.002C.0002.795E][.30C3.0020.0002.795E][.3110.0020.0002.795E] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.303A.0037.0002.7965][.30AF.0020.0002.7965][.3121.0020.0002.7965] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.3036.0022.0002.797F][.30B7.0020.0002.797F][.310D.0020.0002.797F] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.3043.0027.0002.798D][.30B8.0020.0002.798D] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.303D.0044.0002.798E][.30B3.0020.0002.798E][.3121.0020.0002.798E] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.3038.0028.0002.798F][.30B7.0020.0002.798F][.310D.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.3038.0028.0002.798F][.30B7.0020.0002.798F][.310D.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.3036.0023.0002.79AE][.30B6.0020.0002.79AE] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.3033.0023.0002.79CA][.30B5.0020.0002.79CA][.3110.0020.0002.79CA] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.303F.0024.0002.79EB][.30BC.0020.0002.79EB][.3114.0020.0002.79EB] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.3036.0023.0002.7A1C][.30C1.0020.0002.7A1C][.3121.0020.0002.7A1C] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.3031.0025.0002.7A40][.30B7.0020.0002.7A40][.310D.0020.0002.7A40] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.3031.0025.0002.7A40][.30B7.0020.0002.7A40][.310D.0020.0002.7A40] # CJK COMPATIBILITY IDEOGRAPH-2F959
FA55      ; [.3034.0022.0002.7A81][.30B7.0020.0002.7A81][.3114.0020.0002.7A81] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.3036.0022.0002.7ACB][.30C3.0020.0002.7ACB][.311D.0020.0002.7ACB] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.3036.0023.0002.7B20][.30C3.0020.0002.7B20][.311D.0020.0002.7B20] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.303D.0027.0002.7BC0][.30B3.0020.0002.7BC0][.3114.0020.0002.7BC0] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.303D.0027.0002.7BC0][.30B3.0020.0002.7BC0][.3114.0020.0002.7BC0] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.303D.003D.0002.7BC6][.30B3.0020.0002.7BC6][.3110.0020.0002.7BC6] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.303F.0026.0002.7BC9][.30BC.0020.0002.7BC9][.310D.0020.0002.7BC9] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.3036.0025.0002.7C3E][.30B5.0020.0002.7C3E][.311C.0020.0002.7C3E] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.3036.0026.0002.7C60][.30B7.0020.0002.7C60][.3121.0020.0002.7C60] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.3036.0024.0002.7C92][.30C3.0020.0002.7C92][.311D.0020.0002.7C92] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.303D.0047.0002.7CBE][.30B3.0020.0002.7CBE][.3121.0020.0002.7CBE] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.3034.0029.0002.7CD6][.30AF.0020.0002.7CD6][.3121.0020.0002.7CD6] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.3036.0029.0002.7CE7][.30B1.0020.0002.7CE7][.3121.0020.0002.7CE7] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.3031.004F.0002.7D00][.30C3.0020.0002.7D00] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.3033.0022.0002.7D10][.30C0.0020.0002.7D10] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.303A.0023.0002.7D22][.30B0.0020.0002.7D22][.310D.0020.0002.7D22] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.3036.0028.0002.7D2F][.30BC.0020.0002.7D2F] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.303D.0063.0002.7D5B][.30B7.0020.0002.7D5B] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.3038.0034.0002.7D63][.30B5.0020.0002.7D63][.3121.0020.0002.7D63] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.3036.0023.0002.7DA0][.30B7.0020.0002.7DA0][.310D.0020.0002.7DA0] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.3036.0024.0002.7DBE][.30C1.0020.0002.7DBE][.3121.0020.0002.7DBE] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.303F.0030.0002.7DC7][.30C3.0020.0002.7DC7] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.3036.0027.0002.7DF4][.30B5.0020.0002.7DF4][.3110.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.3036.0027.0002.7DF4][.30B5.0020.0002.7DF4][.3110.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.3036.0027.0002.7DF4][.30B5.0020.0002.7DF4][.3110.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.303D.0036.0002.7E09][.30C3.0020.0002.7E09][.3110.0020.0002.7E09] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.3036.0029.0002.7E37][.30BC.0020.0002.7E37] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.3038.0026.0002.7E41][.30B3.0020.0002.7E41][.3110.0020.0002.7E41] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.303A.0052.0002.7E45][.30B7.0020.0002.7E45] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.3038.0035.0002.7F3E][.30B5.0020.0002.7F3E][.3121.0020.0002.7F3E] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.303A.0035.0002.7F72][.30B3.0020.0002.7F72] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.3036.0031.0002.7F79][.30C3.0020.0002.7F79] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.3036.0024.0002.7F85][.30AF.0020.0002.7F85] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.3036.0029.0002.7F9A][.30B5.0020.0002.7F9A][.3121.0020.0002.7F9A] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.303C.0036.0002.7FBD][.30BC.0020.0002.7FBD] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.3031.005A.0002.7FFA][.30B7.0020.0002.7FFA] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.3036.0029.0002.8001][.30B7.0020.0002.8001] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.303D.0033.0002.8005][.30AF.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.303D.0033.0002.8005][.30AF.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.303D.0033.0002.8005][.30AF.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.3036.002B.0002.8046][.30B5.0020.0002.8046][.3121.0020.0002.8046] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.3036.0028.0002.806F][.30B5.0020.0002.806F][.3110.0020.0002.806F] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.303F.0028.0002.8070][.30B7.0020.0002.8070][.3121.0020.0002.8070] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.3036.0027.0002.807E][.30B7.0020.0002.807E][.3121.0020.0002.807E] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.3036.0022.0002.808B][.30C1.0020.0002.808B][.310D.0020.0002.808B] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.3033.0023.0002.80AD][.30BC.0020.0002.80AD][.3114.0020.0002.80AD] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.303C.0024.0002.80B2][.30C0.0020.0002.80B2][.310D.0020.0002.80B2] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.3038.003F.0002.813E][.30C3.0020.0002.813E] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.3036.0022.0002.81D8][.30AF.0020.0002.81D8][.311D.0020.0002.81D8] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.3036.0024.0002.81E8][.30C3.0020.0002.81E8][.311C.0020.0002.81E8] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.303F.002A.0002.81ED][.30BF.0020.0002.81ED] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.303C.002E.0002.8201][.30B5.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.303C.002E.0002.8201][.30B5.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F98B
F97C      ; [.3036.002A.0002.826F][.30B1.0020.0002.826F][.3121.0020.0002.826F] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.303C.0037.0002.828B][.30BC.0020.0002.828B] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.303D.003B.0002.829D][.30C3.0020.0002.829D] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.3043.0029.0002.82B1][.30B8.0020.0002.82B1] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.3038.0035.0002.82B3][.30AF.0020.0002.82B3][.3121.0020.0002.82B3] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.303C.0029.0002.82BD][.30AF.0020.0002.82BD] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.303C.0023.0002.82E5][.30B1.0020.0002.82E5][.310D.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.303C.0023.0002.82E5][.30B1.0020.0002.82E5][.310D.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.3031.003A.0002.82E6][.30B7.0020.0002.82E6] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.303F.002E.0002.831D][.30B0.0020.0002.831D] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.303C.004C.0002.8323][.30B7.0020.0002.8323] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.3034.0022.0002.8336][.30AF.0020.0002.8336] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.3043.0034.0002.8352][.30B8.0020.0002.8352][.3121.0020.0002.8352] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.3037.002A.0002.83BD][.30AF.0020.0002.83BD][.3121.0020.0002.83BD] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.3036.0024.0002.83C9][.30B7.0020.0002.83C9][.310D.0020.0002.83C9] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.3031.0023.0002.83CA][.30BC.0020.0002.83CA][.310D.0020.0002.83CA] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.3031.0025.0002.83CC][.30C0.0020.0002.83CC][.3110.0020.0002.83CC] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.303F.0029.0002.83DC][.30B0.0020.0002.83DC] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.3043.002A.0002.83EF][.30B8.0020.0002.83EF] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.3036.0025.0002.83F1][.30C1.0020.0002.83F1][.3121.0020.0002.83F1] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.3036.0025.0002.843D][.30AF.0020.0002.843D][.310D.0020.0002.843D] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.303C.0023.0002.8449][.30B5.0020.0002.8449][.311D.0020.0002.8449] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.303D.0034.0002.8457][.30B3.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.303D.0034.0002.8457][.30B3.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.3036.0029.0002.84EE][.30B5.0020.0002.84EE][.3110.0020.0002.84EE] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.3042.002A.0002.84F1][.30B5.0020.0002.84F1][.3121.0020.0002.84F1] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
F9C2      ; [.3036.002A.0002.84FC][.30BB.0020.0002.84FC] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.303C.0062.0002.8564][.30C0.0020.0002.8564] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.3036.0028.0002.85CD][.30AF.0020.0002.85CD][.311C.0020.0002.85CD] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.3036.0025.0002.85FA][.30C3.0020.0002.85FA][.3110.0020.0002.85FA] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.3036.002A.0002.8606][.30B7.0020.0002.8606] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.3036.0027.0002.862D][.30AF.0020.0002.862D][.3110.0020.0002.862D] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.3036.0025.0002.863F][.30AF.0020.0002.863F] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.3043.0023.0002.8650][.30AF.0020.0002.8650][.310D.0020.0002.8650] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.3036.002B.0002.865C][.30B7.0020.0002.865C] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.3036.002B.0002.865C][.30B7.0020.0002.865C] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.3043.0025.0002.8667][.30C0.0020.0002.8667] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.303F.0034.0002.86A9][.30C3.0020.0002.86A9] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BC     ; [.303D.0026.0002.8728][.30B3.0020.0002.8728][.311D.0020.0002.8728] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
F911      ; [.3036.0026.0002.87BA][.30AF.0020.0002.87BA] # CJK COMPATIBILITY IDEOGRAPH-F911
F927      ; [.3036.0023.0002.881F][.30AF.0020.0002.881F][.311D.0020.0002.881F] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.3043.0025.0002.884C][.30B0.0020.0002.884C][.3121.0020.0002.884C] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.303C.0030.0002.8863][.30C2.0020.0002.8863] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.3036.0026.0002.88C2][.30B5.0020.0002.88C2][.3114.0020.0002.88C2] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.3036.0034.0002.88CF][.30C3.0020.0002.88CF] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.3036.0035.0002.88E1][.30C3.0020.0002.88E1] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.3036.0027.0002.88F8][.30AF.0020.0002.88F8] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.3031.0028.0002.8910][.30AF.0020.0002.8910][.3114.0020.0002.8910] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.3031.0034.0002.8941][.30AF.0020.0002.8941][.3121.0020.0002.8941] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.3036.0029.0002.8964][.30AF.0020.0002.8964][.311C.0020.0002.8964] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.3038.002D.0002.8986][.30B7.0020.0002.8986][.310D.0020.0002.8986] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.3031.0028.0002.898B][.30B5.0020.0002.898B][.3110.0020.0002.898B] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.303A.0037.0002.8996][.30C3.0020.0002.8996] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.303A.0037.0002.8996][.30C3.0020.0002.8996] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.303A.0031.0002.8AA0][.30B3.0020.0002.8AA0][.3121.0020.0002.8AA0] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.303A.002B.0002.8AAA][.30B3.0020.0002.8AAA][.3114.0020.0002.8AAA] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.303A.002B.0002.8AAA][.30B3.0020.0002.8AAA][.3114.0020.0002.8AAA] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.303D.0046.0002.8ABF][.30B7.0020.0002.8ABF] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.303F.0026.0002.8ACB][.30B3.0020.0002.8ACB][.3121.0020.0002.8ACB] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.3036.002B.0002.8AD2][.30B1.0020.0002.8AD2][.3121.0020.0002.8AD2] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.3036.0021.0002.8AD6][.30B7.0020.0002.8AD6][.3110.0020.0002.8AD6] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.303C.0046.0002.8AED][.30C0.0020.0002.8AED] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.303C.0046.0002.8AED][.30C0.0020.0002.8AED] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.303D.0030.0002.8AF8][.30B4.0020.0002.8AF8] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.303D.0030.0002.8AF8][.30B4.0020.0002.8AF8] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.3033.0021.0002.8AFE][.30AF.0020.0002.8AFE][.310D.0020.0002.8AFE] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.3033.0021.0002.8AFE][.30AF.0020.0002.8AFE][.310D.0020.0002.8AFE] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.303C.0022.0002.8B01][.30AF.0020.0002.8B01][.3114.0020.0002.8B01] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.303C.0022.0002.8B01][.30AF.0020.0002.8B01][.3114.0020.0002.8B01] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.3031.002D.0002.8B39][.30C1.0020.0002.8B39][.3110.0020.0002.8B39] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.3031.002D.0002.8B39][.30C1.0020.0002.8B39][.3110.0020.0002.8B39] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.303A.002C.0002.8B58][.30C3.0020.0002.8B58][.310D.0020.0002.8B58] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.3034.002A.0002.8B80][.30B7.0020.0002.8B80][.310D.0020.0002.8B80] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.3038.0023.0002.8B8A][.30B5.0020.0002.8B8A][.3110.0020.0002.8B8A] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.3038.0023.0002.8B8A][.30B5.0020.0002.8B8A][.3110.0020.0002.8B8A] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.3031.0057.0002.8C48][.30C3.0020.0002.8C48] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.303A.003B.0002.8C55][.30C3.0020.0002.8C55] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.3031.002E.0002.8CAB][.30B8.0020.0002.8CAB][.3110.0020.0002.8CAB] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.3038.0032.0002.8CC1][.30BC.0020.0002.8CC1][.3110.0020.0002.8CC1] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.3036.0025.0002.8CC2][.30BA.0020.0002.8CC2] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.3031.0039.0002.8CC8][.30AF.0020.0002.8CC8] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.3038.002D.0002.8CD3][.30C3.0020.0002.8CD3][.3110.0020.0002.8CD3] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.303D.002B.0002.8D08][.30C1.0020.0002.8D08][.3121.0020.0002.8D08] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.303D.002B.0002.8D08][.30C1.0020.0002.8D08][.3121.0020.0002.8D08] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.3031.0039.0002.8D1B][.30B7.0020.0002.8D1B][.3121.0020.0002.8D1B] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.3031.0058.0002.8D77][.30C3.0020.0002.8D77] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.3038.0027.0002.8DCB][.30AF.0020.0002.8DCB][.3114.0020.0002.8DCB] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.3036.002C.0002.8DEF][.30B7.0020.0002.8DEF] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.303F.002D.0002.8ECA][.30AF.0020.0002.8ECA] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.3036.002A.0002.8F26][.30B5.0020.0002.8F26][.3110.0020.0002.8F26] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.3036.0026.0002.8F2A][.30C0.0020.0002.8F2A][.3110.0020.0002.8F2A] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.303A.004F.0002.8F38][.30BC.0020.0002.8F38] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.303A.004F.0002.8F38][.30BC.0020.0002.8F38] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.3038.002F.0002.8F3B][.30B7.0020.0002.8F3B][.310D.0020.0002.8F3B] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.3036.0026.0002.8F62][.30B5.0020.0002.8F62][.310D.0020.0002.8F62] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.303D.003E.0002.8FB0][.30C3.0020.0002.8FB0][.3110.0020.0002.8FB0] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.3036.002B.0002.9023][.30B5.0020.0002.9023][.3110.0020.0002.9023] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.303C.0027.0002.9038][.30C3.0020.0002.9038][.3114.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.303C.0027.0002.9038][.30C3.0020.0002.9038][.3114.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.303D.0041.0002.9072][.30C3.0020.0002.9072] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.3036.002B.0002.907C][.30BB.0020.0002.907C] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.3036.0028.0002.908F][.30AF.0020.0002.908F] # CJK COMPATIBILITY IDEOGRAPH-F913
FA26      ; [.3034.0045.0002.90FD][.30B7.0020.0002.90FD] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.3036.0026.0002.916A][.30AF.0020.0002.916A][.310D.0020.0002.916A] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.3036.0024.0002.91B4][.30B6.0020.0002.91B4] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.3036.0036.0002.91CC][.30C3.0020.0002.91CC] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.3036.002D.0002.91CF][.30B1.0020.0002.91CF][.3121.0020.0002.91CF] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.3031.0021.0002.91D1][.30C3.0020.0002.91D1][.311C.0020.0002.91D1] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.3036.002D.0002.9234][.30B5.0020.0002.9234][.3121.0020.0002.9234] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.3038.002F.0002.9238][.30AF.0020.0002.9238][.3114.0020.0002.9238] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
2F9EA     ; [.3038.0039.0002.927C][.30B5.0020.0002.927C][.3121.0020.0002.927C] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.3043.003F.0002.92D7][.30B5.0020.0002.92D7][.3110.0020.0002.92D7] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
F93F      ; [.3036.0025.0002.9304][.30B7.0020.0002.9304][.310D.0020.0002.9304] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.3036.002C.0002.934A][.30B5.0020.0002.934A][.3110.0020.0002.934A] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EE     ; [.3031.0033.0002.958B][.30B0.0020.0002.958B] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.3036.002E.0002.95AD][.30B5.0020.0002.95AD] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.303C.0031.0002.962E][.30B8.0020.0002.962E][.3110.0020.0002.962E] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.3036.002D.0002.964B][.30BC.0020.0002.964B] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.3031.0037.0002.964D][.30AF.0020.0002.964D][.3121.0020.0002.964D] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.3036.0026.0002.9675][.30C1.0020.0002.9675][.3121.0020.0002.9675] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.3036.0023.0002.9678][.30C0.0020.0002.9678][.310D.0020.0002.9678] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.303D.004E.0002.967C][.30B3.0020.0002.967C] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.3036.0021.0002.9686][.30C0.0020.0002.9686][.3121.0020.0002.9686] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.3036.0027.0002.96A3][.30C3.0020.0002.96A3][.3110.0020.0002.96A3] # CJK COMPATIBILITY IDEOGRAPH-F9F1
F9B8      ; [.3036.0026.0002.96B8][.30B6.0020.0002.96B8] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.3036.0038.0002.96E2][.30C3.0020.0002.96E2] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.3033.0023.0002.96E3][.30AF.0020.0002.96E3][.3110.0020.0002.96E3] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.3033.0023.0002.96E3][.30AF.0020.0002.96E3][.3110.0020.0002.96E3] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.3036.002E.0002.96F6][.30B5.0020.0002.96F6][.3121.0020.0002.96F6] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.3036.0028.0002.96F7][.30BA.0020.0002.96F7] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.303C.0031.0002.9723][.30BC.0020.0002.9723][.3110.0020.0002.9723] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.3036.002E.0002.9732][.30B7.0020.0002.9732] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.3036.002F.0002.9748][.30B5.0020.0002.9748][.3121.0020.0002.9748] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.303D.0054.0002.9756][.30B3.0020.0002.9756][.3121.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.303D.0054.0002.9756][.30B3.0020.0002.9756][.3121.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FAC8
2F9FA     ; [.3042.0034.0002.97E0][.30C3.0020.0002.97E0][.3114.0020.0002.97E0] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.3043.0026.0002.97FF][.30B1.0020.0002.97FF][.3121.0020.0002.97FF] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.3043.0026.0002.97FF][.30B1.0020.0002.97FF][.3121.0020.0002.97FF] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.3036.0030.0002.9818][.30B5.0020.0002.9818][.3121.0020.0002.9818] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.3038.002E.0002.983B][.30C3.0020.0002.983B][.3110.0020.0002.983B] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.3038.002E.0002.983B][.30C3.0020.0002.983B][.3110.0020.0002.983B] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.3036.002E.0002.985E][.30C0.0020.0002.985E] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.3031.005B.0002.98E2][.30C3.0020.0002.98E2] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.3038.0039.0002.98EF][.30AF.0020.0002.98EF][.3110.0020.0002.98EF] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.303A.005A.0002.98FC][.30AF.0020.0002.98FC] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.3031.0030.0002.9928][.30B8.0020.0002.9928][.3110.0020.0002.9928] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.3036.0027.0002.99F1][.30AF.0020.0002.99F1][.310D.0020.0002.99F1] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.3036.0030.0002.9A6A][.30B5.0020.0002.9A6A] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.303D.004C.0002.9B12][.30C3.0020.0002.9B12][.3110.0020.0002.9B12] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.303D.004C.0002.9B12][.30C3.0020.0002.9B12][.3110.0020.0002.9B12] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.3036.002F.0002.9B6F][.30B7.0020.0002.9B6F] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.3036.0028.0002.9C57][.30C3.0020.0002.9C57][.3110.0020.0002.9C57] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.3043.0025.0002.9DB4][.30AF.0020.0002.9DB4][.310D.0020.0002.9DB4] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.3036.0030.0002.9DFA][.30B7.0020.0002.9DFA] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.3036.0028.0002.9E1E][.30AF.0020.0002.9E1E][.3110.0020.0002.9E1E] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.3036.0026.0002.9E7F][.30B7.0020.0002.9E7F][.310D.0020.0002.9E7F] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.3036.0031.0002.9E97][.30B5.0020.0002.9E97] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.3036.0029.0002.9E9F][.30C3.0020.0002.9E9F][.3110.0020.0002.9E9F] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.3037.0028.0002.9EBB][.30AF.0020.0002.9EBB] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.3036.0032.0002.9ECE][.30B5.0020.0002.9ECE] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA1C     ; [.3038.004A.0002.9F3B][.30C3.0020.0002.9F3B] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.3036.0021.0002.9F8D][.30BB.0020.0002.9F8D][.3121.0020.0002.9F8D] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.3036.002E.0002.9F8E][.30B7.0020.0002.9F8E][.3121.0020.0002.9F8E] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.3031.0056.0002.9F9C][.30BC.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.3031.0056.0002.9F9C][.30BC.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.3031.0056.0002.9F9C][.30BC.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
