{$IFDEF WINDOWS}
{$N-,W-,G+,V-}
{$ELSE}
{$E-,N-,V-}
{$ENDIF}

Unit BibStrm;

interface

Uses
{$IFDEF WINDOWS}
  WObjects, WinDos, WinTypes, WinProcs, strings, wHugeMem,
{$ELSE}
  Dos, Objects,
{$ENDIF}
  Streams, bibvars, bibstrg, bibfile, lfnunit;

Const
  WorkVirtualMem:  TStreamRanking = (XMSStream,EMSStream, FileStream,NoStream  );
  WorkFileOnly:    TStreamRanking = (RAMStream,FileStream,NoStream,  NoStream  );
  WorkStreamOrder: TStreamRanking = (RAMStream,XMSStream, EMSStream, FileStream);
  RAMStreamOrder:  TStreamRanking = (RAMStream,NoStream,  NoStream,  NoStream  );

  UseRAMStream: boolean = false;

Var
  TempDirList: Pstring;
  WorkBufSize: Word;

type

  PFixedEMSStream = ^TFixedEMSStream;
  TFixedEMSStream = object(TEmsStream)
    destructor done; virtual;
  end;

  PNamedDOSStream = ^TNamedDOSStream;
  TNamedDOSStream =
    object(TDOSStream)
      { A simple descendant of TDOSStream which knows its own name.}

    {$ifdef windows}
      filename : PChar;
    {$else}
      Filename : PString;
    {$endif}
      { The name of the stream. }

      constructor Init(Name: string; Mode : TOpenMode);
      destructor  Done; virtual;
    end;

  PTempDOSStream = ^TTempDOSStream;
  TTempDOSStream =
    object(TNamedDOSStream)
      constructor Init(InitSize,MaxSize : Longint);
      destructor Done; virtual;
    end;

  PTempBufStream2 = ^TTempBufStream2;
  TTempBufStream2 =
    object(TNamedBufStream)
      { A temporary buffered file stream, which deletes itself when done.
        It's allocated on one of the directories specified in TempDirList.}

      constructor Init(ABufSize : Word;
                       InitSize,MaxSize : Longint);
  { Create a temporary file with a unique name, in the directory
    pointed to by TempDirList or in
    the current directory, open it in read/write mode, and try to grow
    it to InitSize bytes.   }
    destructor done; virtual;
  end;

  PAuxStream = ^TAuxStream;
  TAuxStream = object(TWorkStream)
    PlaceInList: byte;
    constructor init(StrOrder: TStreamRanking);
    destructor Done; virtual;
  end;

  PSafeBufStream = ^TSafeBufStream;
  TSafeBufStream = object(TBufStream)
    PlaceInList: byte;
    constructor init(FileName: string; Mode, Size: Word);
    destructor done; virtual;
  end;


function disk_maxavail2: longint;
function disk_memavail2: longint;
function TempStream2(InitSize, MaxSize : LongInt;
                     Preference : TStreamRanking) : PStream;
{function StreamName(S:PStream):String;}
{ This function returns a string naming the type of S^.  It's useful for
  debugging programs that use TempStream and TWorkStream.  However,
  it's for debugging only!  It links every single stream type into your
  .EXE. }

var
  VirtualStream: PAuxStream;

Implementation

const
  MaxAuxStream = 32;
  MaxBufStream = 8;
  MinBlockSize = 4096;
  MaxBlockSize = 65520;
  MaxRAMStreamSize = 65520;
  RAMStreamMemPool = 20000;
type
  TAuxStreamList = array[1..MaxAuxStream] of PAuxStream;
  TBufStreamList = array[1..MaxBufStream] of PSafeBufStream;
Var
  AuxStreamList: ^TAuxStreamList;
  BufStreamList: ^TBufStreamList;
  i: byte;
  OldExitProc: pointer;

destructor TFixedEMSStream.Done;
begin
  TEMSStream.Done;
  EMSCurHandle:=$FFFF; EMSCurPage:=$FFFF;
end;

function GetTempList: string;
begin
  GetTempList:=TempDirList^;
end;

function MinLong(x,y: longint): longint;
begin
  if x<y then MinLong := x
  else MinLong := y;
end;

function MaxLong(x,y: longint): longint;
begin
  MaxLong := -MinLong(-x,-y);
end;

function GetTempDir(var TempList: string): string;
{ Strip one temp directory off the front of the list, and
  return it fully qualified, with a '\' at the end. }
var
  Semicolon : byte;
  result : string;
  curdir : string;
  FD,FN,FE: Pstring;
begin
  result:='';
  New(FD); New(FN); New(FE);
  repeat
    Semicolon := Pos(';',TempList);
    if Semicolon > 0 then
    begin
      result := Copy(TempList,1,Semicolon-1);
      TempList := Copy(TempList,Semicolon+1,255);
    end else
    begin
      result := TempList;
      TempList := '';
    end;
    if result[Length(result)] <> '\' then
      result := result+'\';
    if (length(result) < 2) or (result[2] <> ':') then
    begin
      GetDir(0,curdir); CurDir:=LFNLongName(CurDir);
    end else
    begin
      GetDir(ord(upcase(result[1]))-ord('A')+1,curdir);
      CurDir:=LFNLongName(CurDir);
      result := copy(result,3,255);
    end;
    if (length(result) > 1) and (result[1] <> '\') then
      result := curdir + '\' + result
    else
      result := copy(curdir,1,2) + result;
    if StrPosLI('[xms]',result) + StrPosLI('[ems]',result) >0 then result:=''
    else if (result<>'') and (StrPosLI('[bibdir]',result)>0) then
    begin
      LFNFSplit(bibname^,FD,FN,FE);
      result:=FD^;
    end;
  until (result<>'') or (TempList='');
  GetTempDir := result;
  Dispose(FE); Dispose(FN); Dispose(FD);
end;                        { GetTempDir }

function disk_maxavail2: longint;
var
  templist,tempname : string;
  result : longint;
begin
  result := 0;
  templist := GetTempList;
  repeat
    tempname := GetTempDir(templist);
    result := MaxLong(result,DriveFree(tempname[1]));
  until templist = '';
  disk_maxavail2 := result;
end;               { disk_maxavail2 }

function disk_memavail2: longint;
var
  templist,tempname : string;
  result,space : longint;
  disk : byte;
  disks : array[1..32] of boolean;
begin
  fillchar(disks,sizeof(disks),false);
  result := 0;
  templist := GetTempList;
  repeat
    tempname := GetTempDir(templist);
    disk := ord(upcase(tempname[1]))-ord('A')+1;
    if not disks[disk] then
    begin
      disks[disk] := true;
{      space := DiskFree(disk);}
      space := DriveFree(tempname[1]);
    end
    else
      space := 0;
    if space > 0 then
      inc(result,space);
  until templist = '';
  disk_memavail2 := result;
end;               { disk_memavail2 }

  { ***** Named Unbuffered file stream code ***** }

constructor TNamedDOSStream.Init(Name: string; Mode : TOpenMode);
{$IFDEF WINDOWS}
var
  P: Pchar;
begin
  GetMem(P,260); StrPCopy(P,LFNShortName(Name));
  if TDOSStream.Init(P, Mode) then
  begin
    StrPcopy(P,Name); FileName:=StrNew(P); FreeMem(P,260);
  end else
  begin
    FreeMem(P,260); Fail;
  end;
{$ELSE}
begin  
  if TDOSStream.init(LFNShortName(Name),Mode) then
    Filename := NewStr(Name)
  else
    Fail;
{$ENDIF}
end;               { TNamedDOSStream.Init }

destructor TNamedDOSStream.Done;
begin
{$ifdef windows}
  StrDispose(filename);
{$else}
  DisposeStr(Filename);
{$endif}
  TDOSStream.Done;
end;

constructor TTempDosStream.Init(InitSize,MaxSize : Longint);
var
  TempList,TempName : String;
  Okay : Boolean;
  NewHandle : Word;
  F : File;
begin
  if not TStream.Init then
    Fail;
  MaxSize := MaxLong(MinLong(MaxSize,Disk_MaxAvail2),InitSize);
  TempList:=GetTempList;
  repeat
    TempName := LFNShortName(GetTempDir(TempList));
    FillChar(TempName[Length(TempName)+1], 255-Length(TempName), #0);
    asm
      push    ds
      push    ss
      pop     ds
      lea     dx,TempName[1]
      mov     ah, $5a
      xor     cx,cx
    {$ifdef windows}
      call dos3call
    {$else}
      int     $21                 { Create temporary file. }
    {$endif}
      pop     ds
      jc      @failed
      mov     Okay,True
      mov     NewHandle,ax
      jmp     @done
@failed:
      mov     Okay,False
@done:
    end;
    if okay then
    begin
      Handle := NewHandle;
      while TempName[Length(TempName)+1] <> #0 do
        Inc(TempName[0]);
      {$ifdef windows}
      Filename := StrNew(StrPCopy(@tempname[1],tempname));
      {$else}
      Filename := NewStr(TempName);
      {$endif}
      Seek(MaxSize-1);
      Write(okay,1);      { Write a 0 }
      Flush;
      Seek(InitSize);
      Truncate;
      okay := Status = stOK;
      if not okay and (TempList <> '') then
      begin
        asm
          mov ah,$3E
          mov bx,NewHandle
          int $21             { Close file }
        end;
{$IFDEF WINDOWS}
        assign(F,StrPas(filename));
{$ELSE}
        assign(F,filename^);
{$ENDIF}
        {$I-}
        Erase(F); if IoResult<>0 then;
        {$I+}
        Reset;
        {$ifdef windows}
        StrDispose(Filename);
        {$else}
        DisposeStr(Filename);
        {$endif}
        Filename := nil;
      end;
    end;
  until okay or (TempList = '');
end;                             { TTempDosStream.Init }

destructor TTempDOSStream.Done;
var
  F : file;
begin
{$ifdef windows}
  assign(f,StrPas(Filename));
{$else}
  Assign(F, Filename^);
{$endif}
  TNamedDOSStream.Done;
  Erase(F);
end;

constructor TTempBufStream2.Init(ABufSize : Word;
                                 InitSize,MaxSize : Longint);
var
  TempList,TempName : String;
  Okay : Boolean;
  NewHandle : Word;
  F : File;
begin
  if not TStream.Init then
    Fail;
  if MaxAvail < ABufSize then
    Fail;
  BufSize := ABufSize;
  GetMem(Buffer, BufSize);
  if Buffer = Nil then { !1.6 }
      Fail;
  MaxSize := MaxLong(MinLong(MaxSize,Disk_MaxAvail2),InitSize);
  TempList:=GetTempList;
  repeat
    TempName := LFNShortName(GetTempDir(TempList));
    FillChar(TempName[Length(TempName)+1], 255-Length(TempName), #0);
    asm
      push    ds
      push    ss
      pop     ds
      lea     dx,TempName[1]
      mov     ah, $5a
      xor     cx,cx
    {$ifdef windows}
      call dos3call
    {$else}
      int     $21                 { Create temporary file. }
    {$endif}
      pop     ds
      jc      @failed
      mov     Okay,True
      mov     NewHandle,ax
      jmp     @done
@failed:
      mov     Okay,False
@done:
    end;
    if okay then
    begin
      Handle := NewHandle;
      while TempName[Length(TempName)+1] <> #0 do
        Inc(TempName[0]);
      {$ifdef windows}
      Filename := StrNew(StrPCopy(@tempname[1],tempname));
      {$else}
      Filename := NewStr(TempName);
      {$endif}
      Seek(MaxSize-1);
      Write(okay,1);      { Write a 0 }
      Flush;
      Seek(InitSize);
      Truncate;
      okay := Status = stOK;
      if not okay and (TempList <> '') then
      begin
        asm
          mov ah,$3E
          mov bx,NewHandle
          int $21             { Close file }
        end;
{$IFDEF WINDOWS}
        assign(F,StrPas(filename));
{$ELSE}
        assign(F,filename^);
{$ENDIF}
        {$I-}
        Erase(F); if IoResult<>0 then;
        {$I+}
        Reset;
        {$ifdef windows}
        StrDispose(Filename);
        {$else}
        DisposeStr(Filename);
        {$endif}
        Filename := nil;
      end;
    end;
  until okay or (TempList = '');
end;                           { TTempBufStream2.Init }

destructor TTempBufStream2.Done;
var
  F : file;
begin
{$ifdef windows}
  assign(f,StrPas(Filename));
{$else}
  Assign(F, Filename^);
{$endif}
  TNamedBufStream.Done;
  Erase(F);
end;

function TempStream2(InitSize, MaxSize : LongInt;
                     Preference : TStreamRanking) : PStream;
var
  Choice : Integer;
  Result : PStream;
  StreamType : TStreamType;
  Nulls : TNulStream;
begin
  Result := nil;
  Nulls.Init(0);
  for Choice := 1 to NumTypes do
  begin
    StreamType := Preference[Choice];
    case StreamType of
      RAMStream :
{$IFDEF WINDOWS}
        if UseRAMStream and (MaxAvail>=MaxSize) then
          result:=New(PHugeMemStream,init(MaxSize));
{$ELSE}
        if UseRAMStream and (MaxSize <= MaxRamStreamSize)
             and (MaxAvail-RAMStreamMemPool>MaxSize) then
          Result := New(PRAMStream, Init(MaxSize));
      EMSStream :
        if EmsExists and (ems_MaxAvail >= MaxSize) then
          Result := New(PFixedEMSStream, Init(InitSize, MaxSize));
      XMSStream :
        if XmsExists and (xms_MaxAvail >= MaxSize) then
          Result := New(PXMSStream, Init(InitSize, MaxSize));
{$ENDIF}
      FileStream :
        if disk_MaxAvail2 >= MaxSize then
        begin
          if WorkBufSize=0 then
            Result := New(PTempDOSStream, Init(InitSize, MaxSize))
          else
            Result := New(PTempBufStream2, Init(WorkBufSize, InitSize, MaxSize));
        end;
    end;
    if (Result <> nil) and (Result^.Status = stOK) then
    begin
      if StreamType<>RAMStream then Result^.Copyfrom(Nulls, InitSize);
      Result^.Seek(0);
      if Result^.Status = stOK then
      begin
        Nulls.Done;
        TempStream2 := Result;
        Exit;
      end;
    end;
    if Result <> nil then
      Dispose(Result, Done); { Clean up and start over } ;
    Result := nil;
  end;
  TempStream2 := nil;
  Nulls.Done;
end;                             { TempStream2 }

constructor TAuxStream.init(StrOrder: TStreamRanking);
var
  i: byte;
begin
  TWorkStream.init(TempStream2,MinBlockSize,MaxBlockSize,StrOrder);
  PlaceInList:=0; i:=0;
  repeat
    inc(i);
    if AuxStreamList^[i]=Nil then PlaceInList:=i;
  until (PlaceInList>0) or (i>=MaxAuxStream);
  if PlaceInList>0 then AuxStreamList^[PlaceInList]:=@Self;
  seek(0);
end;

Destructor TAuxStream.Done;
begin
  if PlaceInList>0 then AuxStreamList^[PlaceInList]:=Nil;
  TWorkStream.Done;
end;

constructor TSafeBufStream.init(FileName: string; Mode,Size: Word);
var
  i: integer;
  F: array[0..255] of char;
begin
  if size=0 then size:=128;
  if LFNAble then
  begin
    if not LFNFileExist(FileName) then
    begin
      Move(FileName[1],F[0],length(FileName)); F[length(FileName)]:=#0;
      DosError:=LCreateEmpty(Pchar(@F));
    end;
    FileName:=LFNShortName(FileName);
  end;
{$IFDEF WINDOWS}
  StrPCopy(F,FileName); TBufStream.init(F,Mode,Size);
{$ELSE}
  TBufStream.init(FileName,Mode,Size);
{$ENDIF}
  PlaceInList:=0; i:=0;
  repeat
    inc(i);
    if BufStreamList^[i]=Nil then PlaceInList:=i;
  until (PlaceInList>0) or (i>=MaxBufStream);
  if PlaceInList>0 then BufStreamList^[PlaceInList]:=@Self;
  seek(0);
end;               { TSafeBufStream }

Destructor TSafeBufStream.Done;
begin
  if PlaceInList>0 then BufStreamList^[PlaceInList]:=Nil;
  TBufStream.Done;
end;

{$IFDEF BLABLAAA}
  function StreamName(S:PStream):String;
  { This function is for debugging only!  It links every single stream
    type into your .EXE. }
  var
    t : pointer;
  begin
    if S=nil then
      StreamName := 'nil'
    else
    begin
      t := typeof(S^);
           if t = typeof(TStream)         then StreamName := 'TStream'
      else if t = typeof(TEMSStream)      then StreamName := 'TEMSStream'
      else if t = typeof(TFixedEMSStream) then StreamName := 'TFixedEMSStream'
      else if t = typeof(TDOSStream)      then StreamName := 'TDOSStream'
      else if t = typeof(TBufStream)      then StreamName := 'TBufStream'
      else if t = typeof(TFilter)         then StreamName := 'TFilter'
      else if t = typeof(TConcatFilter)   then StreamName := 'TConcatFilter'
      else if t = typeof(TNulStream)      then StreamName := 'TNulStream'
      else if t = typeof(TRAMStream)      then StreamName := 'TRAMStream'
      else if t = typeof(TXMSStream)      then StreamName := 'TXMSStream'
      else if t = typeof(TNamedDosStream) then StreamName := 'TNamedDOSStream'
      else if t = typeof(TNamedBufStream) then StreamName := 'TNamedBufStream'
      else if t = typeof(TTempDOSStream)  then StreamName := 'TTempDOSStream'
      else if t = typeof(TTempBufStream2) then StreamName := 'TTempBufStream2'
      else if t = typeof(TWorkStream)     then StreamName := 'TWorkStream'
      else if t = typeof(TAuxStream)      then StreamName := 'TAuxStream'
      else if t = typeof(TSafeBufStream)  then StreamName := 'TSafeBufStream'
      else StreamName := 'Unknown (or uninitialized) stream';
    end;
  end;
{$ENDIF}

{$F+}
procedure StreamExitProc;
var
  i: integer;
begin
  ExitProc:=OldExitProc;
  for i:=1 to MaxAuxStream do
  if AuxStreamList^[i]<>Nil then AuxStreamList^[i]^.Done;
  Dispose(AuxStreamList); AuxStreamList:=Nil;
  for i:=1 to MaxBufStream do
  if BufStreamList^[i]<>Nil then BufStreamList^[i]^.Done;
  Dispose(BufStreamList); BufStreamList:=Nil;
end;
{$F-}

begin
  New(TempDirList); TempDirList^:='';
  WorkBufSize:=2048;
  VirtualStream:=Nil;
  New(AuxStreamList);
  for i:=1 to MaxAuxStream do AuxStreamList^[i]:=Nil;
  New(BufStreamList);
  for i:=1 to MaxBufStream do BufStreamList^[i]:=Nil;
  OldExitProc:=ExitProc;
  ExitProc:=@StreamExitProc;
end.
  
