/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.CharStream;
import de.tu_darmstadt.sp.util.BufferedRandomFileInputStream;
import java.io.IOException;

class PDFCharStream
implements CharStream {
    BufferedRandomFileInputStream input;
    long tokenBegin = -1L;
    private static char[] buffer = new char[128];

    public PDFCharStream(BufferedRandomFileInputStream in) {
        this.input = in;
    }

    public char BeginToken() throws IOException {
        this.tokenBegin = this.input.getFilePointer();
        return this.readChar();
    }

    public void Done() {
    }

    public String GetImage() {
        try {
            int len = (int)(this.input.getFilePointer() - this.tokenBegin);
            if (len > buffer.length) {
                buffer = new char[len + buffer.length];
            }
            this.input.seek(this.tokenBegin);
            int i = 0;
            while (i < len) {
                PDFCharStream.buffer[i] = this.readChar();
                ++i;
            }
            return new String(buffer, 0, len);
        }
        catch (IOException ioe) {
            throw new RuntimeException("readFully failed: " + ioe.getMessage());
        }
    }

    public char[] GetSuffix(int len) {
        try {
            char[] buffer = new char[len];
            this.input.seek(this.input.getFilePointer() - (long)len);
            int i = 0;
            while (i < len) {
                buffer[i] = this.readChar();
                ++i;
            }
            return buffer;
        }
        catch (IOException ioe) {
            throw new RuntimeException("readFully failed: " + ioe.getMessage());
        }
    }

    public void backup(int amount) {
        try {
            this.input.seek(this.input.getFilePointer() - (long)amount);
        }
        catch (IOException ioe) {
            throw new RuntimeException("backup failed: " + ioe.getMessage());
        }
    }

    public int getBeginColumn() {
        return (int)this.tokenBegin;
    }

    public int getBeginLine() {
        return 0;
    }

    public int getColumn() {
        return 0;
    }

    public int getEndColumn() {
        return (int)this.input.getFilePointer();
    }

    public int getEndLine() {
        return 0;
    }

    public final long getFilePointer() {
        return this.input.getFilePointer();
    }

    public int getLine() {
        return 0;
    }

    public char readChar() throws IOException {
        return (char)this.input.read();
    }

    public void readFully(byte[] buffer) throws IOException {
        int amount;
        int toRead = buffer.length;
        int offset = 0;
        while ((amount = this.input.read(buffer, offset, toRead)) != toRead) {
            offset += amount;
            toRead -= amount;
        }
    }

    public final void seek(long pos) throws IOException {
        this.input.seek(pos);
    }
}

