//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseBooleanArray;

public class Parseequation {
	
	public static volatile SparseArray<Float> thisypos = new SparseArray<Float>();
	public static volatile SparseBooleanArray error = new SparseBooleanArray();
	public static volatile SparseArray<String> errormessage = new SparseArray<String>();
    
    public void parseequation(Canvas canvas, Block block, Integer tid,  Integer containerwidth, Integer containerheight, Integer superblocknumber, SuperBlock superblock ,SparseArray<ArrayList<String>> superblockline,SparseIntArray superblocknumline,SparseIntArray superblockstartline, SparseIntArray superblockendline, ArrayList<Typeface> tf ,String columnspec, Float ypos, String attribute) {
 
    	int ii;
	    
	    float linegap = Header.linegap;    
		float adjusty=ypos;
		float shiftx=0;
		float columnwidth=0;
		
		String blockline = new String();	
		String rawblockline = new String();
		String thisattribute=attribute;
		
		    ArrayList<Float> lineheight = new ArrayList<Float>();
		    ArrayList<Float> linedepth = new ArrayList<Float>();
		    
		    error.put(tid,false);
		    errormessage.put(tid,"");
		    
            float blockwidth = 0.0f;
            float blockheight = 0.0f;
            float blockdepth = 0.0f;
            
    	  lineheight.clear();linedepth.clear();
         
            		  lineheight.add(0.0f);
            		  linedepth.add(0.0f);
            		  synchronized(this){superblock.create(tid);}
            		                       
                 String currentsuperblockline=superblockline.get(superblocknumber).get(0);
               
            			  rawblockline=currentsuperblockline;
            			  if (rawblockline.equals("")){rawblockline=" ";};
            			 
            		  Parsepreparation prepareblockline = new Parsepreparation();
    	              blockline=prepareblockline.parsepreparation(rawblockline,Symbol.symboltype,Symbol.matchsymbol);	  	                      
            		  Parseblock parseblockline = new Parseblock();
	            	  parseblockline.parseblock(tid,canvas,block, blockline,tf,thisattribute);	                  

                      if (Block.error.get(tid)==true){error.put(tid, true); errormessage.put(tid, Block.errormessage.get(tid)); }
                      columnwidth=Block.blockwidth2.get(tid);
                      blockwidth=Block.blockwidth2.get(tid);
                      blockheight=Block.blockheight2.get(tid)+linegap;
                      blockdepth=Block.blockdepth2.get(tid)+linegap;
                      
            	  
            	  adjusty=adjusty+blockheight-blockdepth;
            	  thisypos.put(tid, adjusty+blockdepth+linegap);
            	  for (ii=0;ii<=Block.subblock2.get(tid).size()-1;ii++){            			  
            		  Block.subblockypos2.get(tid).set(ii, Block.subblockypos2.get(tid).get(ii)+adjusty);           		  
                      }
            	             	  
            	  int viewportwidth=containerwidth-Header.leftsidemargin-Header.rightsidemargin;
            	  
            	  if (viewportwidth>columnwidth){shiftx=(viewportwidth-columnwidth)/2;}
            	  else {shiftx=0;};
            	              	  
            	  for (ii=0;ii<=Block.subblock2.get(tid).size()-1;ii++){           		           		            		  
            		  Block.subblockxpos2.get(tid).set(ii, Block.subblockxpos2.get(tid).get(ii)+shiftx+Header.leftsidemargin);           		             		  
            	  }
            	  synchronized(this){
                  superblock.add(tid,Block.subblock2,Block.subblockxpos2, Block.subblockypos2, Block.subblockattribute2, blockwidth, blockheight, blockdepth,'e',0);             
            	  }
}}
    
   
