/* wmdellin.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <string.h>
#include <sys/winmgr.h>
#include "winmgr2.h"

void wm_del_line (wm_handle wh, int y, int count)
{
  int i;
  char *p1, *p2;

  if (wh->used != WM_USED || count <= 0)
    return;
  if (count > wh->height)
    count = wh->height;
  for (i = y; i < wh->height-count; ++i)
    {
      p1 = &DATA (wh, wh->ax, i+wh->ay);
      p2 = p1 + 2 * count * wh->bwidth;
      memmove (p1, p2, (size_t)(2 * wh->width));
    }
  for (i = wh->height-count; i < wh->height; ++i)
    _wm_clrline1 (wh, i+wh->ay, wh->ax,
                  wh->width-1+wh->ax);
  if (wh->display)
    _wm_put1 (wh);
  else
    wh->update_req = TRUE;
  _wm_cursor1 ();
} 

