/* wminslin.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <string.h>
#include <sys/winmgr.h>
#include "winmgr2.h"

void wm_ins_line (wm_handle wh, int y, int count)
{
  int i;
  char *p1, *p2;

  if (wh->used != WM_USED || count <= 0)
    return;
  if (count > wh->height)
    count = wh->height;
  for (i = wh->height - count - 1; i >= y; --i)
    {
      p1 = &DATA (wh, wh->ax, i+wh->ay);
      p2 = p1 + 2 * count * wh->bwidth;
      memmove (p2, p1, (size_t)(2 * wh->width));
    }
  for (i = 0; i < count; ++i)
    _wm_clrline1 (wh, i+y+wh->ay, wh->ax,
                  wh->width-1+wh->ax);
  if (wh->display)
    _wm_put1 (wh);
  else
    wh->update_req = TRUE;
  _wm_cursor1 ();
}
