#include "config.h"

#include <stdlib.h>
#include <stdarg.h>
#include <ustr.h>

#include "lib/util.h"
#include "lib/confdata.h"
#include "lib/confparser.h"

void usage (FILE *f, const char * progn)
{
  fprintf (f, "Usage: %s <xmlfile>\n", progn);
}
int main (int argc, char * argv[])
{
  const char * xmlfile;
  run2_confdata_t   *data;

  run2_set_program_name (argv[0]);

  if (argc != 2)
  {
    fprintf(stderr, "Wrong number of arguments\n");
    usage (stderr, argv[0]);
    exit (1);
  }
  xmlfile = argv[1];

  /* propagate options to utils */
  run2_set_tty_mode(1);
  run2_set_gui_mode(0);
  run2_set_verbose_level (RUN2_DEFAULT_LOG_LEVEL);

  data = run2_xml_parse (xmlfile);
  if (data)
  {
    run2_confdata_print (stdout, 0, USTR1 (\xA, "Run2Config"), data);
    run2_confdata_delete (data);
    data = NULL;
  }
  return 0;
}

