/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.elk.FordiacLayoutData;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeNetworkViewerEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class FordiacLayoutMapping
extends LayoutMapping {
    private static final long serialVersionUID = 363049909751709783L;
    private final List<ConnectionEditPart> connections = new ArrayList<ConnectionEditPart>();
    private final Map<GraphicalEditPart, ElkGraphElement> reverseMapping = new HashMap<GraphicalEditPart, ElkGraphElement>();
    private final FordiacLayoutData layoutData = new FordiacLayoutData();
    private final AbstractFBNetworkEditPart ep;
    public LayoutType type;

    public FordiacLayoutMapping(IEditorPart part, AbstractFBNetworkEditPart ep) {
        super((IWorkbenchPart)part);
        this.ep = ep;
        this.type = FordiacLayoutMapping.getLayoutType(ep);
        ElkNode graph = ElkGraphUtil.createGraph();
        ElkNode parent = ElkGraphUtil.createGraph();
        graph.setParent(parent);
        Rectangle bounds = ep.getFigure().getBounds();
        graph.setDimensions(bounds.preciseWidth(), bounds.preciseHeight());
        graph.setLocation(bounds.preciseX(), bounds.preciseY());
        this.setLayoutGraph(graph);
        this.setParentElement(ep);
        this.getGraphMap().put((Object)graph, (Object)ep);
        this.reverseMapping.put((GraphicalEditPart)ep, (ElkGraphElement)graph);
    }

    private static LayoutType getLayoutType(AbstractFBNetworkEditPart ep) {
        if (ep instanceof UnfoldedSubappContentEditPart) {
            return LayoutType.Unfolded;
        }
        if (ep instanceof EditorWithInterfaceEditPart && !(ep instanceof CompositeNetworkViewerEditPart)) {
            return LayoutType.Typed;
        }
        return LayoutType.Application;
    }

    public GraphicalEditPart getParentElement() {
        return (GraphicalEditPart)super.getParentElement();
    }

    public List<ConnectionEditPart> getConnections() {
        return this.connections;
    }

    public Map<GraphicalEditPart, ElkGraphElement> getReverseMapping() {
        return this.reverseMapping;
    }

    public FordiacLayoutData getLayoutData() {
        return this.layoutData;
    }

    public AbstractFBNetworkEditPart getNetworkEditPart() {
        return this.ep;
    }

    public static enum LayoutType {
        Application,
        Unfolded,
        Typed;

    }
}

