/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.Objects;
import org.eclipse.fordiac.ide.gef.nat.AbstractColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VariableTableColumn;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.gef.commands.Command;

public class VariableColumnAccessor
extends AbstractColumnAccessor<Variable<?>, VariableTableColumn> {
    private static final String NULL_DEFAULT = "";

    public VariableColumnAccessor() {
        this(VariableTableColumn.DEFAULT_COLUMNS);
    }

    public VariableColumnAccessor(List<VariableTableColumn> columns) {
        super(null, columns);
    }

    @Override
    public Object getDataValue(Variable<?> rowObject, VariableTableColumn column) {
        return switch (column) {
            case VariableTableColumn.NAME -> rowObject.getName();
            case VariableTableColumn.TYPE -> {
                INamedElement var4_3 = rowObject.getType();
                if (var4_3 instanceof LibraryElement) {
                    LibraryElement libraryElement = (LibraryElement)var4_3;
                    yield PackageNameHelper.getFullTypeName((LibraryElement)libraryElement);
                }
                yield rowObject.getType().getName();
            }
            case VariableTableColumn.VALUE -> rowObject.toString();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
        };
    }

    @Override
    public void setDataValue(Variable<?> rowObject, int columnIndex, Object newValue) {
        switch ((VariableTableColumn)((Object)this.getColumns().get(columnIndex))) {
            case VALUE: {
                rowObject.setValue(Objects.toString(newValue, NULL_DEFAULT));
                break;
            }
            case NAME: 
            case TYPE: {
                throw new UnsupportedOperationException("Cannot set value for column: " + ((VariableTableColumn)((Object)this.getColumns().get(columnIndex))).getDisplayName());
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(this.getColumns().get(columnIndex)));
            }
        }
    }

    @Override
    public Command createCommand(Variable<?> rowObject, VariableTableColumn column, Object newValue) {
        throw new UnsupportedOperationException("Cannot create command for changing variable");
    }
}

