/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public abstract class AbstractStringValueConverter
implements ValueConverter<String> {
    static final Pattern STRING_ESCAPE_PATTERN = Pattern.compile("\\$([\\$'\"lLnNpPrRtT]|\\p{XDigit}{2})?");
    static final Pattern WSTRING_ESCAPE_PATTERN = Pattern.compile("\\$([\\$'\"lLnNpPrRtT]|\\p{XDigit}{4})?");
    static final Pattern SCANNER_STRING_QUOTE_PATTERN = Pattern.compile("\\G'");
    static final Pattern SCANNER_WSTRING_QUOTE_PATTERN = Pattern.compile("\\G\"");
    static final Pattern SCANNER_STRING_ESCAPE_PATTERN = Pattern.compile("\\G" + String.valueOf(STRING_ESCAPE_PATTERN));
    static final Pattern SCANNER_WSTRING_ESCAPE_PATTERN = Pattern.compile("\\G" + String.valueOf(WSTRING_ESCAPE_PATTERN));
    static final Pattern SCANNER_STRING_NON_ESCAPE_PATTERN = Pattern.compile("[^$']++");
    static final Pattern SCANNER_WSTRING_NON_ESCAPE_PATTERN = Pattern.compile("[^$\"]++");

    @Override
    public String toValue(String string) throws IllegalArgumentException {
        if (string.length() < 2) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
        }
        char quote = string.charAt(0);
        if (quote != '\'' && quote != '\"') {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
        }
        if (quote != string.charAt(string.length() - 1)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_UnevenlyQuotedStringLiteral, string));
        }
        boolean wide = quote == '\"';
        String unquoted = string.substring(1, string.length() - 1);
        Pattern pattern = wide ? WSTRING_ESCAPE_PATTERN : STRING_ESCAPE_PATTERN;
        return pattern.matcher(unquoted).replaceAll(AbstractStringValueConverter::unescapeReplace);
    }

    @Override
    public String toValue(Scanner scanner) throws IllegalArgumentException {
        if (scanner.findWithinHorizon(SCANNER_STRING_QUOTE_PATTERN, 0) != null) {
            return AbstractStringValueConverter.toValue(scanner, SCANNER_STRING_QUOTE_PATTERN, SCANNER_STRING_ESCAPE_PATTERN, SCANNER_STRING_NON_ESCAPE_PATTERN);
        }
        if (scanner.findWithinHorizon(SCANNER_WSTRING_QUOTE_PATTERN, 0) != null) {
            return AbstractStringValueConverter.toValue(scanner, SCANNER_WSTRING_QUOTE_PATTERN, SCANNER_WSTRING_ESCAPE_PATTERN, SCANNER_WSTRING_NON_ESCAPE_PATTERN);
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, "<scanner>"));
    }

    protected static String toValue(Scanner scanner, Pattern quotePattern, Pattern escapePattern, Pattern nonEscapePattern) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder();
        while (scanner.findWithinHorizon(quotePattern, 0) == null) {
            if (scanner.findWithinHorizon(escapePattern, 0) != null) {
                result.append(AbstractStringValueConverter.unescape(scanner.match()));
                continue;
            }
            if (scanner.findWithinHorizon(nonEscapePattern, 0) != null) {
                result.append(scanner.match().group());
                continue;
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, "<scanner>"));
        }
        return result.toString();
    }

    protected static String unescapeReplace(MatchResult result) {
        String replacement = AbstractStringValueConverter.unescape(result);
        if ("$".equals(replacement)) {
            return "\\$";
        }
        return replacement;
    }

    protected static String unescape(MatchResult result) {
        String escape = result.group(1);
        if (escape == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalEscapeInStringLiteral, escape));
        }
        switch (escape.charAt(0)) {
            case '$': {
                return "$";
            }
            case '\'': {
                return "'";
            }
            case 'L': 
            case 'N': 
            case 'l': 
            case 'n': {
                return "\n";
            }
            case 'P': 
            case 'p': {
                return "\f";
            }
            case 'R': 
            case 'r': {
                return "\r";
            }
            case 'T': 
            case 't': {
                return "\t";
            }
            case '\"': {
                return "\"";
            }
        }
        try {
            return String.valueOf((char)Integer.parseInt(escape, 16));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalEscapeInStringLiteral, escape), e);
        }
    }

    public static String toString(String value, boolean wide) {
        int length = value.length();
        StringBuilder result = new StringBuilder(length + 2);
        if (wide) {
            result.append('\"');
        } else {
            result.append('\'');
        }
        int i = 0;
        while (i < length) {
            AbstractStringValueConverter.escape(value.charAt(i), wide, result);
            ++i;
        }
        if (wide) {
            result.append('\"');
        } else {
            result.append('\'');
        }
        return result.toString();
    }

    protected static void escape(char value, boolean wide, StringBuilder result) {
        switch (value) {
            case '$': {
                result.append("$$");
                break;
            }
            case '\'': {
                if (wide) {
                    result.append(value);
                    break;
                }
                result.append("$'");
                break;
            }
            case '\n': {
                result.append("$N");
                break;
            }
            case '\f': {
                result.append("$P");
                break;
            }
            case '\r': {
                result.append("$R");
                break;
            }
            case '\t': {
                result.append("$T");
                break;
            }
            case '\"': {
                if (!wide) {
                    result.append(value);
                    break;
                }
                result.append("$\"");
                break;
            }
            default: {
                byte[] bytes;
                if (value >= ' ' && value <= '~') {
                    result.append(value);
                    break;
                }
                if (wide) {
                    result.append(String.format("$%04X", value));
                    break;
                }
                byte[] byArray = bytes = String.valueOf(value).getBytes(StandardCharsets.UTF_8);
                int n = bytes.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    result.append(String.format("$%02X", b));
                    ++n2;
                }
                break block0;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

