/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.MergeActionHandler;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String refName;
        List<Ref> nodes;
        ObjectId commitId = this.getSelectedCommitId(event);
        Repository repository = this.getRepository(event);
        if (repository == null) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        if (!MergeActionHandler.checkMergeIsPossible(repository, shell) || LaunchFinder.shouldCancelBecauseOfRunningLaunches(repository, null)) {
            return null;
        }
        try {
            nodes = this.getBranchesOfCommit(this.getSelection(event), repository, true);
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.AbstractHistoryCommitHandler_cantGetBranches, (Throwable)e);
        }
        if (nodes.isEmpty()) {
            refName = commitId.getName();
        } else if (nodes.size() == 1) {
            refName = nodes.get(0).getName();
        } else {
            BranchSelectionDialog<Ref> dlg = new BranchSelectionDialog<Ref>(shell, nodes, UIText.MergeHandler_MergeBranchDialogTitle, UIText.MergeHandler_MergeBranchDialogMessage, UIText.MergeHandler_MergeBranchDialogButton, 4);
            if (dlg.open() == 0) {
                refName = dlg.getSelectedNode().getName();
            } else {
                return null;
            }
        }
        MergeOperation op = new MergeOperation(repository, refName);
        MergeActionHandler.doMerge(repository, op, refName);
        return null;
    }

    public boolean isEnabled() {
        Repository repository = this.getRepository(this.getPage());
        return repository != null && repository.getRepositoryState().equals((Object)RepositoryState.SAFE);
    }
}

