/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.CopyPasteMessage;
import org.eclipse.fordiac.ide.application.commands.AddElementsToSubAppCommand;
import org.eclipse.fordiac.ide.application.commands.CutAndPasteFromSubAppCommand;
import org.eclipse.fordiac.ide.application.commands.PasteCommand;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkRootEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UISubAppNetworkEditPart;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteEditPartsAction
extends SelectionAction {
    private org.eclipse.swt.graphics.Point pasteRefPosition;

    public PasteEditPartsAction(IWorkbenchPart editor) {
        super(editor);
    }

    protected boolean calculateEnabled() {
        FBNetwork fbNetwork = this.getFBNetwork();
        return fbNetwork != null && !PasteEditPartsAction.getClipboardContents().isEmpty();
    }

    protected Command createPasteCommand() {
        FBNetwork fbNetwork = this.getFBNetwork();
        if (fbNetwork != null) {
            return new PasteCommand(PasteEditPartsAction.getClipboardContents(), fbNetwork, this.pasteRefPosition);
        }
        return new CompoundCommand();
    }

    private static List<? extends Object> getClipboardContents() {
        Object obj = Clipboard.getDefault().getContents();
        if (obj instanceof CopyPasteMessage) {
            CopyPasteMessage copyPasteMessage = (CopyPasteMessage)obj;
            return copyPasteMessage.getData();
        }
        return Collections.emptyList();
    }

    protected void init() {
        this.setId(ActionFactory.PASTE.getId());
        this.setText(Messages.PasteEditPartsAction_Text);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof FigureCanvas) {
            this.setMouseLocationAsPastePos(event);
        }
        super.runWithEvent(event);
    }

    public void setMouseLocationAsPastePos(Event event) {
        FigureCanvas figureCanvas = (FigureCanvas)event.widget;
        Point viewLocation = figureCanvas.getViewport().getViewLocation();
        org.eclipse.swt.graphics.Point mouseLocation = Display.getCurrent().getCursorLocation();
        mouseLocation = figureCanvas.toControl(mouseLocation.x, mouseLocation.y);
        if (figureCanvas.getBounds().contains(mouseLocation.x, mouseLocation.y)) {
            ZoomManager zoomManager = ((FBNetworkEditor)this.getWorkbenchPart()).getZoomManger();
            mouseLocation.x += viewLocation.x;
            mouseLocation.y += viewLocation.y;
            this.setPastRefPosition(new Point(mouseLocation.x, mouseLocation.y).scale(1.0 / zoomManager.getZoom()));
        } else {
            Dimension visibleArea = figureCanvas.getViewport().getSize();
            this.setPastRefPosition(new org.eclipse.swt.graphics.Point(viewLocation.x + visibleArea.width / 2, viewLocation.y + visibleArea.height / 2));
        }
    }

    public void run() {
        Clipboard clipboard = Clipboard.getDefault();
        if (clipboard.getContents() instanceof CopyPasteMessage) {
            CopyPasteMessage copyPasteMessage = (CopyPasteMessage)Clipboard.getDefault().getContents();
            if (this.pasteRefPosition != null && copyPasteMessage.getCutAndPasteFromSubAppCommandos() != null) {
                copyPasteMessage.getCutAndPasteFromSubAppCommandos().setPastePos(this.pasteRefPosition);
            }
            if (copyPasteMessage.getCopyStatus() == CopyPasteMessage.CopyStatus.CUT_PASTED || copyPasteMessage.getCopyStatus() == CopyPasteMessage.CopyStatus.COPY) {
                this.execute(this.createPasteCommand());
            } else if (this.isCutFromSubappToParent(copyPasteMessage)) {
                this.handleCutFromSubappToParent(copyPasteMessage);
            } else if (this.isCutFromRootToSubapp(copyPasteMessage)) {
                this.handleCutFromRootToSubapp(copyPasteMessage);
            } else if (this.isCutFromSubappToChildSubapp(copyPasteMessage)) {
                this.handleCutFromSubappToChildSubapp(copyPasteMessage);
            } else {
                this.handleCutFromSubappToAnywhere(copyPasteMessage);
            }
        }
        this.pasteRefPosition = null;
    }

    public void handleCutFromSubappToAnywhere(CopyPasteMessage copyPasteMessage) {
        Command createPasteCommand;
        if (copyPasteMessage.getCopyStatus() == CopyPasteMessage.CopyStatus.CUT_FROM_SUBAPP) {
            copyPasteMessage.getCutAndPasteFromSubAppCommandos().undo();
            this.execute((Command)copyPasteMessage.getDeleteCommandos());
        }
        if ((createPasteCommand = this.createPasteCommand()) instanceof PasteCommand && copyPasteMessage.getCutAndPasteFromSubAppCommandos() != null) {
            ((PasteCommand)createPasteCommand).setCutPasteCmd(copyPasteMessage.getCutAndPasteFromSubAppCommandos());
        }
        this.execute(createPasteCommand);
    }

    protected void execute(Command command) {
        CopyPasteMessage copyPasteMessage;
        if (command.canExecute() && (copyPasteMessage = (CopyPasteMessage)Clipboard.getDefault().getContents()).getCopyStatus() == CopyPasteMessage.CopyStatus.CUT_FROM_ROOT) {
            copyPasteMessage.setCopyInfo(CopyPasteMessage.CopyStatus.CUT_PASTED);
        }
        super.execute(command);
    }

    private void handleCutFromSubappToChildSubapp(CopyPasteMessage copyPasteMessage) {
        Object selection = this.getSelectedObjects().get(0);
        SubApp targetSubapp = PasteEditPartsAction.getSubapp(selection);
        copyPasteMessage.getCutAndPasteFromSubAppCommandos().undo();
        this.execute(new AddElementsToSubAppCommand(targetSubapp, copyPasteMessage.getData()));
    }

    private boolean isCutFromSubappToChildSubapp(CopyPasteMessage copyPasteMessage) {
        if (!this.isSelectionSubapp()) {
            return false;
        }
        SubApp targetSubapp = PasteEditPartsAction.getSubapp(this.getSelectedObjects().get(0));
        List<FBNetworkElement> elements = copyPasteMessage.getCutAndPasteFromSubAppCommandos().getElements();
        if (copyPasteMessage.getCopyStatus() == CopyPasteMessage.CopyStatus.CUT_FROM_SUBAPP) {
            copyPasteMessage.getCutAndPasteFromSubAppCommandos().undo();
            if (!FBNetworkHelper.targetSubappIsInSameFbNetwork(elements, (SubApp)targetSubapp)) {
                copyPasteMessage.getCutAndPasteFromSubAppCommandos().redo();
                return false;
            }
            copyPasteMessage.getCutAndPasteFromSubAppCommandos().redo();
        }
        return copyPasteMessage.getCopyStatus() == CopyPasteMessage.CopyStatus.CUT_FROM_SUBAPP;
    }

    private void handleCutFromRootToSubapp(CopyPasteMessage copyPasteMessage) {
        Object selection = this.getSelectedObjects().get(0);
        SubApp targetSubapp = PasteEditPartsAction.getSubapp(selection);
        copyPasteMessage.getDeleteCommandos().undo();
        this.execute(new AddElementsToSubAppCommand(targetSubapp, copyPasteMessage.getData()));
    }

    protected static SubApp getSubapp(Object object) {
        SubApp targetSubapp = null;
        targetSubapp = object instanceof UISubAppNetworkEditPart ? ((UISubAppNetworkEditPart)((Object)object)).getSubApp() : ((SubAppForFBNetworkEditPart)((Object)object)).getModel();
        return targetSubapp;
    }

    private boolean isCutFromRootToSubapp(CopyPasteMessage copyPasteMessage) {
        if (!this.isSelectionSubapp()) {
            return false;
        }
        return copyPasteMessage.getCopyStatus() == CopyPasteMessage.CopyStatus.CUT_FROM_ROOT;
    }

    protected boolean isSelectionSubapp() {
        return this.getSelectedObjects().get(0) instanceof SubAppForFBNetworkEditPart || this.getSelectedObjects().get(0) instanceof UISubAppNetworkEditPart;
    }

    protected boolean isCutFromSubappToParent(CopyPasteMessage copyPasteMessage) {
        FBNetworkEditPart networkEdit;
        if (copyPasteMessage.getCopyStatus() != CopyPasteMessage.CopyStatus.CUT_FROM_SUBAPP) {
            return false;
        }
        List selectedObjects = this.getSelectedObjects();
        if (selectedObjects.size() > 1) {
            return false;
        }
        CutAndPasteFromSubAppCommand cutAndPasteFromSubAppCommand = copyPasteMessage.getCutAndPasteFromSubAppCommandos();
        SubApp sourceSubApp = cutAndPasteFromSubAppCommand.getSourceSubApp();
        if (selectedObjects.get(0) instanceof FBNetworkEditPart && (networkEdit = (FBNetworkEditPart)((Object)selectedObjects.get(0))).getParent() instanceof FBNetworkRootEditPart && sourceSubApp.eContainer().equals(networkEdit.getModel())) {
            return true;
        }
        if (!this.isSelectionSubapp()) {
            return false;
        }
        FBNetworkElement outerFBNetworkElement = sourceSubApp.getOuterFBNetworkElement();
        if (outerFBNetworkElement == null) {
            return false;
        }
        SubApp selectedSubapp = PasteEditPartsAction.getSubapp(selectedObjects.get(0));
        if (!outerFBNetworkElement.equals(selectedSubapp)) {
            return false;
        }
        return copyPasteMessage.isCutFromSubApp();
    }

    protected void handleCutFromSubappToParent(CopyPasteMessage copyPasteMessage) {
        this.execute(copyPasteMessage.getCutAndPasteFromSubAppCommandos());
        Clipboard.getDefault().setContents(new Object());
    }

    protected FBNetwork getFBNetwork() {
        if (this.getWorkbenchPart() instanceof IEditorPart) {
            return (FBNetwork)this.getWorkbenchPart().getAdapter(FBNetwork.class);
        }
        return null;
    }

    public void setPastRefPosition(org.eclipse.swt.graphics.Point pt) {
        this.pasteRefPosition = pt;
    }

    public void setPastRefPosition(Point point) {
        this.setPastRefPosition(new org.eclipse.swt.graphics.Point(point.x, point.y));
    }
}

