/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.FlattenSubAppCommand;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UISubAppNetworkEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class FlattenSubApplication
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        CompoundCommand mainCmd = FlattenSubApplication.checkSelection(event, editor);
        if (!mainCmd.isEmpty()) {
            ((CommandStack)editor.getAdapter(CommandStack.class)).execute((Command)mainCmd);
        }
        return Status.OK_STATUS;
    }

    private static CompoundCommand checkSelection(ExecutionEvent event, IEditorPart editor) {
        CompoundCommand mainCmd = new CompoundCommand();
        for (Object currentElement : FlattenSubApplication.getSelectionList(event)) {
            SubApp subApp = FlattenSubApplication.getSubApp(currentElement);
            if (subApp == null) continue;
            FlattenSubApplication.checkCurrentEditor(subApp, editor);
            FlattenSubAppCommand cmd = new FlattenSubAppCommand(subApp);
            if (!cmd.canExecute()) continue;
            mainCmd.add((Command)cmd);
        }
        return mainCmd;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        SubApp subApp = FlattenSubApplication.getSelectedSubApp(selection);
        this.setBaseEnabled(HandlerHelper.isEditableSubApp((SubApp)subApp));
    }

    private static SubApp getSubApp(Object currentElement) {
        if (currentElement instanceof SubApp) {
            return (SubApp)currentElement;
        }
        if (currentElement instanceof SubAppForFBNetworkEditPart) {
            return ((SubAppForFBNetworkEditPart)((Object)currentElement)).getModel();
        }
        if (currentElement instanceof UISubAppNetworkEditPart) {
            return (SubApp)((UISubAppNetworkEditPart)((Object)currentElement)).getModel().eContainer();
        }
        return null;
    }

    private static SubApp getSelectedSubApp(Object selection) {
        IStructuredSelection structSel;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty() && structSel.size() == 1) {
            return FlattenSubApplication.getSubApp(structSel.getFirstElement());
        }
        return null;
    }

    private static List<Object> getSelectionList(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            return ((StructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    private static void checkCurrentEditor(SubApp subApp, IEditorPart editor) {
        if (((FBNetwork)editor.getAdapter(FBNetwork.class)).equals(subApp.getSubAppNetwork())) {
            HandlerHelper.openEditor((EObject)subApp.getFbNetwork().eContainer());
        }
    }
}

