/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.wizards.AbstractSaveAsWizard;
import org.eclipse.fordiac.ide.application.wizards.SaveAsWizardPage;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class SaveAsStructWizard
extends AbstractSaveAsWizard {
    private static final String SUBAPP_SECTION = "SUBAPP_SECTION";
    private final List<VarDeclaration> varDecl;
    private final IProject project;
    private String datatypeName;
    private boolean replaceSource;

    public SaveAsStructWizard(List<VarDeclaration> varDecl, IProject project, String windowTitle) {
        super(SUBAPP_SECTION);
        this.setWindowTitle(windowTitle);
        this.varDecl = varDecl;
        this.project = project;
    }

    @Override
    public boolean performFinish() {
        if (this.perform()) {
            IFile targetFile = this.getTargetTypeFile();
            PaletteEntry entry = this.createPaletteEntry(targetFile);
            StructuredType type = DataFactory.eINSTANCE.createStructuredType();
            entry.setType((LibraryElement)type);
            InterfaceListCopier.copyVarList((Collection)type.getMemberVariables(), this.varDecl);
            TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)type);
            this.datatypeName = TypeLibrary.getTypeNameFromFile((IFile)targetFile);
            type.setName(this.datatypeName);
            AbstractTypeExporter.saveType((PaletteEntry)entry);
            if (this.newFilePage.getOpenType()) {
                OpenStructMenu.openStructEditor((IFile)targetFile);
            }
            if (this.newFilePage.getReplaceSource()) {
                this.replaceSource = true;
            }
        }
        return true;
    }

    private PaletteEntry createPaletteEntry(IFile targetTypeFile) {
        return TypeLibrary.getTypeLibrary((IProject)this.project).createPaletteEntry(targetTypeFile);
    }

    public boolean replaceSource() {
        return this.replaceSource;
    }

    public String getDatatypeName() {
        return this.datatypeName;
    }

    public void addPages() {
        StructuredSelection selection = new StructuredSelection((Object)this.project);
        this.newFilePage = SaveAsWizardPage.createSaveAsStructWizardPage(Messages.SaveAsStructWizard_WizardPageName, (IStructuredSelection)selection);
        this.newFilePage.setFileName(this.varDecl.get(0).getName());
        this.addPage((IWizardPage)this.newFilePage);
    }

    @Override
    protected boolean askOverwrite() {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.ConvertToStructHandler_ErrorTitle, (String)Messages.ConvertToStructHandler_ErrorMessage);
    }

    @Override
    public IFile getTargetTypeFile() {
        Path path = new Path(this.newFilePage.getContainerFullPath() + File.separator + this.newFilePage.getFileName() + ".DTP");
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
    }
}

