/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.commands.CommandUtil;
import org.eclipse.fordiac.ide.application.wizards.AbstractSaveAsWizard;
import org.eclipse.fordiac.ide.application.wizards.SaveAsWizardPage;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.typemanagement.util.TypeFromTemplateCreator;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SaveAsSubappWizard
extends AbstractSaveAsWizard {
    private static final String SUBAPP_SECTION = "SUBAPP_SECTION";
    private final SubApp subApp;

    public SaveAsSubappWizard(SubApp subApp, String windowTitle) {
        super(SUBAPP_SECTION);
        this.setWindowTitle(windowTitle);
        this.subApp = subApp;
    }

    public void addPages() {
        IProject project = this.checkSubAppEditor();
        StructuredSelection selection = new StructuredSelection((Object)project);
        this.newFilePage = SaveAsWizardPage.createSaveAsSubAppWizardPage(Messages.SaveAsSubApplicationTypeAction_WizardPageName, (IStructuredSelection)selection);
        this.newFilePage.setFileName(this.subApp.getName());
        this.addPage((IWizardPage)this.newFilePage);
    }

    private IProject checkSubAppEditor() {
        IProject project = null;
        EObject obj = EcoreUtil.getRootContainer((EObject)this.subApp);
        project = obj instanceof SubAppType ? ((SubAppType)obj).getPaletteEntry().getFile().getProject() : this.getSystem().getSystemFile().getProject();
        return project;
    }

    private AutomationSystem getSystem() {
        return this.subApp.getSubAppNetwork().getAutomationSystem();
    }

    @Override
    public boolean performFinish() {
        if (this.perform()) {
            File template = SaveAsSubappWizard.getSubappTemplate();
            if (template == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.SaveAsSubApplicationTypeAction_TemplateMissingErrorTitle, (String)Messages.SaveAsSubApplicationTypeAction_TemplateMissingErrorMessage);
            } else {
                TypeFromTemplateCreator creator = new TypeFromTemplateCreator(this.getTargetTypeFile(), template){

                    protected void performTypeSpecificSetup(LibraryElement type) {
                        SaveAsSubappWizard.this.performTypeSetup((SubAppType)type);
                    }
                };
                PaletteEntry entry = creator.createTypeFromTemplate();
                if (entry != null) {
                    if (this.newFilePage.getReplaceSource()) {
                        this.replaceWithType(entry);
                    }
                    if (this.newFilePage.getOpenType()) {
                        SaveAsSubappWizard.openTypeEditor(entry);
                    }
                }
            }
        }
        return true;
    }

    private static File getSubappTemplate() {
        File[] fileList = SaveAsSubappWizard.getFilesFromTemplateFolder();
        if (fileList != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName().toUpperCase();
                if (fileName.endsWith("SUB")) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    private static File[] getFilesFromTemplateFolder() {
        String templateFolderPath = Platform.getInstallLocation().getURL().getFile();
        File templateFolder = new File(String.valueOf(templateFolderPath) + File.separatorChar + "template");
        return templateFolder.listFiles();
    }

    private static void openTypeEditor(PaletteEntry entry) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
        EditorUtils.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), (String)desc.getId());
    }

    private void replaceWithType(PaletteEntry entry) {
        CommandUtil.closeOpenedSubApp(this.subApp.getSubAppNetwork());
        CommandStack commandStack = (CommandStack)EditorUtils.getCurrentActiveEditor().getAdapter(CommandStack.class);
        commandStack.execute((Command)new UpdateFBTypeCommand((FBNetworkElement)this.subApp, entry));
    }

    private void performTypeSetup(SubAppType type) {
        this.performInterfaceSetup(type);
        type.setFBNetwork(FBNetworkHelper.copyFBNetWork((FBNetwork)this.subApp.getSubAppNetwork(), (InterfaceList)type.getInterfaceList()));
    }

    private void performInterfaceSetup(SubAppType type) {
        InterfaceList interfaceList = (InterfaceList)EcoreUtil.copy((EObject)this.subApp.getInterface());
        type.setInterfaceList(interfaceList);
    }

    @Override
    protected boolean askOverwrite() {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideTitle, (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideMessage);
    }

    @Override
    public IFile getTargetTypeFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.newFilePage.getContainerFullPath() + File.separator + this.newFilePage.getFileName() + ".SUB"));
    }
}

