/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class SaveAsWizardPage
extends WizardNewFileCreationPage {
    private static final String STORE_OPEN_TYPE_ID = "SUBAPP_SECTION.STORE_OPEN_TYPE_ID";
    private static final String STORE_REPLACE_SOURCE_ID = "SUBAPP_SECTION.STORE_REPLACE_SOURCE_ID";
    private boolean openType = true;
    private Composite advancedComposite;
    private int advancedCompositeHeight = -1;
    private Button replaceSourceSubapp;
    private final String fileLabel;
    private final String checkBoxText;
    private final String replaceSourceText;

    private SaveAsWizardPage(String pageName, IStructuredSelection selection, String title, String description, String fileLabel, String checkBoxText, String replaceSourceText) {
        super(pageName, selection);
        this.setTitle(title);
        this.setDescription(description);
        this.setAllowExistingResources(true);
        this.fileLabel = fileLabel;
        this.checkBoxText = checkBoxText;
        this.replaceSourceText = replaceSourceText;
    }

    public boolean getOpenType() {
        return this.openType;
    }

    public boolean getReplaceSource() {
        return this.replaceSourceSubapp.getSelection();
    }

    protected String getNewFileLabel() {
        return this.fileLabel;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.restoreWidgetValues();
    }

    protected void createAdvancedControls(Composite parent) {
        this.createReplaceSourceEntry(parent);
        super.createAdvancedControls(parent);
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_OPEN_TYPE_ID, this.openType);
            settings.put(STORE_REPLACE_SOURCE_ID, this.replaceSourceSubapp.getSelection());
        }
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.openType = settings.getBoolean(STORE_OPEN_TYPE_ID);
            this.replaceSourceSubapp.setSelection(settings.getBoolean(STORE_REPLACE_SOURCE_ID));
        }
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.advancedComposite != null) {
            this.advancedComposite.dispose();
            this.advancedComposite = null;
            shell.setSize(shellSize.x, shellSize.y - this.advancedCompositeHeight);
        } else {
            this.advancedComposite = this.createAdvancedGroup(composite);
            if (-1 == this.advancedCompositeHeight) {
                Point groupSize = this.advancedComposite.computeSize(-1, -1, true);
                this.advancedCompositeHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.advancedCompositeHeight);
        }
        super.handleAdvancedButtonSelect();
    }

    private void createReplaceSourceEntry(Composite parent) {
        this.replaceSourceSubapp = new Button(parent, 32);
        this.replaceSourceSubapp.setText(this.replaceSourceText);
    }

    private Composite createAdvancedGroup(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite groupComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        groupComposite.setLayout((Layout)layout);
        groupComposite.setLayoutData((Object)new GridData(784));
        groupComposite.setFont(font);
        Button openTypeCheckbox = new Button(groupComposite, 32);
        openTypeCheckbox.setText(this.checkBoxText);
        openTypeCheckbox.setSelection(this.openType);
        openTypeCheckbox.addListener(13, ev -> {
            boolean bl = this.openType = openTypeCheckbox.getSelection();
        });
        return groupComposite;
    }

    public static SaveAsWizardPage createSaveAsStructWizardPage(String pageName, IStructuredSelection selection) {
        return new SaveAsWizardPage(pageName, selection, Messages.SaveAsStructWizardPage_WizardPageTitle, Messages.SaveAsStructWizardPage_WizardPageDescription, Messages.SaveAsStructWizardPage_TypeName, Messages.SaveAsSubApplicationTypeAction_WizardPageOpenType, Messages.SaveAsStructWizardPage_ConvertSourceElements);
    }

    public static SaveAsWizardPage createSaveAsSubAppWizardPage(String pageName, IStructuredSelection selection) {
        return new SaveAsWizardPage(pageName, selection, Messages.SaveAsSubApplicationTypeAction_WizardPageTitle, Messages.SaveAsSubApplicationTypeAction_WizardPageDescription, Messages.SaveAsSubApplicationTypeAction_WizardPageNameLabel, Messages.SaveAsSubApplicationTypeAction_WizardPageOpenType, Messages.SaveAsSubappHandler_ReplaceDialogText);
    }
}

