/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.fordiac.ide.deployment.Activator;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractFileManagementHandler
implements IDeviceManagementCommunicationHandler {
    private StringBuilder stringBuffer = new StringBuilder();
    private String origMgrID;

    protected StringBuilder getStringBuffer() {
        return this.stringBuffer;
    }

    protected void clearStringBuffer() {
        this.stringBuffer = new StringBuilder();
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void connect(String address) throws DeploymentException {
        this.origMgrID = address;
    }

    @Override
    public void disconnect() throws DeploymentException {
    }

    @Override
    public String sendREQ(String destination, String request) throws IOException {
        if (request.contains("Action=\"QUERY\"")) {
            return "<Response ID=\"0\"/>";
        }
        this.stringBuffer.append(String.valueOf(destination) + ";" + request + "\n");
        return "";
    }

    @Override
    public String getInfo(String destination) {
        String info = this.origMgrID;
        if (!destination.equals("")) {
            info = String.valueOf(info) + ": " + destination;
        }
        return info;
    }

    protected boolean writeToBootFile(String fileName, boolean overwriteWithouAsking, Shell shell) {
        return AbstractFileManagementHandler.writeToAnyFile(fileName, this.stringBuffer.toString(), overwriteWithouAsking, shell);
    }

    protected static boolean writeToAnyFile(String fileName, String toWrite, boolean overwriteWithouAsking, Shell shell) {
        boolean returnValue = false;
        File bootFile = AbstractFileManagementHandler.createOrOverwriteFile(fileName, overwriteWithouAsking, shell);
        if (bootFile != null) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (OutputStreamWriter boot = new OutputStreamWriter((OutputStream)new FileOutputStream(bootFile), StandardCharsets.UTF_8);){
                    boot.write(toWrite);
                    ((Writer)boot).flush();
                    returnValue = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                IDeviceManagementCommunicationHandler.showErrorMessage(MessageFormat.format(Messages.AbstractFileManagementHandler_CouldNotWriteFile, fileName, e.getMessage()), shell);
            }
        }
        return returnValue;
    }

    private static File createOrOverwriteFile(String fileName, boolean overwriteWithouAsking, Shell shell) {
        File bootFile = new File(fileName);
        int res = 64;
        if (bootFile.exists()) {
            if (!overwriteWithouAsking) {
                MessageBox msgBox = new MessageBox(shell, 196);
                String msg = MessageFormat.format(Messages.AbstractFileManagementHandler_FileExists, bootFile.getAbsolutePath());
                msgBox.setMessage(msg);
                res = msgBox.open();
            }
        } else {
            try {
                if (!bootFile.createNewFile()) {
                    IDeviceManagementCommunicationHandler.showErrorMessage(Messages.AbstractFileManagementHandler_CouldnotCreateFile, shell);
                    res = 128;
                }
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                IDeviceManagementCommunicationHandler.showErrorMessage(MessageFormat.format(Messages.AbstractFileManagementHandler_CouldnotCreateFileWithError, e.getMessage()), shell);
            }
        }
        return res == 64 ? bootFile : null;
    }
}

