/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.elk.FordiacLayoutFactory;
import org.eclipse.fordiac.ide.elk.commands.LayoutCommand;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.IWorkbenchPart;

public class FordiacLayoutConnector
implements IDiagramLayoutConnector {
    private static final IProperty<AbstractFBNetworkEditPart> NETWORK_EDIT_PART = new Property("gef.networkEditPart");
    private static final IProperty<CommandStack> COMMAND_STACK = new Property("gef.commandStack");
    private static final IProperty<List<ConnectionEditPart>> CONNECTIONS = new Property("gef.connections");
    private static final IProperty<Map<GraphicalEditPart, ElkGraphElement>> REVERSE_MAPPING = new Property("gef.reverseMapping");
    private static final PrecisionPoint START_POINT = new PrecisionPoint();
    private static final PrecisionPoint END_POINT = new PrecisionPoint();
    private final Map<FBNetworkElement, Position> positions = new HashMap<FBNetworkElement, Position>();
    private final Map<Connection, PointList> connPoints = new HashMap<Connection, PointList>();

    private void clear() {
        this.positions.clear();
        this.connPoints.clear();
    }

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        LayoutMapping mapping = FordiacLayoutConnector.initMapping(workbenchPart);
        FordiacLayoutConnector.findRootEditPart(mapping, workbenchPart);
        if (mapping.getProperty(NETWORK_EDIT_PART) != null) {
            FordiacLayoutConnector.createGraphRoot(mapping);
            FordiacLayoutConnector.buildGraphRecursively(mapping, mapping.getLayoutGraph(), (GraphicalEditPart)mapping.getParentElement());
            FordiacLayoutConnector.processConnections(mapping);
        }
        return mapping;
    }

    private static LayoutMapping initMapping(IWorkbenchPart workbenchPart) {
        LayoutMapping mapping = new LayoutMapping(workbenchPart);
        mapping.setProperty(COMMAND_STACK, (Object)((CommandStack)workbenchPart.getAdapter(CommandStack.class)));
        mapping.setProperty(CONNECTIONS, new ArrayList());
        mapping.setProperty(REVERSE_MAPPING, new HashMap());
        return mapping;
    }

    private static void findRootEditPart(LayoutMapping mapping, IWorkbenchPart workbenchPart) {
        Map editPartSet = ((GraphicalViewer)workbenchPart.getAdapter(GraphicalViewer.class)).getEditPartRegistry();
        for (Object ep : editPartSet.values()) {
            if (!(ep instanceof AbstractFBNetworkEditPart) || ep instanceof UnfoldedSubappContentEditPart) continue;
            mapping.setProperty(NETWORK_EDIT_PART, (Object)((AbstractFBNetworkEditPart)ep));
            break;
        }
    }

    private static void createGraphRoot(LayoutMapping mapping) {
        AbstractFBNetworkEditPart networkEditPart = (AbstractFBNetworkEditPart)mapping.getProperty(NETWORK_EDIT_PART);
        ElkNode graph = FordiacLayoutFactory.createFordiacLayoutGraph();
        FordiacLayoutConnector.setGraphBounds(graph, networkEditPart);
        mapping.setLayoutGraph(graph);
        mapping.setParentElement((Object)networkEditPart);
        mapping.getGraphMap().put((Object)graph, (Object)networkEditPart);
        ((Map)mapping.getProperty(REVERSE_MAPPING)).put(networkEditPart, graph);
    }

    private static void setGraphBounds(ElkNode graph, AbstractFBNetworkEditPart networkEditPart) {
        Rectangle bounds = null;
        if (networkEditPart instanceof EditorWithInterfaceEditPart) {
            Object figure = ((IFigure)networkEditPart.getFigure().getChildren().get(0)).getChildren().stream().filter(FreeformLayer.class::isInstance).findFirst().orElse(null);
            if (figure instanceof IFigure) {
                bounds = ((IFigure)figure).getBounds();
            }
        } else {
            bounds = networkEditPart.getFigure().getBounds();
        }
        if (bounds != null) {
            graph.setLocation(bounds.preciseX(), bounds.preciseY());
            graph.setDimensions(bounds.preciseWidth(), bounds.preciseHeight());
        }
    }

    private static void buildGraphRecursively(LayoutMapping mapping, ElkNode parentLayoutNode, GraphicalEditPart currentEditPart) {
        currentEditPart.getChildren().forEach(child -> {
            if (child instanceof AbstractFBNElementEditPart) {
                AbstractFBNElementEditPart childEditPart = (AbstractFBNElementEditPart)child;
                ElkNode node = FordiacLayoutConnector.createNode(mapping, childEditPart, parentLayoutNode);
                FordiacLayoutConnector.buildGraphRecursively(mapping, node, (GraphicalEditPart)childEditPart);
            }
            if (child instanceof InterfaceEditPart) {
                InterfaceEditPart ep = (InterfaceEditPart)child;
                if (ep.isInput()) {
                    ep.getTargetConnections().forEach(conn -> FordiacLayoutConnector.saveConnection(mapping, conn));
                } else {
                    ep.getSourceConnections().forEach(conn -> FordiacLayoutConnector.saveConnection(mapping, conn));
                }
                if (ep.getParent() instanceof EditorWithInterfaceEditPart) {
                    FordiacLayoutConnector.getPort(new Point(0, 0), ep, mapping);
                }
            }
            if (child instanceof ValueEditPart) {
                FordiacLayoutConnector.createValueLabels(mapping, (ValueEditPart)child);
            }
        });
    }

    private static void saveConnection(LayoutMapping mapping, Object conn) {
        if (conn instanceof ConnectionEditPart && !((List)mapping.getProperty(CONNECTIONS)).contains(conn)) {
            ((List)mapping.getProperty(CONNECTIONS)).add((ConnectionEditPart)conn);
        }
    }

    private static ElkNode createNode(LayoutMapping mapping, AbstractFBNElementEditPart editPart, ElkNode parent) {
        ElkNode node = FordiacLayoutFactory.createFordiacLayoutNode(editPart, parent);
        Rectangle bounds = editPart.getFigure().getFBBounds();
        node.setLocation((double)bounds.x, (double)bounds.y);
        node.setDimensions(bounds.preciseWidth(), bounds.preciseHeight());
        ElkLabel label = ElkGraphUtil.createLabel((String)editPart.getModel().getName(), (ElkGraphElement)node);
        Rectangle labelBounds = editPart.getFigure().getLabelBounds();
        label.setDimensions((double)labelBounds.width(), (double)labelBounds.height());
        mapping.getGraphMap().put((Object)node, (Object)editPart);
        ((Map)mapping.getProperty(REVERSE_MAPPING)).put(editPart, node);
        return node;
    }

    private static void processConnections(LayoutMapping mapping) {
        for (ConnectionEditPart conn : (List)mapping.getProperty(CONNECTIONS)) {
            PolylineConnection connFig = conn.getFigure();
            START_POINT.setLocation(connFig.getSourceAnchor().getLocation(connFig.getSourceAnchor().getReferencePoint()));
            END_POINT.setLocation(connFig.getTargetAnchor().getLocation(connFig.getTargetAnchor().getReferencePoint()));
            connFig.translateToRelative((Translatable)START_POINT);
            connFig.translateToRelative((Translatable)END_POINT);
            ElkPort sourcePort = FordiacLayoutConnector.getPort((Point)START_POINT, (InterfaceEditPart)conn.getSource(), mapping);
            ElkPort destinationPort = FordiacLayoutConnector.getPort((Point)END_POINT, (InterfaceEditPart)conn.getTarget(), mapping);
            ElkEdge edge = FordiacLayoutFactory.createFordiacLayoutEdge(conn, mapping.getLayoutGraph(), (ElkConnectableShape)sourcePort, (ElkConnectableShape)destinationPort);
            mapping.getGraphMap().put((Object)edge, (Object)conn);
            ((Map)mapping.getProperty(REVERSE_MAPPING)).put(conn, edge);
        }
    }

    private static ElkPort getPort(Point point, InterfaceEditPart interfaceEditPart, LayoutMapping mapping) {
        return (ElkPort)((Map)mapping.getProperty(REVERSE_MAPPING)).computeIfAbsent(interfaceEditPart, ie -> FordiacLayoutConnector.createPort(point, interfaceEditPart, mapping));
    }

    private static ElkPort createPort(Point point, InterfaceEditPart interfaceEditPart, LayoutMapping mapping) {
        EditPart parent = interfaceEditPart.getParent();
        ElkNode parentNode = (ElkNode)((Map)mapping.getProperty(REVERSE_MAPPING)).get(parent);
        ElkPort port = FordiacLayoutFactory.createFordiacLayoutPort(interfaceEditPart, parentNode, point);
        mapping.getGraphMap().put((Object)port, (Object)interfaceEditPart.getModel());
        return port;
    }

    private static void createValueLabels(LayoutMapping mapping, ValueEditPart valueEditPart) {
        Object iePart = valueEditPart.getViewer().getEditPartRegistry().get(valueEditPart.getModel().getVarDeclaration());
        Point point = ((InterfaceEditPart)iePart).getFigure().getBounds().getTopLeft();
        ElkPort port = FordiacLayoutConnector.getPort(point, (InterfaceEditPart)iePart, mapping);
        ElkLabel label = ElkGraphUtil.createLabel((String)valueEditPart.getModel().getValue(), (ElkGraphElement)port);
        Rectangle bounds = valueEditPart.getFigure().getBounds();
        label.setLocation(bounds.preciseX() - port.getX() - port.getParent().getX(), bounds.preciseY() - port.getY() - port.getParent().getY());
        label.setDimensions(bounds.preciseWidth(), bounds.preciseHeight());
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
        this.clear();
        this.calculateNodePositionsRecursively(mapping, mapping.getLayoutGraph(), 0.0, 8.0);
        Map<IInterfaceElement, Integer> pins = FordiacLayoutConnector.createPinOffsetData(mapping);
        LayoutCommand layoutCommand = new LayoutCommand(this.positions, this.connPoints, pins);
        ((CommandStack)mapping.getProperty(COMMAND_STACK)).execute((Command)layoutCommand);
    }

    private static Map<IInterfaceElement, Integer> createPinOffsetData(LayoutMapping mapping) {
        HashMap<IInterfaceElement, Integer> pins = new HashMap<IInterfaceElement, Integer>();
        if (!mapping.getLayoutGraph().getPorts().isEmpty()) {
            InterfaceList interfaceList = (InterfaceList)((IInterfaceElement)mapping.getGraphMap().get(mapping.getLayoutGraph().getPorts().get(0))).eContainer();
            EList allIEs = interfaceList.getAllInterfaceElements();
            mapping.getLayoutGraph().getPorts().forEach(arg_0 -> FordiacLayoutConnector.lambda$5(mapping, (List)allIEs, interfaceList, pins, arg_0));
        }
        return pins;
    }

    private static boolean isFirstInputVar(InterfaceList interfaceList, IInterfaceElement pin) {
        return !interfaceList.getInputVars().isEmpty() && pin.equals(interfaceList.getInputVars().get(0));
    }

    private void calculateNodePositionsRecursively(LayoutMapping mapping, ElkNode node, double parentX, double parentY) {
        GraphicalEditPart ep = (GraphicalEditPart)mapping.getGraphMap().get((Object)node);
        int calculatedX = (int)(node.getX() + parentX);
        int calculatedY = (int)(node.getY() + parentY);
        if (!(ep instanceof AbstractFBNetworkEditPart) || ep instanceof UnfoldedSubappContentEditPart) {
            Position pos = LibraryElementFactory.eINSTANCE.createPosition();
            pos.setX(calculatedX);
            pos.setY(calculatedY);
            this.positions.put((FBNetworkElement)ep.getModel(), pos);
        }
        for (ElkEdge edge : node.getContainedEdges()) {
            ConnectionEditPart connEp = (ConnectionEditPart)mapping.getGraphMap().get((Object)edge);
            ElkPort startPort = (ElkPort)edge.getSources().get(0);
            ElkPort endPort = (ElkPort)edge.getTargets().get(0);
            EList bendPoints = ((ElkEdgeSection)edge.getSections().get(0)).getBendPoints();
            this.connPoints.put(connEp.getModel(), FordiacLayoutConnector.createPointList(node, startPort, endPort, (List<ElkBendPoint>)bendPoints, calculatedX, calculatedY));
        }
        node.getChildren().forEach(child -> this.calculateNodePositionsRecursively(mapping, (ElkNode)child, calculatedX, calculatedY));
    }

    private static PointList createPointList(ElkNode node, ElkPort startPort, ElkPort endPort, List<ElkBendPoint> bendPoints, int calculatedX, int calculatedY) {
        PointList list = new PointList();
        if (startPort.getParent() == node) {
            list.addPoint((int)(startPort.getX() + (double)calculatedX), (int)(startPort.getY() + (double)calculatedY));
        } else {
            list.addPoint((int)(startPort.getX() + startPort.getParent().getX() + (double)calculatedX), (int)(startPort.getY() + startPort.getParent().getY() + (double)calculatedY));
        }
        for (ElkBendPoint point : bendPoints) {
            list.addPoint((int)(point.getX() + (double)calculatedX), (int)(point.getY() + (double)calculatedY));
        }
        if (endPort.getParent() == node) {
            list.addPoint((int)(endPort.getX() + (double)calculatedX), (int)(endPort.getY() + (double)calculatedY));
        } else {
            list.addPoint((int)(endPort.getX() + endPort.getParent().getX() + (double)calculatedX), (int)(endPort.getY() + endPort.getParent().getY() + (double)calculatedY));
        }
        return list;
    }

    private static /* synthetic */ void lambda$5(LayoutMapping layoutMapping, List list, InterfaceList interfaceList, Map map, ElkPort port) {
        IInterfaceElement pin = (IInterfaceElement)layoutMapping.getGraphMap().get((Object)port);
        int index = list.indexOf(pin);
        int padding = (int)port.getY();
        if (index > 0 && pin.isIsInput() == ((IInterfaceElement)list.get(index - 1)).isIsInput()) {
            IInterfaceElement abovePin = (IInterfaceElement)list.get(index - 1);
            ElkPort abovePort = (ElkPort)layoutMapping.getGraphMap().inverse().get((Object)abovePin);
            padding = (int)((double)padding - ((double)((int)abovePort.getY()) + port.getHeight()));
        }
        if (FordiacLayoutConnector.isFirstInputVar(interfaceList, pin)) {
            padding += 8;
        }
        map.put(pin, padding);
    }
}

