/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.elk.core.service.DiagramLayoutEngine;
import org.eclipse.fordiac.ide.elk.FordiacLayoutFactory;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class LayoutHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart workbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        List<Object> selection = LayoutHandler.getSelectedParts(event);
        if (selection.get(0) instanceof AbstractFBNetworkEditPart) {
            LayoutHandler.invokeLayout(workbenchPart, null);
        } else if (LayoutHandler.notLayoutable(selection)) {
            LayoutHandler.invokeLayout(workbenchPart, null);
        } else {
            LayoutHandler.handleSelection(workbenchPart, selection);
        }
        return null;
    }

    private static boolean notLayoutable(List<Object> selection) {
        return selection.stream().noneMatch(LayoutHandler::isLayoutable);
    }

    private static List<Object> getSelectedParts(ExecutionEvent event) {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (StructuredSelection.EMPTY.equals((Object)selection)) {
            throw new IllegalStateException("Selection should at least contain the editors edit part.");
        }
        return selection.toList();
    }

    private static void handleSelection(IWorkbenchPart workbenchPart, List<Object> selection) {
        selection.stream().filter(LayoutHandler::isLayoutable).forEach(diagramPart -> LayoutHandler.invokeLayout(workbenchPart, diagramPart));
    }

    private static void invokeLayout(IWorkbenchPart workbenchPart, Object diagramPart) {
        DiagramLayoutEngine.invokeLayout((IWorkbenchPart)workbenchPart, (Object)diagramPart, (DiagramLayoutEngine.Parameters)FordiacLayoutFactory.createLayoutParams());
    }

    private static boolean isLayoutable(Object object) {
        return false;
    }
}

