/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.gef.commands.Command;

public class ChangeInterfaceOrderCommand
extends Command {
    private IInterfaceElement selection;
    private EList<? extends IInterfaceElement> interfaces;
    private int oldIndex;
    private int newIndex;

    private ChangeInterfaceOrderCommand(IInterfaceElement selection) {
        this.selection = selection;
        if (selection != null && selection.eContainer() instanceof InterfaceList) {
            this.setInterfaces((InterfaceList)selection.eContainer());
            this.oldIndex = this.interfaces.indexOf((Object)selection);
        }
    }

    public ChangeInterfaceOrderCommand(IInterfaceElement selection, boolean moveUp) {
        this(selection);
        int n = this.newIndex = moveUp ? this.oldIndex - 1 : this.oldIndex + 1;
        if (this.newIndex < 0) {
            this.newIndex = 0;
        }
        if (this.newIndex >= this.interfaces.size()) {
            this.newIndex = this.interfaces.size() - 1;
        }
    }

    public ChangeInterfaceOrderCommand(IInterfaceElement selection, int newIndex) {
        this(selection);
        this.newIndex = newIndex;
    }

    private void setInterfaces(InterfaceList interfaceList) {
        this.interfaces = this.isInput() ? (this.selection instanceof Event ? interfaceList.getEventInputs() : (this.selection instanceof AdapterDeclaration ? interfaceList.getSockets() : interfaceList.getInputVars())) : (this.selection instanceof Event ? interfaceList.getEventOutputs() : (this.selection instanceof AdapterDeclaration ? interfaceList.getPlugs() : interfaceList.getOutputVars()));
    }

    public boolean canExecute() {
        return this.selection != null && this.interfaces.size() > 1 && this.interfaces.size() > this.newIndex;
    }

    public void execute() {
        this.moveTo(this.newIndex);
    }

    public void redo() {
        this.moveTo(this.newIndex);
    }

    public void undo() {
        this.moveTo(this.oldIndex);
    }

    private boolean isInput() {
        return this.selection.isIsInput();
    }

    private void moveTo(int index) {
        EList<? extends IInterfaceElement> temp = this.interfaces;
        temp.move(index, (Object)this.selection);
    }
}

