/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.commands.change.IndexUpDown;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.gef.commands.Command;

public class ChangeInternalFBOrderCommand
extends Command {
    private final FB fb;
    private final BaseFBType baseFbType;
    private final int oldIndex;
    private int newIndex;

    public ChangeInternalFBOrderCommand(BaseFBType baseFbtype, FB fb, IndexUpDown updown) {
        this.baseFbType = baseFbtype;
        this.fb = fb;
        this.oldIndex = this.getInteralFBList().indexOf((Object)fb);
        if (updown == IndexUpDown.DOWN) {
            this.newIndex = this.oldIndex + 1;
        } else if (updown == IndexUpDown.UP) {
            this.newIndex = this.oldIndex - 1;
        }
        if (this.newIndex < 0) {
            this.newIndex = 0;
        }
        if (this.newIndex >= this.getInteralFBList().size()) {
            this.newIndex = this.getInteralFBList().size() - 1;
        }
    }

    private EList<FB> getInteralFBList() {
        BaseFBType type = this.baseFbType;
        return type.getInternalFbs();
    }

    public boolean canExecute() {
        return this.fb != null && this.getInteralFBList().size() > 1 && this.getInteralFBList().size() > this.newIndex;
    }

    public void execute() {
        this.getInteralFBList().move(this.newIndex, (Object)this.fb);
    }

    public void redo() {
        this.getInteralFBList().move(this.newIndex, (Object)this.fb);
    }

    public void undo() {
        this.getInteralFBList().move(this.oldIndex, (Object)this.fb);
    }
}

