/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;

public class DeleteErrorMarkerCommand
extends Command {
    private final DeleteInterfaceCommand deleteErrorMarkerIECmd;
    private final DeleteFBNetworkElementCommand deleteErrorMarkerFBN;

    public DeleteErrorMarkerCommand(ErrorMarkerInterface errorIe, FBNetworkElement errorFb) {
        this.deleteErrorMarkerIECmd = new DeleteInterfaceCommand((IInterfaceElement)errorIe);
        this.deleteErrorMarkerFBN = DeleteErrorMarkerCommand.createDeleteFBNCommand(errorIe, errorFb);
    }

    public void execute() {
        this.performDeletion();
    }

    private void performDeletion() {
        this.deleteErrorMarkerIECmd.execute();
        if (this.deleteErrorMarkerFBN != null) {
            this.deleteErrorMarkerFBN.execute();
        }
    }

    public void undo() {
        if (this.deleteErrorMarkerFBN != null) {
            this.deleteErrorMarkerFBN.undo();
        }
        this.deleteErrorMarkerIECmd.undo();
    }

    public void redo() {
        this.deleteErrorMarkerIECmd.redo();
        if (this.deleteErrorMarkerFBN != null) {
            this.deleteErrorMarkerFBN.redo();
        }
    }

    private static DeleteFBNetworkElementCommand createDeleteFBNCommand(ErrorMarkerInterface errorIe, FBNetworkElement errorFb) {
        FBNetworkElement fbNetworkElement = errorIe.getFBNetworkElement();
        if (fbNetworkElement != errorFb && fbNetworkElement instanceof ErrorMarkerFBNElement && fbNetworkElement.getInterface().getErrorMarker().size() == 1) {
            return new DeleteFBNetworkElementCommand(fbNetworkElement);
        }
        return null;
    }
}

