/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.insert;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public class InsertVariableCommand
extends Command {
    private VarDeclaration type;
    private VarDeclaration varDecl;
    private EList<VarDeclaration> list;
    private int index;

    public InsertVariableCommand(EList<VarDeclaration> list, VarDeclaration type, int index) {
        this.list = list;
        this.type = type;
        this.index = index;
    }

    public void execute() {
        this.varDecl = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.varDecl.setType(this.type.getType());
        this.varDecl.setTypeName(this.type.getType().getName());
        this.varDecl.setComment(this.type.getComment());
        this.varDecl.setArraySize(this.type.getArraySize());
        Value value = LibraryElementFactory.eINSTANCE.createValue();
        Value typeValue = this.type.getValue();
        value.setValue(typeValue == null ? "" : typeValue.getValue());
        this.varDecl.setValue(value);
        this.redo();
        this.varDecl.setName(NameRepository.createUniqueName((INamedElement)this.varDecl, (String)this.type.getName()));
    }

    public void redo() {
        this.getVariableList().add(this.index, (Object)this.varDecl);
    }

    public void undo() {
        this.getVariableList().remove((Object)this.varDecl);
    }

    private EList<VarDeclaration> getVariableList() {
        return this.list;
    }
}

