/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit.providers;

import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ResultListLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public StyledString getStyledText(Object element) {
        StyledString styledString = null;
        if (element instanceof PaletteEntry) {
            PaletteEntry entry = (PaletteEntry)element;
            styledString = new StyledString(entry.getLabel());
            styledString.append(" - " + entry.getType().getComment(), StyledString.QUALIFIER_STYLER);
        } else {
            styledString = new StyledString(element.toString());
        }
        return styledString;
    }

    public Image getImage(Object element) {
        if (element instanceof PaletteEntry) {
            PaletteEntry entry = (PaletteEntry)element;
            return ResultListLabelProvider.getTypeImage(entry.getType());
        }
        return null;
    }

    public static Image getTypeImage(LibraryElement type) {
        if (type instanceof SubAppType) {
            return FordiacImage.ICON_SUB_APP_TYPE.getImage();
        }
        if (type instanceof BasicFBType) {
            return FordiacImage.ICON_BASIC_FB.getImage();
        }
        if (type instanceof SimpleFBType) {
            return FordiacImage.ICON_SIMPLE_FB.getImage();
        }
        if (type instanceof CompositeFBType) {
            return FordiacImage.ICON_COMPOSITE_FB.getImage();
        }
        if (type instanceof StructuredType) {
            return FordiacImage.ICON_DATA_TYPE.getImage();
        }
        if (type instanceof AdapterFBType) {
            return FordiacImage.ICON_ADAPTER_TYPE.getImage();
        }
        return FordiacImage.ICON_SIFB.getImage();
    }

    public String getText(Object element) {
        return element instanceof PaletteEntry ? String.format("%s - %s", this.getStyledText(element).toString(), ((PaletteEntry)element).getFile().getFullPath()) : "-";
    }
}

