/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.structuredtext.converter;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public abstract class LongValueConverter
extends AbstractLexerBasedConverter<Long> {
    protected String toEscapedString(Long value) {
        return Long.toString(value, this.getRadix());
    }

    protected void assertValidValue(Long value) {
        super.assertValidValue((Object)value);
        if (value < 0L) {
            String _ruleName = this.getRuleName();
            String _plus = String.valueOf(_ruleName) + "-value may not be negative (value: ";
            String _plus_1 = String.valueOf(_plus) + value;
            String _plus_2 = String.valueOf(_plus_1) + ").";
            throw new ValueConverterException(_plus_2, null, null);
        }
    }

    public Long toValue(String string, INode node) {
        boolean _not;
        Long _xblockexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)string);
        if (_isNullOrEmpty) {
            throw new ValueConverterException("Couldn't convert empty string to a long value.", node, null);
        }
        String prefix = this.getPrefix();
        boolean _startsWith = string.startsWith(prefix);
        boolean bl = _not = !_startsWith;
        if (_not) {
            throw new ValueConverterException("Couldn't convert input '" + string + "' without radix prefix '" + prefix + "' to a long value.", node, null);
        }
        String value = string.substring(prefix.length()).replace("_", "");
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)value);
        if (_isNullOrEmpty_1) {
            throw new ValueConverterException("Couldn't convert input '" + string + "' to a long value.", node, null);
        }
        Long _xtrycatchfinallyexpression = null;
        try {
            Long _xblockexpression_1 = null;
            long longValue = Long.parseUnsignedLong(value, this.getRadix());
            _xtrycatchfinallyexpression = _xblockexpression_1 = Long.valueOf(longValue);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException e = (NumberFormatException)_t;
                throw new ValueConverterException("Couldn't convert '" + string + "' to an int value.", node, (Exception)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    protected String getPrefix() {
        String _string = Integer.toString(this.getRadix());
        return String.valueOf(_string) + "#";
    }

    protected abstract int getRadix();
}

