/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;
import org.eclipse.fordiac.ide.model.Palette.PaletteFactory;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.dataimport.FBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppTImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.helpers.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerRef;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

class SubAppNetworkImporter
extends FBNetworkImporter {
    public SubAppNetworkImporter(CommonElementImporter importer) {
        super(importer);
    }

    public SubAppNetworkImporter(CommonElementImporter importer, InterfaceList interfaceList) {
        super(importer, LibraryElementFactory.eINSTANCE.createFBNetwork(), interfaceList);
    }

    protected SubAppNetworkImporter(CommonElementImporter importer, FBNetwork fbNetwork) {
        super(importer, fbNetwork);
    }

    @Override
    protected boolean handleFBNetworkChild(String name) throws XMLStreamException, TypeImportException {
        if ("SubApp".equals(name)) {
            this.parseSubApp();
            return true;
        }
        return super.handleFBNetworkChild(name);
    }

    private void parseSubApp() throws TypeImportException, XMLStreamException {
        String type = this.getAttributeValue("Type");
        FBNetworkElement subApp = this.createSubapp(type);
        this.readNameCommentAttributes(subApp);
        this.getXandY(subApp);
        this.getFbNetwork().getNetworkElements().add((Object)subApp);
        if (type == null) {
            this.parseUntypedSubapp((SubApp)subApp);
        } else {
            this.parseFBChildren(subApp, "SubApp");
        }
        for (VarDeclaration inVar : subApp.getInterface().getInputVars()) {
            if (inVar.getValue() != null) continue;
            inVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        this.fbNetworkElementMap.put(subApp.getName(), subApp);
        if (subApp.getPaletteEntry() == null && type != null || subApp instanceof ErrorMarkerRef) {
            ErrorMarkerBuilder e = FordiacMarkerHelper.createErrorMarker(MessageFormat.format("Type ({0}) could not be loaded for Subapplication: {1}", type, subApp.getName()), subApp, this.getLineNumber());
            this.errorMarkerAttributes.add(e);
            e.setErrorMarkerRef((ErrorMarkerRef)((Object)subApp));
        }
    }

    public FBNetworkElement createSubapp(String type) {
        SubApp subApp = LibraryElementFactory.eINSTANCE.createSubApp();
        if (type == null) {
            return subApp;
        }
        SubApplicationTypePaletteEntry subEntry = this.getPalette().getSubAppTypeEntry(type);
        if (subEntry == null) {
            return FordiacMarkerHelper.createTypeErrorMarkerFB(type, this.getTypeLibrary(), LibraryElementFactory.eINSTANCE.createSubAppType().eClass(), PaletteFactory.eINSTANCE.createSubApplicationTypePaletteEntry().eClass());
        }
        subApp.setPaletteEntry(subEntry);
        subApp.setInterface(subEntry.getSubApplicationType().getInterfaceList().copy());
        return subApp;
    }

    private void parseUntypedSubapp(SubApp subApp) throws TypeImportException, XMLStreamException {
        this.processChildren("SubApp", name -> {
            switch (name) {
                case "SubAppInterfaceList": {
                    SubAppTImporter interfaceImporter = new SubAppTImporter(this);
                    subApp.setInterface(interfaceImporter.parseInterfaceList("SubAppInterfaceList"));
                    return true;
                }
                case "SubAppNetwork": {
                    SubAppNetworkImporter subAppImporter = new SubAppNetworkImporter((CommonElementImporter)this, subApp.getInterface());
                    subApp.setSubAppNetwork(subAppImporter.getFbNetwork());
                    subAppImporter.parseFBNetwork("SubAppNetwork");
                    return true;
                }
                case "Parameter": {
                    this.parseParameter(subApp);
                    return true;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(subApp);
                    this.proceedToEndElementNamed("Attribute");
                    return true;
                }
            }
            return false;
        });
    }
}

