/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.gef.commands.CommandStack;

public class SystemImporter
extends CommonElementImporter {
    public SystemImporter(IFile systemfile) {
        super(systemfile);
    }

    @Override
    public AutomationSystem getElement() {
        return (AutomationSystem)super.getElement();
    }

    @Override
    protected LibraryElement createRootModelElement() {
        return SystemImporter.createAutomationSystem(this.getFile());
    }

    public static AutomationSystem createAutomationSystem(IFile systemFile) {
        AutomationSystem system = LibraryElementFactory.eINSTANCE.createAutomationSystem();
        system.setName(TypeLibrary.getTypeNameFromFile(systemFile));
        system.setSystemFile(systemFile);
        system.setCommandStack(new CommandStack());
        SystemConfiguration sysConf = LibraryElementFactory.eINSTANCE.createSystemConfiguration();
        system.setSystemConfiguration(sysConf);
        system.setPalette(TypeLibrary.getTypeLibrary(systemFile.getProject()).getBlockTypeLib());
        return system;
    }

    @Override
    protected String getStartElementName() {
        return "System";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        SystemConfiguration sysConf = this.getElement().getSystemConfiguration();
        return name -> {
            switch (name) {
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "Application": {
                    this.getElement().getApplication().add((Object)this.parseApplication());
                    break;
                }
                case "Device": {
                    sysConf.getDevices().add((Object)this.parseDevice());
                    break;
                }
                case "Mapping": {
                    this.parseMapping();
                    break;
                }
                case "Segment": {
                    sysConf.getSegments().add((Object)this.parseSegment());
                    break;
                }
                case "Link": {
                    this.parseLink(sysConf);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    private Segment parseSegment() throws TypeImportException, XMLStreamException {
        String type;
        Segment segment = LibraryElementFactory.eINSTANCE.createSegment();
        this.readNameCommentAttributes(segment);
        this.getXandY(segment);
        String dx1 = this.getAttributeValue("dx1");
        if (dx1 != null) {
            segment.setWidth(CoordinateConverter.INSTANCE.convertFrom1499XML(dx1));
        }
        if ((type = this.getAttributeValue("Type")) != null) {
            segment.setPaletteEntry(this.getPalette().getSegmentTypeEntry(type));
        }
        this.parseSegmentNodeChildren(segment);
        return segment;
    }

    private void parseSegmentNodeChildren(Segment segment) throws XMLStreamException, TypeImportException {
        this.processChildren("Segment", name -> {
            if ("Attribute".equals(name)) {
                if (this.isColorAttributeNode()) {
                    this.parseColor(segment);
                } else {
                    this.parseGenericAttributeNode(segment);
                }
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
    }

    private void parseLink(SystemConfiguration sysConf) throws XMLStreamException {
        String commResource = this.getAttributeValue("CommResource");
        String comment = this.getAttributeValue("Comment");
        String segmentName = this.getAttributeValue("SegmentName");
        Segment segment = sysConf.getSegmentNamed(segmentName);
        Device device = sysConf.getDeviceNamed(commResource);
        if (segment != null && device != null) {
            Link link = LibraryElementFactory.eINSTANCE.createLink();
            link.setComment(comment);
            segment.getOutConnections().add((Object)link);
            device.getInConnections().add((Object)link);
            sysConf.getLinks().add((Object)link);
        }
        this.proceedToEndElementNamed("Link");
    }

    private Device parseDevice() throws TypeImportException, XMLStreamException {
        Device device = LibraryElementFactory.eINSTANCE.createDevice();
        this.readNameCommentAttributes(device);
        this.getXandY(device);
        this.parseDeviceType(device);
        this.parseDeviceNodeChildren(device);
        return device;
    }

    private void parseDeviceType(Device device) {
        DeviceTypePaletteEntry entry;
        String typeName = this.getAttributeValue("Type");
        if (typeName != null && (entry = this.getPalette().getDeviceTypeEntry(typeName)) != null) {
            device.setPaletteEntry(entry);
            SystemImporter.createParamters(device);
        }
    }

    private void parseMapping() throws XMLStreamException {
        String fromValue = this.getAttributeValue("From");
        String toValue = this.getAttributeValue("To");
        FBNetworkElement fromElement = this.findMappingTargetFromName(fromValue);
        FBNetworkElement toElement = this.findMappingTargetFromName(toValue);
        if (fromElement instanceof SubApp) {
            FBNetworkHelper.loadSubappNetwork(fromElement);
        }
        if (fromElement != null && toElement != null) {
            this.getElement().getMapping().add((Object)SystemImporter.createMappingEntry(toElement, fromElement));
        }
        this.proceedToEndElementNamed("Mapping");
    }

    private static Mapping createMappingEntry(FBNetworkElement toElement, FBNetworkElement fromElement) {
        Mapping mapping = LibraryElementFactory.eINSTANCE.createMapping();
        mapping.setFrom(fromElement);
        mapping.setTo(toElement);
        toElement.setMapping(mapping);
        fromElement.setMapping(mapping);
        return mapping;
    }

    private FBNetworkElement findMappingTargetFromName(String targetName) {
        ArrayDeque<String> parts;
        FBNetworkElement element = null;
        if (targetName != null && (parts = new ArrayDeque<String>(Arrays.asList(targetName.split("\\.")))).size() >= 2) {
            FBNetwork nw = null;
            Device dev = this.getElement().getDeviceNamed((String)parts.getFirst());
            Application application = this.getElement().getApplicationNamed((String)parts.getFirst());
            if (dev != null) {
                parts.pollFirst();
                Resource res = dev.getResourceNamed((String)parts.pollFirst());
                if (res != null) {
                    nw = res.getFBNetwork();
                    element = SystemImporter.findMappingTargetInFBNetwork(nw, parts);
                }
            }
            if (element == null && application != null) {
                parts = new ArrayDeque<String>(Arrays.asList(targetName.split("\\.")));
                parts.pollFirst();
                nw = application.getFBNetwork();
                element = SystemImporter.findMappingTargetInFBNetwork(nw, parts);
            }
        }
        return element;
    }

    private static FBNetworkElement findMappingTargetInFBNetwork(FBNetwork nw, Deque<String> parts) {
        FBNetworkElement element;
        if (nw != null && (element = nw.getElementNamed(parts.pollFirst())) != null) {
            if (parts.isEmpty()) {
                return element;
            }
            if (element instanceof SubApp) {
                SystemImporter.findMappingTargetInFBNetwork(((SubApp)element).getFbNetwork(), parts);
            }
        }
        return null;
    }

    private void parseDeviceNodeChildren(Device device) throws TypeImportException, XMLStreamException {
        this.processChildren("Device", name -> {
            switch (name) {
                case "Attribute": {
                    this.parseDeviceAttribute(device);
                    break;
                }
                case "Parameter": {
                    VarDeclaration parameter = this.parseParameter();
                    if (parameter == null) break;
                    VarDeclaration devParam = SystemImporter.getParamter((EList<VarDeclaration>)device.getVarDeclarations(), parameter.getName());
                    if (devParam != null) {
                        devParam.setValue(parameter.getValue());
                        break;
                    }
                    parameter.setIsInput(true);
                    device.getVarDeclarations().add((Object)parameter);
                    break;
                }
                case "Resource": {
                    device.getResource().add((Object)this.parseResource());
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
    }

    private void parseDeviceAttribute(Device device) throws XMLStreamException {
        if (this.isColorAttributeNode()) {
            this.parseColor(device);
        } else if (this.isProfileAttribute()) {
            this.parseProfile(device);
        } else {
            this.parseGenericAttributeNode(device);
        }
        this.proceedToEndElementNamed("Attribute");
    }

    private boolean isColorAttributeNode() {
        String name = this.getAttributeValue("Name");
        return name != null && "Color".equals(name);
    }

    private void parseColor(ColorizableElement colElement) {
        Color color = LibraryElementFactory.eINSTANCE.createColor();
        String value = this.getAttributeValue("Value");
        if (value != null) {
            String[] colors = value.split(",");
            color.setRed(Integer.parseInt(colors[0]));
            color.setGreen(Integer.parseInt(colors[1]));
            color.setBlue(Integer.parseInt(colors[2]));
            colElement.setColor(color);
        }
    }

    private Application parseApplication() throws TypeImportException, XMLStreamException {
        Application application = LibraryElementFactory.eINSTANCE.createApplication();
        this.readNameCommentAttributes(application);
        this.processChildren("Application", name -> {
            switch (name) {
                case "Attribute": {
                    this.parseGenericAttributeNode(application);
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                case "SubAppNetwork": {
                    SubAppNetworkImporter supAppImporter = new SubAppNetworkImporter(this);
                    application.setFBNetwork(supAppImporter.getFbNetwork());
                    supAppImporter.parseFBNetwork("SubAppNetwork");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        return application;
    }
}

