/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.deployment.monitoringbase.PortElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringFactory;
import org.eclipse.fordiac.ide.model.monitoring.SubappMonitoringElement;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.MonitoringManagerUtils;

public final class SubAppPortHelper {
    public static IInterfaceElement findAnchorInterfaceElement(IInterfaceElement subappPin) {
        boolean isInput = subappPin.isIsInput();
        if (SubAppPortHelper.hasEmptyConnections(subappPin, isInput)) {
            return null;
        }
        IInterfaceElement current = subappPin;
        while (current.getFBNetworkElement() instanceof SubApp) {
            EList<Connection> outConns = SubAppPortHelper.getConnections(current, isInput);
            if (outConns.isEmpty()) {
                return null;
            }
            current = SubAppPortHelper.assignNextInterfaceElement(isInput, outConns).get(0);
        }
        return current;
    }

    public static String findConnectedMonitoredSubappPort(IInterfaceElement interfaceElement, Map<String, List<MonitoringElement>> subappElements) {
        boolean searchDirection = interfaceElement.isIsInput();
        IInterfaceElement currentIe = interfaceElement;
        do {
            EList<Connection> connections;
            if ((connections = SubAppPortHelper.getConnections(currentIe, searchDirection)).isEmpty()) {
                return null;
            }
            List<IInterfaceElement> nextElements = SubAppPortHelper.assignNextInterfaceElement(searchDirection, connections);
            for (IInterfaceElement nextIe : nextElements) {
                PortElement subappPortCanidate;
                String anchor;
                currentIe = nextIe;
                if (!currentIe.getFBNetworkElement().isMapped() || !subappElements.containsKey(anchor = SubAppPortHelper.searchSubappAnchor(subappElements, subappPortCanidate = MonitoringManagerUtils.createPortElement(currentIe.getFBNetworkElement(), currentIe)))) continue;
                return anchor;
            }
        } while (currentIe.getFBNetworkElement() instanceof SubApp);
        return null;
    }

    public static List<MonitoringElement> findConnectedElements(IInterfaceElement interfaceElement) {
        ArrayList<MonitoringElement> elements = new ArrayList<MonitoringElement>();
        boolean searchDirection = interfaceElement.isIsInput();
        SubAppPortHelper.findConnectedElements(elements, interfaceElement, searchDirection);
        return elements;
    }

    public static List<MonitoringElement> findConnectedElements(IInterfaceElement interfaceElement, boolean searchDirection) {
        ArrayList<MonitoringElement> elements = new ArrayList<MonitoringElement>();
        SubAppPortHelper.findConnectedElements(elements, interfaceElement, searchDirection);
        return elements;
    }

    public static void findConnectedElements(List<MonitoringElement> elements, IInterfaceElement interfaceElement) {
        boolean searchDirection = interfaceElement.isIsInput();
        SubAppPortHelper.findConnectedElements(elements, interfaceElement, searchDirection);
    }

    public static void findConnectedElements(List<MonitoringElement> elements, IInterfaceElement interfaceElement, boolean searchDirection) {
        IInterfaceElement currentIe = interfaceElement;
        EList<Connection> connections = SubAppPortHelper.getConnections(currentIe, searchDirection);
        if (connections.isEmpty()) {
            return;
        }
        List<IInterfaceElement> nextElements = SubAppPortHelper.assignNextInterfaceElement(searchDirection, connections);
        Iterator<IInterfaceElement> iterator = nextElements.iterator();
        while (iterator.hasNext()) {
            IInterfaceElement nextIe;
            currentIe = nextIe = iterator.next();
            if (nextIe.getFBNetworkElement() instanceof SubApp) {
                SubAppPortHelper.findConnectedElements(elements, nextIe, searchDirection);
                continue;
            }
            if (!nextIe.getFBNetworkElement().isNestedInSubApp() && !nextIe.getFBNetworkElement().isMapped()) continue;
            MonitoringElement element = MonitoringFactory.eINSTANCE.createMonitoringElement();
            PortElement anchorPort = MonitoringManagerUtils.createPortElement(currentIe);
            element.setPort(anchorPort);
            elements.add(element);
        }
    }

    public static List<IInterfaceElement> assignNextInterfaceElement(boolean isInput, Collection<Connection> connections) {
        return connections.stream().map(connection -> isInput ? connection.getDestination() : connection.getSource()).collect(Collectors.toList());
    }

    public static boolean hasEmptyConnections(IInterfaceElement ie, boolean isInput) {
        EList<Connection> connections = SubAppPortHelper.getConnections(ie, isInput);
        return connections.isEmpty();
    }

    public static EList<Connection> getConnections(IInterfaceElement ie, boolean isInput) {
        return isInput ? ie.getOutputConnections() : ie.getInputConnections();
    }

    public static String searchSubappAnchor(Map<String, List<MonitoringElement>> subappElements, PortElement createPortElement) {
        MonitoringBaseElement monitoringElement = MonitoringManager.getInstance().getMonitoringElement(createPortElement.getInterfaceElement());
        if (!(monitoringElement instanceof SubappMonitoringElement)) {
            return "";
        }
        MonitoringBaseElement anchor = ((SubappMonitoringElement)monitoringElement).getAnchor();
        return anchor.getPort().getPortString();
    }

    private SubAppPortHelper() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

