/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.DistributedSystemListener;
import org.eclipse.fordiac.ide.systemmanagement.ui.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ui.providers.SystemElementItemProviderAdapterFactory;

public class SystemContentProvider
extends AdapterFactoryContentProvider
implements DistributedSystemListener {
    private static ComposedAdapterFactory systemAdapterFactory = new ComposedAdapterFactory(SystemContentProvider.createFactoryList());

    public SystemContentProvider() {
        super((AdapterFactory)systemAdapterFactory);
        SystemManager.INSTANCE.addWorkspaceListener((DistributedSystemListener)this);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IResource) {
            return this.getResourceChildren((IResource)parentElement);
        }
        return super.getChildren(parentElement);
    }

    public Object getParent(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        if (object instanceof Application) {
            Application app = (Application)object;
            return app.getAutomationSystem() != null ? app.getAutomationSystem().getSystemFile() : null;
        }
        if (object instanceof SystemConfiguration) {
            return ((SystemConfiguration)object).getAutomationSystem().getSystemFile();
        }
        if (object instanceof AutomationSystem) {
            return ((AutomationSystem)object).getSystemFile();
        }
        return super.getParent(object);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IResource) {
            if (element instanceof IProject) {
                return ((IProject)element).isAccessible();
            }
            if (SystemManager.isSystemFile((Object)element)) {
                return true;
            }
        }
        return super.hasChildren(element);
    }

    private static List<AdapterFactory> createFactoryList() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        factories.add((AdapterFactory)new SystemElementItemProviderAdapterFactory());
        factories.add((AdapterFactory)new DataItemProviderAdapterFactory());
        return factories;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof AutomationSystem) {
            AutomationSystem system = (AutomationSystem)notification.getNotifier();
            super.notifyChanged((Notification)new ViewerNotification(notification, (Object)system.getSystemFile()));
        } else {
            super.notifyChanged(notification);
            if (notification.getFeatureID(ConfigurableObject.class) == 0) {
                this.distributedSystemWorkspaceChanged();
            }
        }
    }

    public void distributedSystemWorkspaceChanged() {
        if (this.viewer != null && this.viewer.getControl() != null && this.viewer.getControl().getDisplay() != null) {
            this.viewer.getControl().getDisplay().asyncExec(() -> this.viewer.refresh());
        }
    }

    private Object[] getResourceChildren(IResource resource) {
        if (resource instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)resource;
            return Arrays.stream(root.getProjects()).filter(SystemContentProvider::projectToShow).collect(Collectors.toList()).toArray(new IProject[0]);
        }
        if (resource instanceof IProject && ((IProject)resource).isOpen() || resource instanceof IFolder) {
            try {
                return ((IContainer)resource).members();
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Could not read project children", (Exception)((Object)e));
            }
        }
        if (SystemManager.isSystemFile((Object)resource)) {
            return super.getChildren((Object)SystemManager.INSTANCE.getSystem((IFile)resource));
        }
        return new Object[0];
    }

    private static boolean projectToShow(IProject proj) {
        try {
            return !proj.isOpen() || proj.hasNature("org.eclipse.fordiac.ide.systemmanagement.FordiacNature");
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Could not read project nature", (Exception)((Object)e));
            return false;
        }
    }
}

