/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.commands.NewAppCommand;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.NewApplicationPage;
import org.eclipse.fordiac.ide.typemanagement.navigator.TypeLibRootElement;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class NewApplicationWizard
extends Wizard
implements INewWizard {
    private NewApplicationPage page;
    private AutomationSystem system;

    public NewApplicationWizard() {
        this.setWindowTitle(Messages.NewApplicationWizardTitle);
    }

    public boolean performFinish() {
        this.performApplicationCreation(this.page.getApplicationName(), this.page.getOpenApplication());
        return true;
    }

    public void performApplicationCreation(String appName, boolean openApplication) {
        NewAppCommand cmd = new NewAppCommand(this.system, appName, "");
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        cmd.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)cmd, null, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
            Application app = cmd.getApplication();
            if (openApplication && app != null) {
                OpenListenerManager.openEditor((EObject)app);
            }
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void addPages() {
        this.page = new NewApplicationPage(this.system);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.system = null;
        if (selection != null) {
            Object selObj = selection.getFirstElement();
            if (selObj instanceof EditPart) {
                selObj = ((EditPart)selObj).getModel();
            }
            this.system = NewApplicationWizard.getSystemFromSelectedObject(selObj);
        }
    }

    private static AutomationSystem getSystemFromSelectedObject(Object selObj) {
        if (SystemManager.isSystemFile((Object)selObj)) {
            return SystemManager.INSTANCE.getSystem((IFile)selObj);
        }
        if (selObj instanceof FBNetwork) {
            return ((FBNetwork)selObj).getAutomationSystem();
        }
        if (selObj instanceof AutomationSystem) {
            return (AutomationSystem)selObj;
        }
        if (selObj instanceof Application) {
            return ((Application)selObj).getAutomationSystem();
        }
        if (selObj instanceof SystemConfiguration) {
            return ((SystemConfiguration)selObj).getAutomationSystem();
        }
        if (selObj instanceof TypeLibRootElement) {
            return ((TypeLibRootElement)selObj).getSystem();
        }
        return null;
    }
}

