/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.handlers;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessage;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventHandler;

public class ErrorMessageHandler {
    private static final int MOUSE_HOVER_DELAY = 700;
    private boolean isHovering = false;
    private static final String TOPIC_ERRORMESSAGES = "ORG/ECLIPSE/FORDIAC/IDE/ERRORMESSAGES";
    private IEventBroker eventBroker;
    private boolean eventsRegistered = false;
    private final LinkedList<Composite> windows = new LinkedList();
    private final Set<ErrorMessage> messages = new HashSet<ErrorMessage>();
    private final EventHandler receiver = event -> {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (this.eventsRegistered && data instanceof ErrorMessage) {
            this.showErrorMessageDialog((ErrorMessage)data);
        }
    };

    public synchronized void setHover(boolean hovering) {
        this.isHovering = hovering;
        if (!hovering) {
            this.messages.stream().forEach(ErrorMessage::setInvalid);
            this.closeAllDialogs();
        }
    }

    public ErrorMessageHandler(BundleContext context) {
        this.initEventBroker(context);
    }

    public void stop() {
        if (this.eventsRegistered) {
            this.eventsRegistered = !this.eventBroker.unsubscribe(this.receiver);
        }
    }

    public void start() {
        if (!this.eventsRegistered) {
            this.eventsRegistered = this.eventBroker.subscribe(TOPIC_ERRORMESSAGES, this.receiver);
        }
    }

    private synchronized void initEventBroker(BundleContext context) {
        if (this.eventBroker == null) {
            this.eventBroker = (IEventBroker)EclipseContextFactory.getServiceContext((BundleContext)context).get(IEventBroker.class);
        }
    }

    private synchronized void clearDialog(Composite dialogArea) {
        if (dialogArea != null && !dialogArea.isDisposed()) {
            this.closeDialog(dialogArea);
        }
    }

    private synchronized void closeDialog(Composite dialogArea) {
        if (dialogArea != null && !dialogArea.isDisposed()) {
            this.windows.remove(dialogArea.getShell());
            dialogArea.getShell().close();
        }
        this.removeInvalidMessages();
    }

    private void removeInvalidMessages() {
        List toRemove = this.messages.stream().filter(m -> !m.isStillValid()).collect(Collectors.toList());
        for (ErrorMessage m2 : toRemove) {
            ErrorMessenger.hashCleared((int)m2.hashCode());
        }
        this.messages.removeAll(toRemove);
    }

    private void showErrorMessageDialog(ErrorMessage m) {
        if (this.isHovering) {
            this.updateMessageList(m);
            Display.getDefault().timerExec(700, () -> {
                if (this.isHovering) {
                    this.closeAllDialogs();
                    this.showMessages(m);
                    m.setInvalid();
                } else {
                    ErrorMessenger.hashCleared((int)m.hashCode());
                }
            });
        } else {
            Display.getDefault().asyncExec(() -> this.activateErrorMessageDialog(m));
        }
    }

    private void activateErrorMessageDialog(ErrorMessage m) {
        this.updateMessageList(m);
        this.closeAllDialogs();
        this.showMessages(m);
        ErrorMessenger.hashCleared((int)m.hashCode());
    }

    private void updateMessageList(ErrorMessage m) {
        this.messages.add(m);
        this.removeInvalidMessages();
    }

    private void closeAllDialogs() {
        Composite w = this.windows.pollFirst();
        while (w != null) {
            this.closeDialog(w);
            w = this.windows.pollFirst();
        }
    }

    private void showMessages(ErrorMessage m) {
        if (!this.messages.isEmpty()) {
            String dialogContent = this.messages.stream().map(ErrorMessage::getMessage).collect(Collectors.joining("\n"));
            ErrorMessageDialog dialog = new ErrorMessageDialog(this, dialogContent, m.getTimeout());
            dialog.open();
            this.windows.push((Composite)dialog.getShell());
        }
    }

    private static final class ErrorMessageDialog
    extends PopupDialog {
        private static final int ERROR_TEXT_WIDTH_HINT = 400;
        private static final int MOUSE_CURSOR_OFFSET_Y = 10;
        private static final int MOUSE_CURSOR_OFFSET_X = 5;
        private static final Point MOUSE_CURSOR_OFFSET = new Point(5, 10);
        private final String errorMsg;
        private final int timeout;
        private final ErrorMessageHandler container;
        private final FocusListener lostFocusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                container.clearDialog((Composite)this.getShell());
            }

            public void focusGained(FocusEvent e) {
            }
        };
        private final KeyListener keypressListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                container.clearDialog((Composite)this.getShell());
            }
        };
        private final SelectionListener selectionChangeListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                container.clearDialog((Composite)this.getShell());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };

        protected Color getBackground() {
            return Display.getCurrent().getSystemColor(29);
        }

        protected Color getForeground() {
            return Display.getCurrent().getSystemColor(28);
        }

        private ErrorMessageDialog(ErrorMessageHandler container, String errorMsg, int timeout) {
            super(null, 540676, false, false, false, false, false, null, null);
            this.errorMsg = errorMsg;
            this.timeout = timeout;
            this.container = container;
        }

        protected void adjustBounds() {
            Point pt;
            super.adjustBounds();
            Control focused = this.getShell().getDisplay().getFocusControl();
            if (ErrorMessageDialog.isTextInput(focused)) {
                Rectangle elementBounds = focused.getDisplay().getBounds();
                pt = focused.toDisplay(new Point(elementBounds.x, elementBounds.y + focused.getSize().y));
            } else if (ErrorMessageDialog.isTableInput(focused)) {
                Table table = (Table)focused;
                TableItem ti = table.getItem(table.getSelectionIndex());
                Rectangle elementBounds = ti.getBounds();
                pt = focused.toDisplay(new Point(elementBounds.x, elementBounds.y + ti.getBounds().height));
            } else {
                pt = this.getShell().getDisplay().getCursorLocation();
                pt.x += ErrorMessageDialog.MOUSE_CURSOR_OFFSET.x;
                pt.y += ErrorMessageDialog.MOUSE_CURSOR_OFFSET.y;
            }
            Rectangle boundingBox = this.getShell().getBounds();
            boundingBox.x = pt.x;
            boundingBox.y = pt.y;
            this.getShell().setBounds(boundingBox);
        }

        private static boolean isTextInput(Control focused) {
            return focused instanceof Text && ((Text)focused).getEditable();
        }

        private static boolean isTableInput(Control focused) {
            if (focused instanceof Table) {
                Table table = (Table)focused;
                return table.getSelectionCount() != 0 && table.getItem(table.getSelectionIndex()) != null;
            }
            return false;
        }

        protected Control createDialogArea(Composite parent) {
            Composite warningComposite = new Composite(parent, 0);
            warningComposite.setLayout((Layout)new GridLayout(2, false));
            warningComposite.setLayoutData((Object)new GridData(0, 0, true, true));
            Label image = new Label(warningComposite, 0);
            image.setImage(parent.getDisplay().getSystemImage(8));
            image.setLayoutData((Object)new GridData(4, 4, true, true));
            Label errorText = new Label(warningComposite, 64);
            errorText.setText(this.errorMsg);
            GridData errorTestLayoutData = new GridData(4, 0x1000000, true, true);
            errorTestLayoutData.widthHint = 400;
            errorText.setLayoutData((Object)errorTestLayoutData);
            Control focused = this.getShell().getDisplay().getFocusControl();
            if (ErrorMessageDialog.isTextInput(focused)) {
                this.clearPopupOnKeypress(focused);
                this.clearPopupOnLostFocus(focused);
            } else if (ErrorMessageDialog.isTableInput(focused)) {
                this.clearPopupOnKeypress(focused);
                this.clearPopupOnLostFocus(focused);
                this.clearPopupOnSelectionChange(focused);
            } else {
                this.clearPopupAfterTimeout(this.timeout);
            }
            return warningComposite;
        }

        private void clearPopupAfterTimeout(int t) {
            if (!this.container.isHovering) {
                this.getShell().getDisplay().timerExec(t, () -> this.container.clearDialog((Composite)this.getShell()));
            }
        }

        private void clearPopupOnLostFocus(Control focused) {
            focused.removeFocusListener(this.lostFocusListener);
            focused.addFocusListener(this.lostFocusListener);
        }

        private void clearPopupOnKeypress(Control focused) {
            focused.removeKeyListener(this.keypressListener);
            focused.addKeyListener(this.keypressListener);
        }

        private void clearPopupOnSelectionChange(Control focused) {
            if (focused instanceof Table) {
                Table table = (Table)focused;
                table.removeSelectionListener(this.selectionChangeListener);
                table.addSelectionListener(this.selectionChangeListener);
            }
        }
    }
}

