/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.Collections;
import java.util.List;
import org.eclipse.fordiac.ide.ui.providers.CommandProvider;
import org.eclipse.fordiac.ide.ui.providers.CreationCommandProvider;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddDeleteReorderListWidget
extends AddDeleteWidget {
    private Button upButton;
    private Button downButton;

    @Override
    public void createControls(Composite parent, FormToolkit widgetFactory) {
        Composite container = AddDeleteReorderListWidget.createContainer(widgetFactory, parent);
        container.setLayout((Layout)new FillLayout(512));
        this.createAddButton(widgetFactory, container);
        this.upButton = widgetFactory.createButton(container, "", 132);
        this.upButton.setToolTipText("Move element(s) up");
        this.upButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.downButton = widgetFactory.createButton(container, "", 1028);
        this.downButton.setToolTipText("Move element(s) down");
        this.downButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.createDeleteButton(widgetFactory, container);
        this.setButtonEnablement(false);
    }

    @Override
    public void setButtonEnablement(boolean enable) {
        this.upButton.setEnabled(enable);
        this.downButton.setEnabled(enable);
        super.setButtonEnablement(enable);
    }

    public void addUpListener(Listener upListener) {
        this.upButton.addListener(13, upListener);
    }

    public void addDownListener(Listener downListener) {
        this.downButton.addListener(13, downListener);
    }

    public void bindToTableViewer(TableViewer viewer, CommandExecutor executor, CreationCommandProvider addCommand, CommandProvider deleteCommand, CommandProvider moveUpCommand, CommandProvider moveDownCommand) {
        super.bindToTableViewer(viewer, executor, addCommand, deleteCommand);
        this.addUpListener(AddDeleteReorderListWidget.getSelectionListener(viewer, executor, moveUpCommand));
        this.addDownListener(AddDeleteReorderListWidget.getReverseSelectionListener(viewer, executor, moveDownCommand));
    }

    public static Listener getReverseSelectionListener(TableViewer viewer, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            if (!viewer.getStructuredSelection().isEmpty()) {
                List bottomup = viewer.getStructuredSelection().toList();
                Collections.reverse(bottomup);
                AddDeleteReorderListWidget.executeCompoundCommandForList(viewer, bottomup, executor, commandProvider);
            }
        };
    }
}

