/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import com.google.common.annotations.Beta;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.xtext.ui.wizard.template.AbstractFileTemplate;
import org.eclipse.xtext.ui.wizard.template.IFileGenerator;
import org.eclipse.xtext.ui.wizard.template.IParameterPage;
import org.eclipse.xtext.ui.wizard.template.Messages;
import org.eclipse.xtext.ui.wizard.template.ParameterComposite;
import org.eclipse.xtext.ui.wizard.template.TemplateFileInfo;
import org.eclipse.xtext.ui.wizard.template.TemplateLabelProvider;

@Beta
public class NewFileWizardPrimaryPage
extends WizardPage
implements IParameterPage {
    private final AbstractFileTemplate[] templates;
    private final IStructuredSelection selection;
    private Text folderText;
    private Text fileText;
    private ParameterComposite parameterComposite;
    private ComboViewer templateCombo;
    private TemplateLabelProvider labelProvider;

    protected NewFileWizardPrimaryPage(String pageName, AbstractFileTemplate[] templates, IStructuredSelection selection, TemplateLabelProvider labelProvider) {
        super(pageName);
        this.templates = templates;
        this.selection = selection;
        this.labelProvider = labelProvider;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.TemplateNewFileWizard_title);
        if (this.hasExactlyOneTemplate()) {
            this.setDescription(this.getSelectedTemplate().getDescription());
        } else {
            this.setDescription(Messages.TemplateNewFileWizard_create_new);
        }
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        main.setLayout((Layout)new GridLayout(2, false));
        this.createHeader(main);
        this.createTemplateWidgets(main);
        this.setControl((Control)main);
        this.validateInitial();
    }

    private void createHeader(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        main.setLayout((Layout)new GridLayout(3, false));
        Label folderLabel = new Label(main, 0);
        folderLabel.setText(Messages.NewFileWizardPrimaryPage_folder_label);
        folderLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.folderText = new Text(main, 2052);
        this.folderText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button folderBrowseButton = new Button(main, 8);
        folderBrowseButton.setText(Messages.NewFileWizardPrimaryPage_browse_button);
        folderBrowseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label fileLabel = new Label(main, 0);
        fileLabel.setText(Messages.NewFileWizardPrimaryPage_name_label);
        fileLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fileText = new Text(main, 2052);
        this.fileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fileText.setFocus();
        this.folderText.setText(this.initFolderText());
        this.fileText.setText(this.initFileText());
        this.folderText.addModifyListener(e -> this.validate());
        this.fileText.addModifyListener(e -> this.validate());
        folderBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(Display.getDefault().getActiveShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.NewFileWizardPrimaryPage_selection_description);
                if (dialog.open() == 0) {
                    NewFileWizardPrimaryPage.this.folderText.setText(NewFileWizardPrimaryPage.this.getFolderFromPath((IPath)dialog.getResult()[0]));
                }
            }
        });
    }

    protected String initFolderText() {
        return this.getFolderFromSelection();
    }

    protected String initFileText() {
        return "";
    }

    protected String getFolderFromSelection() {
        Object element = Adapters.adapt((Object)this.selection.getFirstElement(), IResource.class);
        IContainer container = null;
        if (element instanceof IContainer) {
            container = (IContainer)element;
        } else if (element instanceof IResource) {
            container = ((IResource)element).getParent();
        }
        if (container != null) {
            return this.getFolderStringFromContainer(container);
        }
        return "";
    }

    private String getFolderStringFromContainer(IContainer container) {
        return this.getFolderFromPath(container.getFullPath());
    }

    private String getFolderFromPath(IPath path) {
        String result = path.toOSString();
        if (result.startsWith(File.separator)) {
            return result.substring(File.separator.length());
        }
        return result;
    }

    private void createTemplateWidgets(Composite main) {
        if (this.hasExactlyOneTemplateWithVariables()) {
            Label seperator = new Label(main, 258);
            seperator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.parameterComposite = new ParameterComposite(main, 0, this.templates[0], this);
            this.parameterComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        } else if (this.hasMoreThenOneTempalte()) {
            Label seperator = new Label(main, 258);
            seperator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            Label templateLabel = new Label(main, 0);
            templateLabel.setText(Messages.NewFileWizardPrimaryPage_template_label);
            templateLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.templateCombo = new ComboViewer(main);
            this.templateCombo.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.templateCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.templateCombo.setInput((Object)this.templates);
            this.templateCombo.setSelection((ISelection)new StructuredSelection((Object)this.templates[0]));
            this.templateCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.templateCombo.getCombo().setToolTipText(this.getSelectedTemplate().getDescription());
            this.templateCombo.addSelectionChangedListener(e -> {
                this.templateCombo.getCombo().setToolTipText(this.getSelectedTemplate().getDescription());
                this.validate();
                this.getContainer().updateButtons();
            });
        }
    }

    private boolean hasExactlyOneTemplateWithVariables() {
        return this.hasExactlyOneTemplate() && this.templates[0].variables.size() > 0;
    }

    private boolean hasExactlyOneTemplate() {
        return this.templates.length == 1;
    }

    private boolean hasMoreThenOneTempalte() {
        return this.templates.length > 1;
    }

    protected void validateInitial() {
        this.setStatus(null);
        IContainer folder = this.getFolder();
        if (folder == null || !folder.exists()) {
            this.setStatus((IStatus)new Status(4, "NewFileWizard", String.valueOf(Messages.NewFileWizardPrimaryPage_unexistint_folder_pre) + this.folderText.getText() + Messages.NewFileWizardPrimaryPage_unexistent_folder_post));
            return;
        }
        if (this.parameterComposite != null) {
            this.parameterComposite.validate();
        }
        this.setPageComplete(false);
    }

    protected void validate() {
        this.setStatus(null);
        IContainer folder = this.getFolder();
        if (folder == null || !folder.exists()) {
            this.setStatus((IStatus)new Status(4, "NewFileWizard", String.valueOf(Messages.NewFileWizardPrimaryPage_unexistint_folder_pre) + this.folderText.getText() + Messages.NewFileWizardPrimaryPage_unexistent_folder_post));
            return;
        }
        if ("".equals(this.fileText.getText().trim())) {
            this.setStatus((IStatus)new Status(4, "NewFileWizard", Messages.NewFileWizardPrimaryPage_empty_name));
            return;
        }
        if (this.parameterComposite != null) {
            this.parameterComposite.validate();
        }
        if (this.getErrorMessage() == null) {
            AbstractFileTemplate template = this.getSelectedTemplate();
            template.setTemplateInfo(this.getFileInfo());
            PathCollector fileCollector = new PathCollector();
            template.generateFiles(fileCollector);
            for (CharSequence path : fileCollector.getResult()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path.toString()));
                if (!file.exists()) continue;
                this.setStatus((IStatus)new Status(4, "NewFileWizard", String.valueOf(Messages.NewFileWizardPrimaryPage_file_already_exist_pre) + path + Messages.NewFileWizardPrimaryPage_file_already_exist_post));
                return;
            }
        }
    }

    protected IContainer getFolder() {
        return this.getFolder(this.folderText.getText());
    }

    protected IContainer getFolder(String folderText) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path("/" + folderText));
        }
        catch (IllegalArgumentException e) {
            try {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(folderText);
            }
            catch (IllegalArgumentException e1) {
                return null;
            }
        }
    }

    @Override
    public void setStatus(IStatus status) {
        if (status == null || status.getSeverity() == 0) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setPageComplete(true);
        } else if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.getSeverity() == 2) {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), 2);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), 1);
            this.setPageComplete(true);
        }
    }

    public TemplateFileInfo getFileInfo() {
        return new TemplateFileInfo(this.getLocation(), this.getFileName(), this.getSelectedTemplate());
    }

    public String getLocation() {
        return this.folderText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public AbstractFileTemplate getSelectedTemplate() {
        if (this.templates.length == 1) {
            return this.templates[0];
        }
        ISelection selection = this.templateCombo.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (AbstractFileTemplate)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    private final class PathCollector
    implements IFileGenerator {
        private List<CharSequence> result = new ArrayList<CharSequence>();

        private PathCollector() {
        }

        @Override
        public void generate(CharSequence path, CharSequence content) {
            this.result.add(path);
        }

        public List<CharSequence> getResult() {
            return this.result;
        }
    }
}

