/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation.impl;

import java.util.Set;
import org.eclipse.xtext.validation.IAssignmentQuantityAllocator;
import org.eclipse.xtext.validation.IAssignmentQuantityIntervalProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxConstraintProvider;

public class AssignmentQuantityIntervalProvider
implements IAssignmentQuantityIntervalProvider {
    protected boolean containsUnavailableFeature(IAssignmentQuantityAllocator.IQuantities ctx, IConcreteSyntaxConstraintProvider.ISyntaxConstraint child, String exclude, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        if (child.isOptional()) {
            return false;
        }
        switch (child.getType()) {
            case ASSIGNMENT: {
                if (exclude.equals(child.getAssignmentName())) {
                    return false;
                }
                involved.add(child);
                return ctx.getAssignmentQuantity(child) == 0;
            }
            case GROUP: {
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : child.getContents()) {
                    if (!this.containsUnavailableFeature(ctx, a, exclude, involved)) continue;
                    return true;
                }
                return false;
            }
            case ALTERNATIVE: {
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : child.getContents()) {
                    if (this.containsUnavailableFeature(ctx, a, exclude, involved)) continue;
                    return false;
                }
                return true;
            }
            case ACTION: {
                if (child.getSemanticTypesToCheck() != null) {
                    return !child.getSemanticTypesToCheck().contains(ctx.getEObject().eClass());
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public int getMax(IAssignmentQuantityAllocator.IQuantities ctx, IConcreteSyntaxConstraintProvider.ISyntaxConstraint ass, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved, String excludeFeature) {
        int c = ass.isRoot() ? 1 : this.getMaxByParent(ctx, ass.getContainer(), ass, excludeFeature, involved);
        return ass.isMultiple() && c > 0 ? Integer.MAX_VALUE : c;
    }

    protected int getMaxByParent(IAssignmentQuantityAllocator.IQuantities ctx, IConcreteSyntaxConstraintProvider.ISyntaxConstraint ele, IConcreteSyntaxConstraintProvider.ISyntaxConstraint exclude, String excludeFeature, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> inv) {
        int max;
        int n = ele.isRoot() ? (ele.isMultiple() ? Integer.MAX_VALUE : 1) : (max = this.getMaxByParent(ctx, ele.getContainer(), ele, excludeFeature, inv));
        if (max == 0) {
            return 0;
        }
        switch (ele.getType()) {
            case GROUP: {
                if (ele.isMultiple()) {
                    max = Integer.MAX_VALUE;
                }
                if (ele.isOptional() || max == Integer.MAX_VALUE) {
                    for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : ele.getContents()) {
                        int count;
                        if (a == exclude || (count = this.getMaxForChild(ctx, a, inv)) == -1 || count >= max) continue;
                        max = count;
                    }
                }
                return max == 0 && !ele.isOptional() ? 1 : max;
            }
            case ALTERNATIVE: {
                if (ele.isMultiple()) {
                    return Integer.MAX_VALUE;
                }
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : ele.getContents()) {
                    int count;
                    if (!(a != exclude ? (count = this.getMinForChild(ctx, a, inv)) > 0 : excludeFeature != null && this.containsUnavailableFeature(ctx, a, excludeFeature, inv))) continue;
                    return 0;
                }
                return max;
            }
        }
        return 1;
    }

    protected int getMaxForChild(IAssignmentQuantityAllocator.IQuantities ctx, IConcreteSyntaxConstraintProvider.ISyntaxConstraint child, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        if (child.getSemanticTypesToCheck() != null && !child.getSemanticTypesToCheck().contains(ctx.getEObject().eClass())) {
            return 0;
        }
        if (child.isOptional()) {
            return Integer.MAX_VALUE;
        }
        switch (child.getType()) {
            case ASSIGNMENT: {
                involved.add(child);
                return ctx.getAssignmentQuantity(child);
            }
            case GROUP: {
                int count1 = Integer.MAX_VALUE;
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : child.getContents()) {
                    int c = this.getMaxForChild(ctx, a, involved);
                    if (c == -1 || c >= count1) continue;
                    count1 = c;
                }
                return count1;
            }
            case ALTERNATIVE: {
                int count2 = -1;
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : child.getContents()) {
                    int c = this.getMaxForChild(ctx, a, involved);
                    if (c == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    if (c == -1) continue;
                    int n = count2 = count2 == -1 ? c : count2 + c;
                }
                return count2;
            }
            case ACTION: {
                return Integer.MAX_VALUE;
            }
        }
        return -1;
    }

    @Override
    public int getMin(IAssignmentQuantityAllocator.IQuantities ctx, IConcreteSyntaxConstraintProvider.ISyntaxConstraint assignment, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        if (assignment.isOptional()) {
            return 0;
        }
        if (assignment.isRoot()) {
            return 1;
        }
        return this.getMinByParent(ctx, assignment.getContainer(), assignment, involved);
    }

    protected int getMinByParent(IAssignmentQuantityAllocator.IQuantities ctx, IConcreteSyntaxConstraintProvider.ISyntaxConstraint parent, IConcreteSyntaxConstraintProvider.ISyntaxConstraint exclude, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        switch (parent.getType()) {
            case GROUP: {
                if (parent.isRoot() && !parent.isOptional() && !parent.isMultiple()) {
                    return 1;
                }
                int count1 = -1;
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : parent.getContents()) {
                    int c;
                    if (a == exclude || (c = this.getMinForChild(ctx, a, involved)) <= count1) continue;
                    count1 = c;
                    break;
                }
                if (parent.isOptional()) {
                    return count1 == -1 ? 0 : count1;
                }
                if (!parent.isRoot()) {
                    return Math.max(this.getMinByParent(ctx, parent.getContainer(), parent, involved), count1);
                }
                return -1;
            }
            case ALTERNATIVE: {
                if (parent.isOptional()) {
                    return 0;
                }
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : parent.getContents()) {
                    int count2;
                    if (a == exclude || (count2 = this.getMinForChild(ctx, a, involved)) <= 0) continue;
                    return 0;
                }
                if (!parent.isRoot()) {
                    return this.getMinByParent(ctx, parent.getContainer(), parent, involved);
                }
                return 1;
            }
        }
        return -1;
    }

    protected int getMinForChild(IAssignmentQuantityAllocator.IQuantities ctx, IConcreteSyntaxConstraintProvider.ISyntaxConstraint child, Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> involved) {
        if (child.getSemanticTypesToCheck() != null && !child.getSemanticTypesToCheck().contains(ctx.getEObject().eClass())) {
            return 0;
        }
        int count = -1;
        switch (child.getType()) {
            case ASSIGNMENT: {
                involved.add(child);
                count = ctx.getAssignmentQuantity(child);
                break;
            }
            case GROUP: {
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : child.getContents()) {
                    int c = this.getMinForChild(ctx, a, involved);
                    if (c <= count) continue;
                    count = c;
                }
                break;
            }
            case ALTERNATIVE: {
                for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a : child.getContents()) {
                    int c = this.getMinForChild(ctx, a, involved);
                    int n = count = count == -1 ? c : c + count;
                }
                break;
            }
            case ACTION: {
                return 1;
            }
        }
        if (child.isMultiple() && count > 1) {
            count = 1;
        }
        return count;
    }
}

