/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class UnmapHandler
extends AbstractHandler {
    private final List<FBNetworkElement> selectedNetworkElements = new ArrayList<FBNetworkElement>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompoundCommand cmd = new CompoundCommand();
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        CommandStack stack = (CommandStack)editor.getAdapter(CommandStack.class);
        for (FBNetworkElement element : this.selectedNetworkElements) {
            UnmapCommand unmapCmd = new UnmapCommand(element);
            if (!unmapCmd.canExecute()) continue;
            cmd.add((Command)unmapCmd);
        }
        if (stack != null) {
            stack.execute((Command)cmd);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(!this.getMappedFBList(this.getSelectedElements(evaluationContext)).isEmpty());
    }

    protected List<?> getSelectedElements(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            return ((StructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    private List<FBNetworkElement> getMappedFBList(List<?> fbNetwork) {
        this.selectedNetworkElements.clear();
        for (Object element : fbNetwork) {
            if (element instanceof EditPart) {
                element = ((EditPart)element).getModel();
            }
            if (!(element instanceof FBNetworkElement)) continue;
            this.checkMapping((FBNetworkElement)element);
        }
        return this.selectedNetworkElements;
    }

    private void checkMapping(FBNetworkElement model) {
        if (model.isMapped()) {
            this.selectedNetworkElements.add(model);
        }
    }
}

