/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.export.AbstractExporter;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.ui.Messages;
import org.eclipse.fordiac.ide.export.ui.wizard.ExportStatusMessageDialog;
import org.eclipse.fordiac.ide.export.ui.wizard.SelectFBTypesWizardPage;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FordiacExportWizard
extends Wizard
implements IExportWizard {
    private static final String FORDIAC_EXPORT_SECTION = "4DIAC_EXPORT_SECTION";
    private IStructuredSelection selection;
    private SelectFBTypesWizardPage page;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        this.selection = new StructuredSelection(selectedResources);
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)bundle).getDialogSettings();
        if (settings.getSection(FORDIAC_EXPORT_SECTION) == null) {
            settings.addNewSection(FORDIAC_EXPORT_SECTION);
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(Messages.FordiacExportWizard_LABEL_Window_Title);
    }

    public void addPages() {
        super.addPages();
        this.page = new SelectFBTypesWizardPage(Messages.FordiacExportWizard_WizardPage, this.selection);
        this.page.setDescription(Messages.FordiacExportWizard_DESCRIPTION_WizardPage);
        this.page.setTitle(Messages.FordiacExportWizard_TITLE_WizardPage);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveWidgetValues();
        List<IFile> exportees = this.collectExportees();
        if (!IDE.saveAllEditors((IResource[])exportees.toArray(new IResource[exportees.size()]), (boolean)true)) {
            return false;
        }
        ExporterRunnable exporter = new ExporterRunnable(this.page.getSelectedExportFilter(), exportees, this.page.getDirectory(), this.page.overwriteWithoutWarning(), this.page.enableCMakeLists());
        try {
            this.setNeedsProgressMonitor(true);
            this.getContainer().run(true, true, (IRunnableWithProgress)exporter);
        }
        catch (Exception e) {
            FordiacExportWizard.showExceptionErrorDialog(e);
        }
        return true;
    }

    protected static void showExceptionErrorDialog(Exception e) {
        FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
        msg.setMessage(e.getMessage());
        msg.open();
    }

    private final List<IFile> collectExportees() {
        List<?> resources = this.page.getSelectedResources();
        return resources.parallelStream().filter(IFile.class::isInstance).map(IFile.class::cast).toList();
    }

    private static class ExporterRunnable
    extends AbstractExporter
    implements IRunnableWithProgress {
        private final List<IFile> exportees;

        protected ExporterRunnable(IConfigurationElement filterConfig, List<IFile> exportees, String outputDirectory, boolean overwriteWithoutWarning, boolean enableCMakeLists) {
            super(filterConfig, outputDirectory, overwriteWithoutWarning, enableCMakeLists);
            this.exportees = exportees;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.exportElements(monitor, this.exportees);
        }

        protected void showErrorWarningSummary(IExportFilter filter) {
            if (!filter.getErrors().isEmpty() || !filter.getWarnings().isEmpty()) {
                new ExportStatusMessageDialog(Display.getDefault().getActiveShell(), filter.getWarnings(), filter.getErrors()).open();
            }
        }

        protected void processError(String errorMessage) {
            FordiacLogHelper.logError((String)errorMessage);
            MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
            msg.setMessage(errorMessage);
            msg.open();
        }
    }
}

