/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils;

import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;

public class AcceleoLogger {
    public static void log(Exception e, boolean blocker) {
        if (e == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("AcceleoLogger.LogNullException"));
        }
        if (AcceleoLogger.getCommonPlugin() == null) {
            e.printStackTrace();
        } else if (e instanceof CoreException) {
            AcceleoLogger.log(((CoreException)((Object)e)).getStatus());
        } else if (e instanceof NullPointerException) {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoLogger.log((IStatus)new Status(severity, "org.eclipse.acceleo.common", severity, AcceleoCommonMessages.getString("AcceleoLogger.ElementNotFound"), (Throwable)e));
        } else {
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            AcceleoLogger.log((IStatus)new Status(severity, "org.eclipse.acceleo.common", severity, e.getMessage(), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        if (status == null) {
            throw new NullPointerException(AcceleoCommonMessages.getString("AcceleoLogger.LogNullStatus"));
        }
        if (AcceleoLogger.getCommonPlugin() != null) {
            AcceleoLogger.getCommonPlugin().getLog().log(status);
        } else {
            System.err.println(status.getMessage());
            status.getException().printStackTrace();
        }
    }

    public static void log(String message, boolean blocker) {
        if (AcceleoLogger.getCommonPlugin() == null) {
            System.err.println(message);
        } else {
            String errorMessage;
            int severity = 2;
            if (blocker) {
                severity = 4;
            }
            if ((errorMessage = message) == null || "".equals(errorMessage)) {
                errorMessage = AcceleoCommonMessages.getString("AcceleoLogger.UnexpectedException");
            }
            AcceleoLogger.log((IStatus)new Status(severity, "org.eclipse.acceleo.common", errorMessage));
        }
    }

    public static void log(String message, Exception cause, boolean blocker) {
        int severity = blocker ? 4 : 2;
        AcceleoLogger.log((IStatus)new Status(severity, "org.eclipse.acceleo.common", message, (Throwable)cause));
    }

    private static Plugin getCommonPlugin() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return AcceleoCommonPlugin.getDefault();
        }
        return null;
    }
}

