/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

public class AcceleoProcess
implements IProcess {
    private Map<String, String> attributes = new HashMap<String, String>();
    private boolean terminated;
    private final ILaunch launch;

    public AcceleoProcess(ILaunch launch) {
        this.launch = launch;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public String getLabel() {
        return AcceleoUIMessages.getString("AcceleoProcess.Label.Running");
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public boolean canTerminate() {
        return true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.terminated = true;
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
    }

    public Object getAdapter(Class adapter) {
        AcceleoProcess ret = null;
        if (adapter.equals(IProcess.class)) {
            ret = this;
        } else if (adapter.equals(IDebugTarget.class)) {
            ret = this.getLaunch().getDebugTarget();
        } else if (adapter.equals(ILaunch.class)) {
            ret = this.getLaunch();
        }
        return ret;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }
}

