/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import Real.Keyword;
import Real.RealPackage;
import Real.String;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nooperationreflection.NoOperationReflection;
import nooperationreflection.NooperationreflectionPackage;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.tests.anydsl.Food;
import org.eclipse.acceleo.query.tests.nestedpackages.root.RootEClass;
import org.eclipse.acceleo.query.tests.nestedpackages.root.RootFactory;
import org.eclipse.acceleo.query.tests.nestedpackages.root.RootPackage;
import org.eclipse.acceleo.query.tests.nestedpackages.root.child.ChildEClass;
import org.eclipse.acceleo.query.tests.nestedpackages.root.child.ChildFactory;
import org.eclipse.acceleo.query.tests.nestedpackages.root.child.ChildPackage;
import org.eclipse.acceleo.query.tests.nestedpackages.root.child.grand_child.GrandChildEClass;
import org.eclipse.acceleo.query.tests.nestedpackages.root.child.grand_child.Grand_childFactory;
import org.eclipse.acceleo.query.tests.nestedpackages.root.child.grand_child.Grand_childPackage;
import org.eclipse.acceleo.query.tests.services.EObjectServices;
import org.eclipse.acceleo.query.tests.services.ReceiverServices;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EvaluationTest {
    QueryEvaluationEngine engine;
    IQueryEnvironment queryEnvironment;
    IQueryBuilderEngine builder;

    @Before
    public void setup() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)RootPackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)NooperationreflectionPackage.eINSTANCE);
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, EObjectServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        this.engine = new QueryEvaluationEngine(this.queryEnvironment);
        this.builder = new QueryBuilderEngine();
    }

    @Test
    public void testNestedPackages() {
        RootFactory rootFactory = RootPackage.eINSTANCE.getRootFactory();
        RootEClass rootEClass = rootFactory.createRootEClass();
        ChildFactory childFactory = ChildPackage.eINSTANCE.getChildFactory();
        ChildEClass childEClass = childFactory.createChildEClass();
        Grand_childFactory grand_childFactory = Grand_childPackage.eINSTANCE.getGrand_childFactory();
        GrandChildEClass grandChildEClass = grand_childFactory.createGrandChildEClass();
        HashMap<java.lang.String, Object> variables = new HashMap<java.lang.String, Object>();
        variables.put("rootEClass", rootEClass);
        variables.put("childEClass", childEClass);
        variables.put("grandChildEClass", grandChildEClass);
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("rootEClass.oclIsKindOf(root::RootEClass)"), variables));
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("childEClass.oclIsKindOf(child::ChildEClass)"), variables));
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("grandChildEClass.oclIsKindOf(grand_child::GrandChildEClass)"), variables));
    }

    @Test
    public void variableTest() {
        HashMap<java.lang.String, Integer> variables = new HashMap<java.lang.String, Integer>();
        variables.put("x", 1);
        this.assertOKResultEquals(1, this.engine.eval(this.builder.build("x"), variables));
    }

    @Test
    public void featureAccessTest() {
        HashMap<java.lang.String, EcorePackage> variables = new HashMap<java.lang.String, EcorePackage>();
        variables.put("self", EcorePackage.eINSTANCE);
        this.assertOKResultEquals("ecore", this.engine.eval(this.builder.build("self.name"), variables));
    }

    @Test
    public void featureAccessNotExistingFeatureTest() {
        HashMap<java.lang.String, EcorePackage> variables = new HashMap<java.lang.String, EcorePackage>();
        variables.put("self", EcorePackage.eINSTANCE);
        EvaluationResult result = this.engine.eval(this.builder.build("self.notExistingFeature"), variables);
        Assert.assertEquals(null, (Object)result.getResult());
        Assert.assertEquals((long)2L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)result.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(0)).getSeverity());
        ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage().startsWith("aqlFeatureAccess");
        ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage().endsWith("Feature notExistingFeature not found in EClass EPackage");
    }

    @Test
    public void intliteralTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(2, this.engine.eval(this.builder.build("2"), variables));
    }

    @Test
    public void realliteralTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(1.0, this.engine.eval(this.builder.build("1.0"), variables));
    }

    @Test
    public void trueliteralTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("true"), variables));
    }

    @Test
    public void falseliteralTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(Boolean.FALSE, this.engine.eval(this.builder.build("false"), variables));
    }

    @Test
    public void stringliteralTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals("acceleo query is great", this.engine.eval(this.builder.build("'acceleo query is great'"), variables));
    }

    @Test
    public void lowerEqualTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("1<=2"), variables));
    }

    @Test
    public void lowerTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("1<2"), variables));
    }

    @Test
    public void greaterEqualTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(Boolean.FALSE, this.engine.eval(this.builder.build("1>=2"), variables));
    }

    @Test
    public void greaterTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(Boolean.FALSE, this.engine.eval(this.builder.build("1>2"), variables));
    }

    @Test
    public void addTest() {
        HashMap<java.lang.String, EcorePackage> variables = new HashMap<java.lang.String, EcorePackage>();
        variables.put("self", EcorePackage.eINSTANCE);
        this.assertOKResultEquals("ecore.ecore", this.engine.eval(this.builder.build("self.nsPrefix + '.' + self.name"), variables));
    }

    @Test
    public void orTest() {
        HashMap<java.lang.String, EcorePackage> variables = new HashMap<java.lang.String, EcorePackage>();
        variables.put("self", EcorePackage.eINSTANCE);
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("self.nsPrefix = 'ecore' or self.name='autrechose'"), variables));
    }

    @Test
    public void andTest() {
        HashMap<java.lang.String, EcorePackage> variables = new HashMap<java.lang.String, EcorePackage>();
        variables.put("self", EcorePackage.eINSTANCE);
        this.assertOKResultEquals(Boolean.FALSE, this.engine.eval(this.builder.build("self.nsPrefix = 'ecore' and self.name='autrechose'"), variables));
    }

    @Test
    public void notTest() {
        HashMap<java.lang.String, EcorePackage> variables = new HashMap<java.lang.String, EcorePackage>();
        variables.put("self", EcorePackage.eINSTANCE);
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("not (self.name='autrechose')"), variables));
    }

    @Test
    public void multTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(4, this.engine.eval(this.builder.build("2*2"), variables));
        this.assertOKResultEquals(4.0, this.engine.eval(this.builder.build("2.0*2.0"), variables));
    }

    @Test
    public void compComplexTest() {
        HashMap<java.lang.String, EcorePackage> variables = new HashMap<java.lang.String, EcorePackage>();
        variables.put("self", EcorePackage.eINSTANCE);
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("self.name.size()=self.nsPrefix.size()"), variables));
        this.assertOKResultEquals(Boolean.FALSE, this.engine.eval(this.builder.build("self.name.size()<self.nsPrefix.size()-1"), variables));
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("self.name.size()<self.nsPrefix.size()+1"), variables));
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("self.name.size()+2>self.nsPrefix.size()+1"), variables));
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("self.name.size()<=self.nsPrefix.size()+1"), variables));
        this.assertOKResultEquals(Boolean.TRUE, this.engine.eval(this.builder.build("self.name.size()>=self.nsPrefix.size()-1"), variables));
    }

    @Test
    public void minusTest() {
        HashMap<java.lang.String, EClass> variables = new HashMap<java.lang.String, EClass>();
        variables.put("self", EcorePackage.Literals.ECLASS);
        EvaluationResult result = this.engine.eval(this.builder.build("self.eAllSuperTypes->including(self)-self.eAllSuperTypes"), variables);
        Assert.assertTrue((boolean)(result.getResult() instanceof List));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        List listResult = (List)result.getResult();
        Assert.assertEquals((long)1L, (long)listResult.size());
        Assert.assertEquals((Object)EcorePackage.Literals.ECLASS, listResult.get(0));
    }

    @Test
    public void testSelect0() {
        java.lang.String expr = "self.oclAsType(ecore::EClass).eAllSuperTypes->select(e | e.oclIsKindOf(ecore::EClass))";
        HashMap<java.lang.String, EClass> variables = new HashMap<java.lang.String, EClass>();
        variables.put("self", EcorePackage.Literals.ECLASS);
        EvaluationResult result = this.engine.eval(this.builder.build(expr), variables);
        Assert.assertTrue((boolean)(result.getResult() instanceof List));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        List listResult = (List)result.getResult();
        Assert.assertTrue((boolean)listResult.contains(EcorePackage.Literals.ECLASSIFIER));
        Assert.assertTrue((boolean)listResult.contains(EcorePackage.Literals.ENAMED_ELEMENT));
        Assert.assertTrue((boolean)listResult.contains(EcorePackage.Literals.EMODEL_ELEMENT));
    }

    @Test
    public void nullTest() {
        HashMap variables = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build(null), variables);
        this.assertOKResultEquals(null, result);
    }

    @Test
    public void emtpyTest() {
        HashMap variables = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build(""), variables);
        this.assertOKResultEquals(null, result);
    }

    @Test
    public void nullLiteralTest() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(null, this.engine.eval(this.builder.build("null"), variables));
    }

    @Test
    public void serviceTest() {
        HashMap<java.lang.String, EClass> variables = new HashMap<java.lang.String, EClass>();
        variables.put("self", EcorePackage.eINSTANCE.getEClass());
        this.assertOKResultEquals(1, this.engine.eval(this.builder.build("self.someService('a')"), variables));
    }

    @Test
    public void eOperationTest() {
        HashMap<java.lang.String, Food> variables = new HashMap<java.lang.String, Food>();
        Food self = AnydslPackage.eINSTANCE.getAnydslFactory().createFood();
        variables.put("self", self);
        this.assertOKResultEquals("text", this.engine.eval(this.builder.build("self.preferredLabel('text')"), variables));
    }

    @Test
    public void eOperationEObjectParameterTest() {
        HashMap<java.lang.String, Food> variables = new HashMap<java.lang.String, Food>();
        Food self = AnydslPackage.eINSTANCE.getAnydslFactory().createFood();
        self.setName("self berry");
        Food other = AnydslPackage.eINSTANCE.getAnydslFactory().createFood();
        other.setName("other berry");
        variables.put("self", self);
        variables.put("other", other);
        this.assertOKResultEquals(true, this.engine.eval(this.builder.build("self.identity(other) == other"), variables));
    }

    @Test
    public void eOperationNoReflectionTest() {
        HashMap<java.lang.String, NoOperationReflection> variables = new HashMap<java.lang.String, NoOperationReflection>();
        NoOperationReflection self = NooperationreflectionPackage.eINSTANCE.getNooperationreflectionFactory().createNoOperationReflection();
        variables.put("self", self);
        this.assertOKResultEquals("text", this.engine.eval(this.builder.build("self.eOperationNoReflection('text')"), variables));
    }

    @Test
    public void eOperationNoReflectionSubParameterTypeTest() {
        HashMap<java.lang.String, NoOperationReflection> variables = new HashMap<java.lang.String, NoOperationReflection>();
        NoOperationReflection self = NooperationreflectionPackage.eINSTANCE.getNooperationreflectionFactory().createNoOperationReflection();
        variables.put("self", self);
        this.assertOKResultEquals("EClass", this.engine.eval(this.builder.build("self.eOperationNoReflectionSubParameterType(ecore::EClass)"), variables));
    }

    @Test
    public void eOperationNoReflectionListParameterTest() {
        HashMap<java.lang.String, NoOperationReflection> variables = new HashMap<java.lang.String, NoOperationReflection>();
        NoOperationReflection self = NooperationreflectionPackage.eINSTANCE.getNooperationreflectionFactory().createNoOperationReflection();
        variables.put("self", self);
        this.assertOKResultEquals("EClassEOperation", this.engine.eval(this.builder.build("self.eOperationNoReflectionListParameter(Sequence{ecore::EClass, ecore::EOperation})"), variables));
    }

    @Test
    public void eOperationNoReflectionEObjectParameterTest() {
        HashMap<java.lang.String, NoOperationReflection> variables = new HashMap<java.lang.String, NoOperationReflection>();
        NoOperationReflection self = NooperationreflectionPackage.eINSTANCE.getNooperationreflectionFactory().createNoOperationReflection();
        NoOperationReflection other = NooperationreflectionPackage.eINSTANCE.getNooperationreflectionFactory().createNoOperationReflection();
        variables.put("self", self);
        variables.put("other", other);
        this.assertOKResultEquals(true, this.engine.eval(this.builder.build("self.identity(other) == other"), variables));
    }

    @Test
    public void serviceNullParameterTest() {
        HashMap<java.lang.String, EClass> variables = new HashMap<java.lang.String, EClass>();
        variables.put("self", EcorePackage.eINSTANCE.getEClass());
        this.assertOKResultEquals(1, this.engine.eval(this.builder.build("self.someService(null)"), variables));
    }

    @Test
    public void enumLiteralOrEClassifierTwoSegmentsEClassifier() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(EcorePackage.eINSTANCE.getEClass(), this.engine.eval(this.builder.build("ecore::EClass"), variables));
    }

    @Test
    public void enumLiteralOrEClassifierThreeSegments() {
        HashMap variables = new HashMap();
        this.assertOKResultEquals(AnydslPackage.eINSTANCE.getPart().getEEnumLiteral("Other").getInstance(), this.engine.eval(this.builder.build("anydsl::Part::Other"), variables));
    }

    @Test
    public void enumLiteralNotExisting() {
        HashMap variables = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build("anydsl::Part::NotExisting"), variables);
        Assert.assertEquals((long)4L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)result.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(0)).getSeverity());
        java.lang.String message = ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage();
        Assert.assertEquals((Object)"Invalid enum literal.", (Object)message);
        Assert.assertNull((Object)result.getResult());
    }

    @Test
    public void testSetInExtensionLiteral() {
        HashMap<java.lang.String, EClass> varDefinitions = new HashMap<java.lang.String, EClass>();
        varDefinitions.put("self", EcorePackage.Literals.ECLASS);
        EvaluationResult result = this.engine.eval(this.builder.build("OrderedSet{self, self, true, false}"), varDefinitions);
        Assert.assertTrue((boolean)(result.getResult() instanceof Set));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        Set setResult = (Set)result.getResult();
        Assert.assertEquals((long)3L, (long)setResult.size());
        Iterator it = setResult.iterator();
        Assert.assertEquals((Object)EcorePackage.Literals.ECLASS, it.next());
        Assert.assertEquals((Object)Boolean.TRUE, it.next());
        Assert.assertEquals((Object)Boolean.FALSE, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSequenceInExtensionLiteral() {
        HashMap<java.lang.String, EClass> varDefinitions = new HashMap<java.lang.String, EClass>();
        varDefinitions.put("self", EcorePackage.Literals.ECLASS);
        EvaluationResult result = this.engine.eval(this.builder.build("Sequence{self, self, true, false}"), varDefinitions);
        Assert.assertTrue((boolean)(result.getResult() instanceof List));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        List listResult = (List)result.getResult();
        Assert.assertEquals((long)4L, (long)listResult.size());
        Iterator it = listResult.iterator();
        Assert.assertEquals((Object)EcorePackage.Literals.ECLASS, it.next());
        Assert.assertEquals((Object)EcorePackage.Literals.ECLASS, it.next());
        Assert.assertEquals((Object)Boolean.TRUE, it.next());
        Assert.assertEquals((Object)Boolean.FALSE, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testVariableUsedInLambda() {
        HashMap<java.lang.String, java.lang.String> varDefinitions = new HashMap<java.lang.String, java.lang.String>();
        varDefinitions.put("selector", "str");
        EvaluationResult result = this.engine.eval(this.builder.build("Sequence{'str1','str2','out'}->select(i | i.startsWith(selector))"), varDefinitions);
        Assert.assertTrue((boolean)(result.getResult() instanceof List));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        List listResult = (List)result.getResult();
        Assert.assertEquals((long)2L, (long)listResult.size());
        Assert.assertEquals((Object)"str1", listResult.get(0));
        Assert.assertEquals((Object)"str2", listResult.get(1));
    }

    @Test
    public void testConditionnalTrue() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals("trueBranch", this.engine.eval(this.builder.build("if true then 'trueBranch' else 'falseBranch' endif"), varDefinitions));
    }

    @Test
    public void testConditionnalFalse() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals("falseBranch", this.engine.eval(this.builder.build("if false then 'trueBranch' else 'falseBranch' endif"), varDefinitions));
    }

    @Test
    public void testConditionnalCompletePredicate() {
        HashMap<java.lang.String, Integer> varDefinitions = new HashMap<java.lang.String, Integer>();
        varDefinitions.put("x", 1);
        this.assertOKResultEquals("trueBranch", this.engine.eval(this.builder.build("if x > 0 then 'trueBranch' else 'falseBranch' endif"), varDefinitions));
        varDefinitions.put("x", 0);
        this.assertOKResultEquals("falseBranch", this.engine.eval(this.builder.build("if x > 0 then 'trueBranch' else 'falseBranch' endif"), varDefinitions));
    }

    @Test
    public void testConditionnalNotBoolean() {
        HashMap varDefinitions = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build("if 'notboolean' then 'trueBranch' else 'falseBranch' endif"), varDefinitions);
        Assert.assertEquals(null, (Object)result.getResult());
        Assert.assertEquals((long)2L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)result.getDiagnostic().getChildren().size());
        java.lang.String message = ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage();
        Assert.assertTrue((boolean)message.contains("Conditional"));
        Assert.assertTrue((boolean)message.contains("boolean"));
        Assert.assertTrue((boolean)message.contains("notboolean"));
    }

    @Test
    public void testLetOneDefinition() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals("prefixsuffix", this.engine.eval(this.builder.build("let x='prefix' in x.concat('suffix')"), varDefinitions));
    }

    @Test
    public void testLetBasic() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals("prefixsuffix", this.engine.eval(this.builder.build("let x='prefix', y='suffix' in x.concat(y)"), varDefinitions));
    }

    @Test
    public void testNotRecursiveLet() {
        HashMap<java.lang.String, java.lang.String> varDefinitions = new HashMap<java.lang.String, java.lang.String>();
        varDefinitions.put("x", "suffix");
        this.assertOKResultEquals("prefixsuffix", this.engine.eval(this.builder.build("let x='prefix', y=x in x.concat(y)"), varDefinitions));
    }

    @Test
    public void letWithUnusedNothingBoundTest() {
        HashMap varDefinitions = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build("let x='prefix', y=x, z='suffix' in x.concat(z)"), varDefinitions);
        Assert.assertEquals((long)4L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)result.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(0)).getSeverity());
        java.lang.String message = ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage();
        Assert.assertTrue((boolean)message.contains("Couldn't find the 'x' variable"));
        Assert.assertEquals((Object)"prefixsuffix", (Object)result.getResult());
    }

    @Test
    public void letWithNothingBoundTest() {
        HashMap varDefinitions = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build("let x='prefix', y=x, z='suffix' in x.concat(z).concat(y)"), varDefinitions);
        Assert.assertEquals((long)4L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)result.getDiagnostic().getChildren().size());
        java.lang.String message1 = ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage();
        Assert.assertEquals((long)4L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertTrue((boolean)message1.contains("Couldn't find the 'x' variable"));
        Assert.assertEquals((long)2L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(1)).getSeverity());
        java.lang.String message2 = ((Diagnostic)result.getDiagnostic().getChildren().get(1)).getMessage();
        Assert.assertTrue((boolean)message2.contains("Couldn't find the 'concat"));
        Assert.assertEquals(null, (Object)result.getResult());
    }

    @Test
    public void letWithAffixNotation() {
        HashMap<java.lang.String, java.lang.String> varDefinitions = new HashMap<java.lang.String, java.lang.String>();
        varDefinitions.put("x", "suffix");
        this.assertOKResultEquals("prefixsuffix", this.engine.eval(this.builder.build("let x='prefix', y='suffix' in x+y"), varDefinitions));
    }

    @Test
    public void typeSetLiteral() {
        HashMap varDefinitions = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build("{ecore::EClass | ecore::EPackage | ecore::EAttribute}"), varDefinitions);
        Assert.assertTrue((boolean)(result.getResult() instanceof Set));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        Set listResult = (Set)result.getResult();
        Assert.assertEquals((long)3L, (long)listResult.size());
        Iterator it = listResult.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), it.next());
    }

    @Test
    public void callEObjectMethod() {
        EPackage pack = EcoreFactory.eINSTANCE.createEPackage();
        EClass class1 = EcoreFactory.eINSTANCE.createEClass();
        EClass class2 = EcoreFactory.eINSTANCE.createEClass();
        pack.getEClassifiers().add((Object)class1);
        pack.getEClassifiers().add((Object)class2);
        HashMap<java.lang.String, EPackage> variables = new HashMap<java.lang.String, EPackage>();
        variables.put("self", pack);
        EvaluationResult result = this.engine.eval(this.builder.build("self.oclAsType(ecore::EObject).eCrossReferences()"), variables);
        Assert.assertEquals((Object)pack.eCrossReferences(), (Object)result.getResult());
    }

    @Test
    public void isKindOfEObject() {
        EPackage pack = EcoreFactory.eINSTANCE.createEPackage();
        HashMap<java.lang.String, EPackage> variables = new HashMap<java.lang.String, EPackage>();
        variables.put("self", pack);
        EvaluationResult result = this.engine.eval(this.builder.build("self.oclIsKindOf(ecore::EObject)"), variables);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result.getResult());
    }

    @Test
    public void sequenceToString_480753() {
        HashMap variables = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build("Sequence{'hello','world'}->toString()"), variables);
        Assert.assertEquals((Object)"helloworld", (Object)result.getResult());
    }

    @Test
    public void setToString_480753() {
        HashMap variables = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build("OrderedSet{'hello','world'}->toString()"), variables);
        Assert.assertEquals((Object)"helloworld", (Object)result.getResult());
    }

    @Test
    public void eOperationWithNothingParameter_487245() {
        EPackage pack = EcoreFactory.eINSTANCE.createEPackage();
        HashMap<java.lang.String, EPackage> variables = new HashMap<java.lang.String, EPackage>();
        variables.put("self", pack);
        EvaluationResult result = this.engine.eval(this.builder.build("self.eGet(notExisting)"), variables);
        Assert.assertEquals(null, (Object)result.getResult());
        Assert.assertEquals((long)4L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)result.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Couldn't find the 'notExisting' variable", (Object)((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Couldn't find the 'eGet(EClassifier=EPackage,org.eclipse.acceleo.query.runtime.impl.Nothing)' service", (Object)((Diagnostic)result.getDiagnostic().getChildren().get(1)).getMessage());
    }

    private void assertOKResultEquals(Object expected, EvaluationResult result) {
        Assert.assertEquals((Object)expected, (Object)result.getResult());
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
    }

    @Test
    public void emoji() {
        HashMap variables = new HashMap();
        EvaluationResult result = this.engine.eval(this.builder.build("Sequence{'\u1f61C','\u1f62D','\u1f63D','\u1f1eB\u1f1f7'}->sep(' ')->toString()"), variables);
        Assert.assertEquals((Object)"\u1f61C \u1f62D \u1f63D \u1f1eB\u1f1f7", (Object)result.getResult());
    }

    @Test
    public void javaMethodReceiverServiceNoArg() {
        HashMap<java.lang.String, ReceiverServices> variables = new HashMap<java.lang.String, ReceiverServices>();
        variables.put("self", new ReceiverServices());
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)ServiceUtils.getReceiverServices((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        EvaluationResult result = this.engine.eval(this.builder.build("self.noArg()"), variables);
        Assert.assertEquals((Object)"noArgResult", (Object)result.getResult());
    }

    @Test
    public void javaMethodReceiverServiceArg() {
        HashMap<java.lang.String, ReceiverServices> variables = new HashMap<java.lang.String, ReceiverServices>();
        variables.put("self", new ReceiverServices());
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)ServiceUtils.getReceiverServices((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        EvaluationResult result = this.engine.eval(this.builder.build("self.arg('arg')"), variables);
        Assert.assertEquals((Object)"argResultarg", (Object)result.getResult());
    }

    @Test
    public void eClassifierWithKeyword() {
        HashMap variables = new HashMap();
        this.queryEnvironment.registerEPackage((EPackage)RealPackage.eINSTANCE);
        EvaluationResult result = this.engine.eval(this.builder.build("_Real::_String"), variables);
        this.queryEnvironment.removeEPackage((EPackage)RealPackage.eINSTANCE);
        Assert.assertEquals((Object)RealPackage.eINSTANCE.getString(), (Object)result.getResult());
    }

    @Test
    public void eEnumLiteralWithKeyword() {
        HashMap variables = new HashMap();
        this.queryEnvironment.registerEPackage((EPackage)RealPackage.eINSTANCE);
        EvaluationResult result = this.engine.eval(this.builder.build("_Real::_String::_Integer"), variables);
        this.queryEnvironment.removeEPackage((EPackage)RealPackage.eINSTANCE);
        Assert.assertEquals((Object)((Object)String.INTEGER), (Object)result.getResult());
    }

    @Test
    public void eAttributeWithKeyword() {
        HashMap<java.lang.String, Keyword> variables = new HashMap<java.lang.String, Keyword>();
        Keyword self = RealPackage.eINSTANCE.getRealFactory().createKeyword();
        self.setIsUnique("is unique value");
        variables.put("self", self);
        this.queryEnvironment.registerEPackage((EPackage)RealPackage.eINSTANCE);
        EvaluationResult result = this.engine.eval(this.builder.build("self._isUnique"), variables);
        this.queryEnvironment.removeEPackage((EPackage)RealPackage.eINSTANCE);
        Assert.assertEquals((Object)"is unique value", (Object)result.getResult());
    }

    @Test
    public void eOperationWithKeyword() {
        HashMap<java.lang.String, Keyword> variables = new HashMap<java.lang.String, Keyword>();
        Keyword self = RealPackage.eINSTANCE.getRealFactory().createKeyword();
        variables.put("self", self);
        this.queryEnvironment.registerEPackage((EPackage)RealPackage.eINSTANCE);
        EvaluationResult result = this.engine.eval(this.builder.build("self._select()"), variables);
        this.queryEnvironment.removeEPackage((EPackage)RealPackage.eINSTANCE);
        Assert.assertEquals((Object)"Select EOperation called successfully", (Object)result.getResult());
    }
}

