/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.cdo.services.configurator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.cdo.AqlCDOUtils;
import org.eclipse.acceleo.query.cdo.providers.configuration.AqlCDOURIHandler;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.services.configurator.IResourceSetConfigurator;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.connector.IConnector;

public class CDOResourceSetConfigurator
implements IResourceSetConfigurator {
    public static final List<String> OPTIONS = CDOResourceSetConfigurator.initOptions();
    private Map<Object, IConnector> connectors = new HashMap<Object, IConnector>();
    private Map<Object, CDOTransaction> transactions = new HashMap<Object, CDOTransaction>();

    private static List<String> initOptions() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("CDOServer");
        res.add("CDORepository");
        res.add("CDOBranch");
        res.add("CDOLogin");
        res.add("CDOPassword");
        return res;
    }

    public List<String> getOptions() {
        return OPTIONS;
    }

    public Map<String, String> getInitializedOptions(Map<String, String> options) {
        return Collections.emptyMap();
    }

    public Map<String, List<Diagnostic>> validate(IReadOnlyQueryEnvironment queryEnvironment, Map<String, String> options) {
        return Collections.emptyMap();
    }

    public ResourceSet createResourceSetForModels(Object context, Map<String, String> options) {
        ResourceSet res;
        String cdoServer = options.get("CDOServer");
        if (cdoServer != null) {
            String repository = options.get("CDORepository");
            String branch = options.get("CDOBranch");
            String login = options.get("CDOLogin");
            String password = options.get("CDOPassword");
            IConnector connector = AqlCDOUtils.getConnector(cdoServer);
            this.connectors.put(context, connector);
            CDOSession session = AqlCDOUtils.openSession(connector, repository, login, password);
            CDOTransaction transaction = AqlCDOUtils.openTransaction(session, branch);
            this.transactions.put(context, transaction);
            res = transaction.getResourceSet();
            res.getURIConverter().getURIHandlers().add(0, (Object)new AqlCDOURIHandler((InternalCDOView)transaction));
        } else {
            res = null;
        }
        return res;
    }

    public void cleanResourceSetForModels(Object context) {
        CDOTransaction transaction = this.transactions.get(context);
        if (transaction != null) {
            CDOSession session = transaction.getSession();
            transaction.close();
            session.close();
            this.connectors.remove(context).close();
        }
    }
}

