/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.declaration;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class AcceleoLSBasedHyperlink
implements IHyperlink {
    private static final String DASH_SEPARATOR = " - ";
    private final Either<Location, LocationLink> location;
    private final IRegion highlightRegion;

    public AcceleoLSBasedHyperlink(Either<Location, LocationLink> location, IRegion highlightRegion) {
        this.location = location;
        this.highlightRegion = highlightRegion;
    }

    public AcceleoLSBasedHyperlink(Location location, IRegion linkRegion) {
        this((Either<Location, LocationLink>)Either.forLeft((Object)location), linkRegion);
    }

    public AcceleoLSBasedHyperlink(LocationLink locationLink, IRegion linkRegion) {
        this((Either<Location, LocationLink>)Either.forRight((Object)locationLink), linkRegion);
    }

    public IRegion getHyperlinkRegion() {
        return this.highlightRegion;
    }

    public String getTypeLabel() {
        return this.getLabel();
    }

    public String getHyperlinkText() {
        return this.getLabel();
    }

    public Either<Location, LocationLink> getLocation() {
        return this.location;
    }

    public void open() {
        if (this.location.isLeft()) {
            LSPEclipseUtils.openInEditor((Location)((Location)this.location.getLeft()));
        } else {
            LSPEclipseUtils.openInEditor((LocationLink)((LocationLink)this.location.getRight()));
        }
    }

    private String getLabel() {
        if (this.location != null) {
            String uri;
            String string = uri = this.location.isLeft() ? ((Location)this.location.getLeft()).getUri() : ((LocationLink)this.location.getRight()).getTargetUri();
            if (uri != null) {
                if (uri.startsWith("file://") && uri.length() > "file://".length()) {
                    Range range = this.location.isLeft() ? ((Location)this.location.getLeft()).getRange() : ((LocationLink)this.location.getRight()).getTargetSelectionRange();
                    int line = -1;
                    if (range != null && range.getStart() != null) {
                        line = range.getStart().getLine();
                    }
                    return this.getFileBasedLabel(uri, line);
                }
                return this.getGenericUriBasedLabel(uri);
            }
        }
        return "";
    }

    private String getGenericUriBasedLabel(String uri) {
        return uri;
    }

    private String getFileBasedLabel(String uriStr, int line) {
        URI uri = URI.create(uriStr);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(uri);
        if (files != null && files.length == 1 && files[0].getProject() != null) {
            IFile file = files[0];
            String lineContent = AcceleoLSBasedHyperlink.getLineContent(line, file);
            if (lineContent != null) {
                return lineContent;
            }
            IPath containerPath = file.getParent().getProjectRelativePath();
            return file.getName() + DASH_SEPARATOR + file.getProject().getName() + (String)(containerPath.isEmpty() ? "" : "/" + containerPath.toString());
        }
        Path path = Paths.get(uri);
        return String.valueOf(path.getFileName()) + (String)(path.getParent() == null || path.getParent().getParent() == null ? "" : DASH_SEPARATOR + path.toString());
    }

    public static String getLineContent(int line, @NonNull IFile file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = file.getContents();){
                String content = new String(is.readNBytes((int)file.getLocation().toFile().length()), Charset.forName(file.getCharset()));
                Document document = new Document(content);
                int offset = document.getLineOffset(line);
                int length = document.getLineLength(line);
                return document.get(offset, length).trim();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return null;
        }
    }
}

