/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.outline;

import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.outline.AcceleoSymbol;
import org.eclipse.acceleo.aql.validation.AcceleoValidationUtils;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.util.AcceleoSwitch;

public class AcceleoAstOutliner
extends AcceleoSwitch<AcceleoSymbol> {
    private final IAcceleoValidationResult acceleoValidationResult;

    public AcceleoAstOutliner(IAcceleoValidationResult acceleoValidationResult) {
        this.acceleoValidationResult = acceleoValidationResult;
    }

    private AcceleoSymbol createSymbol(ASTNode semanticElement, String symbolName, String symbolDetails) {
        return new AcceleoSymbol(semanticElement, this.acceleoValidationResult, symbolName, symbolDetails);
    }

    @Override
    public AcceleoSymbol caseMetamodel(Metamodel metamodel) {
        String details = metamodel.getReferencedPackage().getNsURI();
        return this.createSymbol(metamodel, metamodel.getReferencedPackage().getName(), details);
    }

    @Override
    public AcceleoSymbol caseQuery(Query query) {
        AcceleoSymbol res;
        String symbolName = query.getName();
        if (!query.getParameters().isEmpty()) {
            symbolName = String.valueOf(symbolName) + "(";
            symbolName = String.valueOf(symbolName) + AcceleoValidationUtils.getVariablesListRepresentation(query.getParameters(), this.acceleoValidationResult);
            symbolName = String.valueOf(symbolName) + ")";
        }
        String symbolDetails = AcceleoValidationUtils.getPossibleTypesRepresentation(query, this.acceleoValidationResult);
        if (symbolName != null) {
            AcceleoSymbol symbolForQuery = this.createSymbol(query, symbolName, symbolDetails);
            for (Variable parameter : query.getParameters()) {
                AcceleoSymbol symbolForParameter = (AcceleoSymbol)this.doSwitch(parameter);
                symbolForQuery.getChildren().add(symbolForParameter);
            }
            res = symbolForQuery;
        } else {
            res = null;
        }
        return res;
    }

    @Override
    public AcceleoSymbol caseVariable(Variable variable) {
        String symbolName = variable.getName();
        String symbolDetails = AcceleoValidationUtils.getPossibleTypesRepresentation(variable, this.acceleoValidationResult);
        AcceleoSymbol symbolForVariable = this.createSymbol(variable, symbolName, symbolDetails);
        return symbolForVariable;
    }

    @Override
    public AcceleoSymbol caseTemplate(Template template) {
        AcceleoSymbol res;
        String symbolName = template.getName();
        if (!template.getParameters().isEmpty()) {
            symbolName = String.valueOf(symbolName) + "(";
            symbolName = String.valueOf(symbolName) + AcceleoValidationUtils.getVariablesListRepresentation(template.getParameters(), this.acceleoValidationResult);
            symbolName = String.valueOf(symbolName) + ")";
        }
        String symbolDetails = "String";
        if (symbolName != null) {
            AcceleoSymbol symbolForTemplate = this.createSymbol(template, symbolName, symbolDetails);
            for (Variable parameter : template.getParameters()) {
                AcceleoSymbol symbolForParameter = (AcceleoSymbol)this.doSwitch(parameter);
                symbolForTemplate.getChildren().add(symbolForParameter);
            }
            res = symbolForTemplate;
        } else {
            res = null;
        }
        return res;
    }
}

