/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.standalone;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.migration.MigrationException;
import org.eclipse.acceleo.aql.migration.ModuleMigrator;
import org.eclipse.acceleo.aql.migration.standalone.StandaloneModuleResolver;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;

public final class StandaloneMigrator {
    private static final String BIN_FOLDER_NAME = "bin";
    private static final String MTL_FILE_EXTENSION = ".mtl";
    private static final String EMTL_FILE_EXTENSION = ".emtl";
    private static final String USAGE = "arguments: <acceleo3_source_folder> <acceleo4_target>. To keep module documentation, put the acceleo3 mtl file aside the .emtl file";
    private Path sourceFolderPath;
    private Path targetFolderPath;
    private Path binFolderPath;

    public StandaloneMigrator(Path sourceFolderPath, Path binFolderPath, Path targetFolderPath) {
        this.sourceFolderPath = sourceFolderPath;
        this.targetFolderPath = targetFolderPath;
        this.binFolderPath = binFolderPath == null ? sourceFolderPath.getParent().resolve(BIN_FOLDER_NAME) : binFolderPath;
    }

    public void migrateAll() throws IOException {
        Iterator iterator = Files.walk(this.sourceFolderPath, new FileVisitOption[0]).filter(p -> !p.getFileName().toString().endsWith(MTL_FILE_EXTENSION)).iterator();
        while (iterator.hasNext()) {
            Path javaPath = (Path)iterator.next();
            Path relativeJavaPath = this.sourceFolderPath.relativize(javaPath.toAbsolutePath());
            Path javaTargetPath = this.targetFolderPath.resolve(relativeJavaPath);
            File javaFile = javaPath.toFile();
            File javaTargetFile = javaTargetPath.toFile();
            if (!javaFile.exists() || javaFile.isDirectory()) continue;
            javaTargetFile.getParentFile().mkdirs();
            Files.copy(javaFile.toPath(), javaTargetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Copied " + javaFile.getAbsolutePath());
        }
        iterator = Files.walk(this.sourceFolderPath, new FileVisitOption[0]).filter(p -> p.getFileName().toString().endsWith(MTL_FILE_EXTENSION)).iterator();
        while (iterator.hasNext()) {
            Path mtlFile = (Path)iterator.next();
            this.migrate(mtlFile);
        }
    }

    public void migrate(Path mtlFile) throws IOException {
        String relativePath = this.sourceFolderPath.relativize(mtlFile).toString();
        Path targetMtlFile = this.targetFolderPath.resolve(relativePath);
        File emtlFile = this.binFolderPath.resolve(relativePath.replaceAll(MTL_FILE_EXTENSION, EMTL_FILE_EXTENSION)).toFile();
        if (emtlFile.exists()) {
            try {
                Module module = new ModuleMigrator(new StandaloneModuleResolver(this.binFolderPath), this.targetFolderPath).migrate(emtlFile, mtlFile.toFile());
                String a4Content = new AcceleoAstSerializer().serialize((AcceleoASTNode)module);
                Files.deleteIfExists(targetMtlFile);
                Files.createDirectories(targetMtlFile.getParent(), new FileAttribute[0]);
                targetMtlFile.toFile().createNewFile();
                Files.write(targetMtlFile, a4Content.getBytes(), new OpenOption[0]);
                System.out.println("Migrated " + mtlFile);
            }
            catch (MigrationException e) {
                System.err.println("Error migrating " + mtlFile + ": " + e.getMessage());
            }
        } else {
            System.err.println("EMTL file not found: " + emtlFile);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println(USAGE);
        } else {
            Path sourceFolderPath = Paths.get(args[0], new String[0]);
            Path targetFolderPath = Paths.get(args[1], new String[0]);
            new StandaloneMigrator(sourceFolderPath, null, targetFolderPath).migrateAll();
        }
    }
}

