/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.textdocument;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.ls.common.LocationUtils;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocumentService;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoProject;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.validation.AcceleoValidator;
import org.eclipse.acceleo.aql.validation.DeclarationSwitch;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Declaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.ECrossReferenceAdapterCrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.impl.ResourceSetRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.ISourceLocation;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;

public class AcceleoTextDocument {
    private static final String VALIDATION_NAMESPACE = "_reserved_::to::validate";
    private final URI uri;
    private AcceleoProject ownerProject;
    private IQualifiedNameQueryEnvironment queryEnvironment;
    private String contents;
    private AcceleoAstResult acceleoAstResult;
    private IAcceleoValidationResult acceleoValidationResult;
    private String qualifiedName;
    private boolean isOpened;

    public AcceleoTextDocument(URI textDocumentUri, String textDocumentContents, AcceleoProject project) {
        Objects.requireNonNull(textDocumentUri);
        Objects.requireNonNull(textDocumentContents);
        this.ownerProject = project;
        this.uri = textDocumentUri;
        this.qualifiedName = this.getProject().getResolver().getQualifiedName(this.getUri());
        this.setContents(textDocumentContents);
    }

    private void documentChanged() {
        this.parseContents();
        this.validateAndPublishResults();
    }

    public void documentSaved() {
        if (this.getProject() != null) {
            this.getProject().documentSaved(this);
        }
    }

    public void setProject(AcceleoProject acceleoProject) {
        AcceleoProject oldProject = this.ownerProject;
        this.ownerProject = acceleoProject;
        this.qualifiedName = this.getProject().getResolver().getQualifiedName(this.getUri());
        if (acceleoProject == null && oldProject != null || !acceleoProject.equals(oldProject)) {
            this.resolverChanged();
        }
    }

    public void resolverChanged() {
        this.documentChanged();
    }

    public AcceleoProject getProject() {
        return this.ownerProject;
    }

    public String getFileNameWithoutExtension() {
        return this.uri.toString().substring(this.uri.toString().lastIndexOf(47), this.uri.toString().lastIndexOf(46));
    }

    private void parseContents() {
        AcceleoAstResult parsingResult = null;
        parsingResult = this.doParsing(this.getModuleQualifiedName(), this.contents);
        ResourceSetImpl resourceSetForModels = new ResourceSetImpl();
        ECrossReferenceAdapterCrossReferenceProvider crossReferenceProvider = new ECrossReferenceAdapterCrossReferenceProvider(ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSetForModels));
        ResourceSetRootEObjectProvider rootProvider = new ResourceSetRootEObjectProvider((ResourceSet)resourceSetForModels);
        this.queryEnvironment = Query.newQualifiedNameEnvironmentWithDefaultServices((IQualifiedNameResolver)this.getProject().getResolver(), (CrossReferenceProvider)crossReferenceProvider, (IRootEObjectProvider)rootProvider);
        for (Metamodel metamodel : parsingResult.getModule().getMetamodels()) {
            if (metamodel.getReferencedPackage() == null) continue;
            this.queryEnvironment.registerEPackage(metamodel.getReferencedPackage());
        }
        this.acceleoAstResult = parsingResult;
    }

    private AcceleoAstResult doParsing(String moduleQualifiedName, String documentContents) {
        AcceleoAstResult res;
        if (this.isOpened()) {
            Objects.requireNonNull(moduleQualifiedName);
            Objects.requireNonNull(documentContents);
            AcceleoParser acceleoParser = new AcceleoParser();
            res = acceleoParser.parse(documentContents, moduleQualifiedName);
        } else {
            res = ((Module)this.ownerProject.getResolver().resolve(moduleQualifiedName)).getAst();
        }
        return res;
    }

    public void validateContents() {
        IAcceleoValidationResult validationResults = null;
        if (this.acceleoAstResult != null && this.getQueryEnvironment() != null) {
            validationResults = AcceleoTextDocument.doValidation(this.acceleoAstResult, this.getQueryEnvironment(), this.getModuleQualifiedName());
        }
        this.acceleoValidationResult = validationResults;
    }

    private static IAcceleoValidationResult doValidation(AcceleoAstResult acceleoAstResult, IQualifiedNameQueryEnvironment queryEnvironment, String qualifiedName) {
        Objects.requireNonNull(acceleoAstResult);
        Objects.requireNonNull(queryEnvironment);
        return AcceleoTextDocument.validate(queryEnvironment, acceleoAstResult, qualifiedName);
    }

    public AcceleoLanguageServer getLanguageServer() {
        if (this.getProject() != null) {
            return this.getProject().getLanguageServer();
        }
        return null;
    }

    public AcceleoTextDocumentService getTextDocumentService() {
        AcceleoLanguageServer languageServer = this.getLanguageServer();
        if (languageServer != null) {
            return languageServer.getTextDocumentService();
        }
        return null;
    }

    public void publishValidationResults() {
        AcceleoTextDocumentService service = this.getTextDocumentService();
        if (service != null) {
            service.publishValidationResults(this);
        }
    }

    public void validateAndPublishResults() {
        this.validateContents();
        this.publishValidationResults();
    }

    public String getModuleQualifiedName() {
        return this.qualifiedName;
    }

    public List<LocationLink> getDefinitionLocations(int position) {
        return this.getDeclarationLocations(position);
    }

    public List<LocationLink> getDeclarationLocations(int position) {
        ArrayList<LocationLink> declarationLocations = new ArrayList<LocationLink>();
        ASTNode acceleoOrAqlNodeUnderCursor = this.acceleoAstResult.getAstNode(position);
        Object originSelectionRange = acceleoOrAqlNodeUnderCursor instanceof VarRef ? LocationUtils.identifierRange(this.acceleoValidationResult, (ASTNode)((VarRef)acceleoOrAqlNodeUnderCursor)) : (acceleoOrAqlNodeUnderCursor instanceof Call ? LocationUtils.identifierRange(this.acceleoValidationResult, (ASTNode)((Call)acceleoOrAqlNodeUnderCursor)) : (acceleoOrAqlNodeUnderCursor instanceof ModuleReference ? LocationUtils.range(this.acceleoValidationResult, (ASTNode)((ModuleReference)acceleoOrAqlNodeUnderCursor)) : null));
        IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
        List<Object> declarations = this.getDeclaration((EObject)acceleoOrAqlNodeUnderCursor);
        for (Object declaration : declarations) {
            LocationLink locationLink;
            ISourceLocation sourceLocation;
            if (declaration instanceof Declaration) {
                Declaration aqlDeclaration = (Declaration)declaration;
                declarationLocations.add(this.getDeclarationLocation((Range)originSelectionRange, aqlDeclaration));
                continue;
            }
            if (declaration instanceof Variable) {
                Variable variable = (Variable)declaration;
                declarationLocations.add(this.getDeclarationLocation((Range)originSelectionRange, variable));
                continue;
            }
            if (declaration instanceof IService) {
                IService service = (IService)declaration;
                sourceLocation = resolver.getSourceLocation(service);
                if (sourceLocation == null) continue;
                locationLink = new LocationLink(this.getUri().toASCIIString(), LocationUtils.range(sourceLocation), LocationUtils.identifierRange(sourceLocation));
                locationLink.setOriginSelectionRange(originSelectionRange);
                locationLink.setTargetUri(sourceLocation.getSourceURI().toASCIIString());
                declarationLocations.add(locationLink);
                continue;
            }
            String declarationQualifiedName = declaration instanceof Module ? ((Module)declaration).eResource().getURI().toString().substring("acceleoenv::".length()) : resolver.getQualifiedName(declaration);
            sourceLocation = resolver.getSourceLocation(declarationQualifiedName);
            locationLink = new LocationLink(this.getUri().toASCIIString(), LocationUtils.range(sourceLocation), LocationUtils.identifierRange(sourceLocation));
            locationLink.setOriginSelectionRange(originSelectionRange);
            locationLink.setTargetUri(sourceLocation.getSourceURI().toASCIIString());
            declarationLocations.add(locationLink);
        }
        return declarationLocations;
    }

    private LocationLink getDeclarationLocation(Range originSelectionRange, Variable variable) {
        Range identifierRange = LocationUtils.identifierRange(this.acceleoValidationResult, (ASTNode)variable);
        Range range = LocationUtils.range(this.acceleoValidationResult, (ASTNode)variable);
        LocationLink locationLink = new LocationLink(this.getUri().toASCIIString(), range, identifierRange);
        locationLink.setOriginSelectionRange(originSelectionRange);
        locationLink.setTargetUri(this.getUri().toASCIIString());
        return locationLink;
    }

    private LocationLink getDeclarationLocation(Range originSelectionRange, Declaration declaration) {
        Range identifierRange = LocationUtils.identifierRange(this.acceleoValidationResult, (ASTNode)declaration);
        Range range = LocationUtils.range(this.acceleoValidationResult, (ASTNode)declaration);
        LocationLink locationLink = new LocationLink(this.getUri().toASCIIString(), range, identifierRange);
        locationLink.setOriginSelectionRange(originSelectionRange);
        locationLink.setTargetUri(this.getUri().toASCIIString());
        return locationLink;
    }

    private List<Object> getDeclaration(EObject eObject) {
        DeclarationSwitch declarationSwitch = new DeclarationSwitch(this.acceleoValidationResult, this.queryEnvironment);
        return declarationSwitch.getDeclarations(eObject);
    }

    public List<Location> getReferencesLocations(int position) {
        ArrayList<Location> referencesLocations = new ArrayList<Location>();
        ASTNode acceleoOrAqlNodeUnderCursor = this.acceleoAstResult.getAstNode(position);
        List<Object> declarations = this.getDeclaration((EObject)acceleoOrAqlNodeUnderCursor);
        for (Object declaration : declarations) {
            Location location;
            if (declaration instanceof Declaration) {
                for (VarRef varRef : this.acceleoValidationResult.getResolvedVarRef((Declaration)declaration)) {
                    location = LocationUtils.identifierLocation(this.queryEnvironment, this.getModuleQualifiedName(), this.acceleoValidationResult, (ASTNode)varRef);
                    referencesLocations.add(location);
                }
                continue;
            }
            if (declaration instanceof Variable) {
                for (VarRef varRef : this.acceleoValidationResult.getResolvedVarRef((Variable)declaration)) {
                    location = LocationUtils.identifierLocation(this.queryEnvironment, this.getModuleQualifiedName(), this.acceleoValidationResult, (ASTNode)varRef);
                    referencesLocations.add(location);
                }
                continue;
            }
            if (declaration instanceof IService) {
                String featureName;
                Set featuresPossibleTypes;
                IService service = (IService)declaration;
                IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
                AcceleoWorkspace workspace = this.getProject().getWorkspace();
                LinkedHashSet<String> qualifiedNames = new LinkedHashSet<String>();
                String serviceContextQualifiedName = resolver.getContextQualifiedName(service);
                if ("aqlFeatureAccess".equals(service.getName())) {
                    Call originalCall = (Call)acceleoOrAqlNodeUnderCursor.eContainer();
                    Expression receiver = (Expression)originalCall.getArguments().get(0);
                    featuresPossibleTypes = this.acceleoValidationResult.getPossibleTypes(receiver);
                    featureName = ((StringLiteral)originalCall.getArguments().get(1)).getValue();
                } else {
                    featuresPossibleTypes = null;
                    featureName = null;
                }
                if (serviceContextQualifiedName != null) {
                    if (serviceContextQualifiedName.startsWith("_reserved_::to::validate::")) {
                        serviceContextQualifiedName = serviceContextQualifiedName.substring("_reserved_::to::validate::".length());
                    }
                    qualifiedNames.add(serviceContextQualifiedName);
                    qualifiedNames.addAll(resolver.getDependOn(serviceContextQualifiedName));
                } else {
                    qualifiedNames.addAll(workspace.getAllTextDocuments().stream().map(d -> d.getModuleQualifiedName()).collect(Collectors.toList()));
                }
                for (String dependentQualifiedName : qualifiedNames) {
                    URI sourceURI = resolver.getSourceURI(dependentQualifiedName);
                    AcceleoTextDocument document = workspace.getTextDocument(sourceURI);
                    if (document == null) continue;
                    referencesLocations.addAll(document.getLocalCallLocations(featuresPossibleTypes, featureName, service));
                }
                continue;
            }
            IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
            AcceleoWorkspace workspace = this.getProject().getWorkspace();
            String declarationQualifiedName = declaration instanceof Module ? ((Module)declaration).eResource().getURI().toString().substring("acceleoenv::".length()) : resolver.getQualifiedName(declaration);
            if (declarationQualifiedName == null) continue;
            for (String dependentQualifiedName : resolver.getDependOn(declarationQualifiedName)) {
                URI sourceURI = resolver.getSourceURI(dependentQualifiedName);
                AcceleoTextDocument document = workspace.getTextDocument(sourceURI);
                if (document == null) continue;
                Module module = document.getAcceleoAstResult().getModule();
                if (module.getExtends() != null && declarationQualifiedName.equals(module.getExtends().getQualifiedName())) {
                    Location location2 = LocationUtils.location(this.queryEnvironment, dependentQualifiedName, document.getAcceleoValidationResults(), (ASTNode)module.getExtends());
                    referencesLocations.add(location2);
                    continue;
                }
                for (Import imported : module.getImports()) {
                    if (!declarationQualifiedName.equals(imported.getModule().getQualifiedName())) continue;
                    Location location3 = LocationUtils.location(this.queryEnvironment, dependentQualifiedName, document.getAcceleoValidationResults(), (ASTNode)imported.getModule());
                    referencesLocations.add(location3);
                }
            }
        }
        return referencesLocations;
    }

    private boolean isCompatibleAqlFeatureAccess(Set<IType> featuresPossibleTypes, String featureName, Call call) {
        boolean res = false;
        Expression receiver = (Expression)call.getArguments().get(0);
        Set receiverTypes = this.acceleoValidationResult.getPossibleTypes(receiver);
        if (call.getArguments().size() == 2 && featureName.equals(((StringLiteral)call.getArguments().get(1)).getValue())) {
            block0: for (IType featuresPossibleType : featuresPossibleTypes) {
                for (IType receiverType : receiverTypes) {
                    if (!featuresPossibleType.isAssignableFrom(receiverType)) continue;
                    res = true;
                    break block0;
                }
            }
        }
        return res;
    }

    public List<Location> getLocalCallLocations(Set<IType> featuresPossibleTypes, String featureName, IService<?> service) {
        ArrayList<Location> referencesLocations = new ArrayList<Location>();
        List resolvedCalls = this.acceleoValidationResult.getResolvedCalls(service);
        for (Call call : resolvedCalls) {
            Location location;
            if (featureName != null && featuresPossibleTypes != null) {
                if (!this.isCompatibleAqlFeatureAccess(featuresPossibleTypes, featureName, call)) continue;
                location = LocationUtils.identifierLocation(this.queryEnvironment, this.getModuleQualifiedName(), this.acceleoValidationResult, (ASTNode)call);
                referencesLocations.add(location);
                continue;
            }
            location = LocationUtils.identifierLocation(this.queryEnvironment, this.getModuleQualifiedName(), this.acceleoValidationResult, (ASTNode)call);
            referencesLocations.add(location);
        }
        return referencesLocations;
    }

    public URI getUri() {
        return this.uri;
    }

    public AcceleoTextDocument applyChanges(Iterable<TextDocumentContentChangeEvent> textDocumentContentchangeEvents) {
        String newTextDocumentContents = this.contents;
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : textDocumentContentchangeEvents) {
            newTextDocumentContents = AcceleoTextDocument.apply(textDocumentContentChangeEvent, newTextDocumentContents);
        }
        this.setContents(newTextDocumentContents);
        return this;
    }

    public void setContents(String newTextDocumentContents) {
        this.contents = newTextDocumentContents;
        this.documentChanged();
    }

    public AcceleoAstResult getAcceleoAstResult() {
        return this.acceleoAstResult;
    }

    public IAcceleoValidationResult getAcceleoValidationResults() {
        return this.acceleoValidationResult;
    }

    public IQualifiedNameQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }

    public String getContents() {
        return this.contents;
    }

    private static synchronized IAcceleoValidationResult validate(IQualifiedNameQueryEnvironment queryEnvironment, AcceleoAstResult acceleoAstResult, String qualifiedName) {
        String moduleQualifiedNameForValidation = "_reserved_::to::validate::" + qualifiedName;
        IQualifiedNameResolver resolver = queryEnvironment.getLookupEngine().getResolver();
        resolver.register(moduleQualifiedNameForValidation, (Object)acceleoAstResult.getModule());
        try {
            IAcceleoValidationResult validationResults;
            AcceleoValidator acceleoValidator = new AcceleoValidator(queryEnvironment);
            IAcceleoValidationResult iAcceleoValidationResult = validationResults = acceleoValidator.validate(acceleoAstResult, moduleQualifiedNameForValidation);
            return iAcceleoValidationResult;
        }
        finally {
            resolver.clear(Collections.singleton(moduleQualifiedNameForValidation));
        }
    }

    private static String apply(TextDocumentContentChangeEvent textDocumentContentChangeEvent, String inText) {
        String newTextExcerpt = textDocumentContentChangeEvent.getText();
        Range changeRange = textDocumentContentChangeEvent.getRange();
        if (changeRange == null) {
            return newTextExcerpt;
        }
        return AcceleoLanguageServerPositionUtils.replace(inText, changeRange.getStart(), changeRange.getEnd(), newTextExcerpt);
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void setOpened(boolean opened) {
        this.isOpened = opened;
    }
}

